/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.base.Strings;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;
import shetiphian.core.common.Function;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16Helper;

public class RecipeHelper {
    private final String modId;
    private final Logger errorLog;

    public RecipeHelper(String modId, Logger logger) {
        this.modId = modId;
        this.errorLog = logger;
    }

    public void addShapelessRecipe(String name, ItemStack result, String group, Object ... recipe) {
        this.addShapelessRecipe(name, result, this.getGroupResource(group), recipe);
    }

    public void addShapelessRecipe(String name, ItemStack result, ResourceLocation group, Object ... recipe) {
        ShapelessOreRecipe irecipe = null;
        try {
            irecipe = new ShapelessOreRecipe(group, result, recipe);
        }
        catch (Exception error) {
            this.errorLog.error("Invalid ShapelessOreRecipe: Error Returned = " + error);
        }
        if (irecipe != null) {
            this.addRecipe(name, (IRecipe)irecipe);
        }
    }

    public void addShapedRecipe(String name, ItemStack result, String group, Object ... recipe) {
        this.addShapedRecipe(name, result, this.getGroupResource(group), recipe);
    }

    public void addShapedRecipe(String name, ItemStack result, ResourceLocation group, Object ... recipe) {
        ShapedOreRecipe irecipe = null;
        try {
            irecipe = new ShapedOreRecipe(group, result, recipe);
        }
        catch (Exception error) {
            this.errorLog.error("Invalid ShapedOreRecipe: Error Returned = " + error);
        }
        if (irecipe != null) {
            this.addRecipe(name, (IRecipe)irecipe);
        }
    }

    private String getGroupName(String group) {
        if (!Strings.isNullOrEmpty((String)group)) {
            if (group.contains(":")) {
                return group;
            }
            return this.modId + group;
        }
        return "";
    }

    private ResourceLocation getGroupResource(String group) {
        String groupName = this.getGroupName(group);
        return !Strings.isNullOrEmpty((String)groupName) ? new ResourceLocation(groupName) : null;
    }

    public void addRecipe(String name, IRecipe recipe) {
        try {
            recipe.setRegistryName(new ResourceLocation(this.modId, name));
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
        }
        catch (Exception error) {
            this.errorLog.error("Invalid IRecipe: Error Returned = " + error);
        }
    }

    public void addColoredRecipes(String name, ItemStack baseStack) {
        if (baseStack.func_77973_b() instanceof IRGB16_Item) {
            ResourceLocation group = new ResourceLocation(this.modId, name);
            ItemStack coloredStack = baseStack.func_77946_l();
            for (int index = 0; index < 16; ++index) {
                String dye = Function.dyeNamesBW[index];
                ((IRGB16_Item)coloredStack.func_77973_b()).setRGB16(coloredStack, RGB16Helper.getIndexFor(dye));
                this.addShapelessRecipe(name + "_" + EnumDyeColor.func_176766_a((int)index).func_176610_l(), coloredStack, group, dye, baseStack);
            }
        }
    }

    public void addSmelting(ItemStack result, ItemStack input, float experience) {
        if (!result.func_190926_b() && !input.func_190926_b()) {
            FurnaceRecipes.func_77602_a().func_151394_a(input, result, experience);
        } else {
            this.errorLog.error("Invalid FurnaceRecipe: " + input + " > " + result);
        }
    }

    @Deprecated
    public void remove(ItemStack findItem, int recipeSize, boolean isShapeless, boolean isShaped) {
        System.err.println("TODO: ShetiPhianCore, RecipeHelper.remove");
    }
}

