/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.common.chunk.assembly;

import com.elytradev.movingworld.MovingWorldMod;
import com.elytradev.movingworld.common.chunk.LocatedBlock;
import com.elytradev.movingworld.common.chunk.MovingWorldAssemblyInteractor;
import com.elytradev.movingworld.common.entity.EntityMovingWorld;
import com.elytradev.movingworld.common.tile.TileMovingMarkingBlock;
import com.elytradev.movingworld.common.util.LocatedBlockList;
import com.elytradev.movingworld.common.util.MaterialDensity;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class AssembleResult {
    public final LocatedBlockList assembledBlocks = new LocatedBlockList();
    public BlockPos offset;
    public MovingWorldAssemblyInteractor assemblyInteractor;
    LocatedBlock movingWorldMarkingBlock;
    ResultType resultType;
    int blockCount;
    int tileEntityCount;
    float mass;

    public AssembleResult(ResultType resultCode, ByteBuf buf) {
        this.resultType = resultCode;
        if (resultCode == ResultType.RESULT_NONE) {
            return;
        }
        this.blockCount = buf.readInt();
        this.tileEntityCount = buf.readInt();
        this.mass = buf.readFloat();
    }

    public AssembleResult(NBTTagCompound tag, World world) {
        this.resultType = ResultType.fromByte(tag.func_74771_c("res"));
        this.blockCount = tag.func_74762_e("blockc");
        this.tileEntityCount = tag.func_74762_e("tec");
        this.mass = tag.func_74760_g("mass");
        this.offset = new BlockPos(-tag.func_74762_e("xO"), tag.func_74762_e("yO"), tag.func_74762_e("zO"));
        if (tag.func_74764_b("list")) {
            NBTTagList list = tag.func_150295_c("list", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound comp = list.func_150305_b(i);
                this.assembledBlocks.add(new LocatedBlock(comp, world));
            }
        }
        if (tag.func_74764_b("marker")) {
            NBTTagCompound comp = tag.func_74775_l("marker");
            this.movingWorldMarkingBlock = new LocatedBlock(comp, world);
        }
    }

    AssembleResult() {
        this.clear();
    }

    void assembleBlock(LocatedBlock lb) {
        this.assembledBlocks.add(lb);
        this.blockCount = this.assembledBlocks.size();
        if (lb.tileEntity != null) {
            ++this.tileEntityCount;
        }
        this.mass += MaterialDensity.getDensity(lb.blockState);
        this.offset = new BlockPos(Math.min(this.offset.func_177958_n(), lb.blockPos.func_177958_n()), Math.min(this.offset.func_177956_o(), lb.blockPos.func_177956_o()), Math.min(this.offset.func_177952_p(), lb.blockPos.func_177952_p()));
    }

    public void clear() {
        this.resultType = ResultType.RESULT_NONE;
        this.movingWorldMarkingBlock = null;
        this.assembledBlocks.clear();
        this.offset = new BlockPos((Vec3i)BlockPos.field_177992_a);
    }

    public EntityMovingWorld getEntity(World world, EntityMovingWorld entity) {
        if (!this.isOK()) {
            return null;
        }
        if (entity == null) {
            MovingWorldMod.LOG.error("A null movingWorld was attempted!");
            return null;
        }
        EnumFacing facing = this.assemblyInteractor.getFrontDirection(this.movingWorldMarkingBlock);
        BlockPos riderDestination = new BlockPos(this.movingWorldMarkingBlock.blockPos.func_177958_n() - this.offset.func_177958_n(), this.movingWorldMarkingBlock.blockPos.func_177956_o() - this.offset.func_177956_o(), this.movingWorldMarkingBlock.blockPos.func_177952_p() - this.offset.func_177952_p());
        entity.setRiderDestination(facing, riderDestination);
        entity.getMobileChunk().setCreationSpotBiomeGen(world.func_180494_b(this.movingWorldMarkingBlock.blockPos));
        boolean doTileDropsInWorld = world.func_82736_K().func_82766_b("doTileDrops");
        world.func_82736_K().func_82764_b("doTileDrops", "false");
        ArrayList<LocatedBlockList> separatedLbLists = this.assembledBlocks.getSortedAssemblyBlocks();
        try {
            for (LocatedBlockList locatedBlockList : separatedLbLists) {
                if (locatedBlockList == null || locatedBlockList.isEmpty()) continue;
                this.setWorldBlocksToAir(world, entity, locatedBlockList);
            }
        }
        catch (Exception e) {
            this.resultType = ResultType.RESULT_ERROR_OCCURED;
            world.func_82736_K().func_82764_b("doTileDrops", String.valueOf(doTileDropsInWorld));
            MovingWorldMod.LOG.error("Result code: RESULT ERROR OCCURRED was reached when attempting to getEntity from assembly result. Printing stacktrace...");
            MovingWorldMod.LOG.error((Object)e);
            e.printStackTrace();
            return null;
        }
        world.func_82736_K().func_82764_b("doTileDrops", String.valueOf(doTileDropsInWorld));
        entity.getMobileChunk().setChunkModified();
        entity.getMobileChunk().onChunkLoad();
        entity.func_70012_b((float)this.offset.func_177958_n() + entity.getMobileChunk().getCenterX(), this.offset.func_177956_o(), (float)this.offset.func_177952_p() + entity.getMobileChunk().getCenterZ(), 0.0f, 0.0f);
        entity.assembleResultEntity();
        return entity;
    }

    public void setWorldBlocksToAir(World world, EntityMovingWorld entityMovingWorld, LocatedBlockList locatedBlocks) {
        boolean setFluids = false;
        LocatedBlockList setAirState2 = new LocatedBlockList();
        if (this.movingWorldMarkingBlock != null && this.movingWorldMarkingBlock.tileEntity instanceof TileMovingMarkingBlock && ((TileMovingMarkingBlock)this.movingWorldMarkingBlock.tileEntity).removedFluidBlocks != null && !((TileMovingMarkingBlock)this.movingWorldMarkingBlock.tileEntity).removedFluidBlocks.isEmpty()) {
            setFluids = true;
        }
        for (LocatedBlock lb : locatedBlocks) {
            BlockPos iPos = new BlockPos(lb.blockPos.func_177958_n() - this.offset.func_177958_n(), lb.blockPos.func_177956_o() - this.offset.func_177956_o(), lb.blockPos.func_177952_p() - this.offset.func_177952_p());
            TileEntity tileentity = lb.tileEntity;
            if (tileentity != null || lb.blockState.func_177230_c().hasTileEntity(lb.blockState) && (tileentity = world.func_175625_s(lb.blockPos)) != null) {
                tileentity.func_145829_t();
            }
            if (!entityMovingWorld.getMobileChunk().addBlockWithState(iPos, lb.blockState)) continue;
            if (lb.tileEntity != null && this.movingWorldMarkingBlock.tileEntity != null && lb.blockPos.equals((Object)this.movingWorldMarkingBlock.blockPos)) {
                entityMovingWorld.getMobileChunk().marker = lb;
            }
            setAirState2.add(lb);
            entityMovingWorld.getMobileChunk().setTileEntity(iPos, tileentity);
        }
        for (LocatedBlock lb : setAirState2) {
            try {
                world.func_175713_t(lb.blockPos);
                world.func_180501_a(lb.blockPos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            catch (Exception e) {
                MovingWorldMod.LOG.warn("Failed to remove a block from the world, forcing...", (Throwable)e);
                this.forceBlockRemoval(world, lb);
            }
        }
        for (LocatedBlock lb : locatedBlocks) {
            try {
                world.func_175713_t(lb.blockPos);
                world.func_175698_g(lb.blockPos);
            }
            catch (Exception e) {
                MovingWorldMod.LOG.warn("Failed to remove a block from the world, forcing...", (Throwable)e);
                this.forceBlockRemoval(world, lb);
            }
        }
        if (setFluids) {
            ((TileMovingMarkingBlock)this.movingWorldMarkingBlock.tileEntity).removedFluidBlocks.stream().filter(fluid -> fluid != null && world.func_175623_d(fluid.blockPos)).forEach(fluid -> world.func_180501_a(fluid.blockPos, fluid.blockState, 2));
            ((TileMovingMarkingBlock)this.movingWorldMarkingBlock.tileEntity).removedFluidBlocks.stream().filter(fluid -> fluid != null && world.func_175623_d(fluid.blockPos)).forEach(fluid -> world.func_180501_a(fluid.blockPos, fluid.blockState, 3));
        }
    }

    private void forceBlockRemoval(World world, LocatedBlock block) {
        world.func_175690_a(block.blockPos, null);
        try {
            world.func_180501_a(block.blockPos, Blocks.field_150350_a.func_176223_P(), 2);
        }
        catch (Exception e) {
            MovingWorldMod.LOG.warn("Caught exception when removing a block from the world, attempting fallback method...", (Throwable)e);
            try {
                world.func_175698_g(block.blockPos);
            }
            catch (Exception secondE) {
                MovingWorldMod.LOG.warn("Fallback failed, attempting manual removal without telling the block about it...", (Throwable)secondE);
                try {
                    Chunk chunk = world.func_175726_f(block.blockPos);
                    ExtendedBlockStorage blockStorage = chunk.func_76587_i()[block.blockPos.func_177956_o() >> 4];
                    blockStorage.func_177484_a(block.blockPos.func_177958_n() & 0xF, block.blockPos.func_177956_o() >> 4, block.blockPos.func_177952_p() & 0xF, Blocks.field_150350_a.func_176223_P());
                    chunk.func_76630_e();
                    world.func_175698_g(block.blockPos);
                }
                catch (Exception thirdE) {
                    MovingWorldMod.LOG.error("At this point I don't really know what to tell you, I've done everything I could yet I still failed.", (Throwable)thirdE);
                    throw thirdE;
                }
            }
        }
    }

    public ResultType getType() {
        return this.resultType;
    }

    public boolean isOK() {
        return this.resultType == ResultType.RESULT_OK || this.resultType == ResultType.RESULT_OK_WITH_WARNINGS;
    }

    public LocatedBlock getShipMarker() {
        return this.movingWorldMarkingBlock;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public int getTileEntityCount() {
        return this.tileEntityCount;
    }

    public float getMass() {
        return this.mass;
    }

    public void checkConsistent(World world) {
        boolean warn = false;
        for (LocatedBlock lb : this.assembledBlocks) {
            IBlockState blockState = world.func_180495_p(lb.blockPos);
            Block block = blockState.func_177230_c();
            if (block != lb.blockState.func_177230_c()) {
                this.resultType = ResultType.RESULT_INCONSISTENT;
                return;
            }
            if (blockState == lb.blockState) continue;
            warn = true;
        }
        this.resultType = warn ? ResultType.RESULT_OK_WITH_WARNINGS : ResultType.RESULT_OK;
    }

    public void writeNBTFully(NBTTagCompound tag) {
        this.writeNBTMetadata(tag);
        NBTTagList list = new NBTTagList();
        for (LocatedBlock lb : this.assembledBlocks) {
            NBTTagCompound comp = new NBTTagCompound();
            lb.writeToNBT(comp);
            list.func_74742_a((NBTBase)comp);
        }
        tag.func_74782_a("list", (NBTBase)list);
        if (this.movingWorldMarkingBlock != null) {
            NBTTagCompound comp = new NBTTagCompound();
            this.movingWorldMarkingBlock.writeToNBT(comp);
            tag.func_74782_a("marker", (NBTBase)comp);
        }
    }

    public void writeNBTMetadata(NBTTagCompound tag) {
        tag.func_74774_a("res", this.getType().toByte());
        tag.func_74768_a("blockc", this.getBlockCount());
        tag.func_74768_a("tec", this.getTileEntityCount());
        tag.func_74776_a("mass", this.getMass());
        tag.func_74768_a("xO", this.offset.func_177958_n());
        tag.func_74768_a("yO", this.offset.func_177956_o());
        tag.func_74768_a("zO", this.offset.func_177952_p());
    }

    public ByteBuf toByteBuf(ByteBuf buf) {
        buf.writeByte((int)this.getType().toByte());
        buf.writeInt(this.getBlockCount());
        buf.writeInt(this.getTileEntityCount());
        buf.writeFloat(this.getMass());
        if (this.assemblyInteractor != null) {
            this.assemblyInteractor.toByteBuf(buf);
        }
        return buf;
    }

    public static enum ResultType {
        RESULT_NONE,
        RESULT_OK,
        RESULT_BLOCK_OVERFLOW,
        RESULT_MISSING_MARKER,
        RESULT_ERROR_OCCURED,
        RESULT_BUSY_COMPILING,
        RESULT_INCONSISTENT,
        RESULT_OK_WITH_WARNINGS;


        public static byte toByte(ResultType action) {
            switch (action) {
                case RESULT_OK: {
                    return 1;
                }
                case RESULT_BLOCK_OVERFLOW: {
                    return 2;
                }
                case RESULT_MISSING_MARKER: {
                    return 3;
                }
                case RESULT_ERROR_OCCURED: {
                    return 4;
                }
                case RESULT_BUSY_COMPILING: {
                    return 5;
                }
                case RESULT_INCONSISTENT: {
                    return 6;
                }
                case RESULT_OK_WITH_WARNINGS: {
                    return 7;
                }
            }
            return 0;
        }

        public static ResultType fromByte(byte actionInt) {
            switch (actionInt) {
                case 1: {
                    return RESULT_OK;
                }
                case 2: {
                    return RESULT_BLOCK_OVERFLOW;
                }
                case 3: {
                    return RESULT_MISSING_MARKER;
                }
                case 4: {
                    return RESULT_ERROR_OCCURED;
                }
                case 5: {
                    return RESULT_BUSY_COMPILING;
                }
                case 6: {
                    return RESULT_INCONSISTENT;
                }
                case 7: {
                    return RESULT_OK_WITH_WARNINGS;
                }
            }
            return RESULT_NONE;
        }

        public byte toByte() {
            return ResultType.toByte(this);
        }
    }
}

