/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.common.chunk.assembly;

import com.elytradev.movingworld.MovingWorldMod;
import com.elytradev.movingworld.api.IMovingTile;
import com.elytradev.movingworld.common.chunk.LocatedBlock;
import com.elytradev.movingworld.common.chunk.MovingWorldAssemblyInteractor;
import com.elytradev.movingworld.common.chunk.assembly.AssembleResult;
import com.elytradev.movingworld.common.chunk.mobilechunk.MobileChunk;
import com.elytradev.movingworld.common.entity.EntityMovingWorld;
import com.elytradev.movingworld.common.event.DisassembleBlockEvent;
import com.elytradev.movingworld.common.tile.TileMovingMarkingBlock;
import com.elytradev.movingworld.common.util.FloodFiller;
import com.elytradev.movingworld.common.util.LocatedBlockList;
import com.elytradev.movingworld.common.util.MathHelperMod;
import com.elytradev.movingworld.common.util.RotationHelper;
import com.elytradev.movingworld.common.util.Vec3dMod;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkDisassembler {
    public boolean overwrite;
    private EntityMovingWorld movingWorld;
    private AssembleResult result;
    private LocatedBlockList removedFluidBlocks;
    private TileMovingMarkingBlock tileMarker;

    public ChunkDisassembler(EntityMovingWorld EntityMovingWorld2) {
        this.movingWorld = EntityMovingWorld2;
        this.overwrite = false;
    }

    public boolean canDisassemble(MovingWorldAssemblyInteractor assemblyInteractor) {
        if (this.overwrite) {
            return true;
        }
        World world = this.movingWorld.field_70170_p;
        MobileChunk chunk = this.movingWorld.getMobileChunk();
        float yaw = (float)Math.round(this.movingWorld.field_70177_z / 90.0f) * 90.0f;
        yaw = (float)Math.toRadians(yaw);
        float ox = -chunk.getCenterX();
        float oy = -chunk.minY();
        float oz = -chunk.getCenterZ();
        for (int i = chunk.minX(); i < chunk.maxX(); ++i) {
            for (int j = chunk.minY(); j < chunk.maxY(); ++j) {
                for (int k = chunk.minZ(); k < chunk.maxZ(); ++k) {
                    if (chunk.func_175623_d(new BlockPos(i, j, k))) continue;
                    Vec3dMod vec = new Vec3dMod((float)i + ox, (float)j + oy, (float)k + oz);
                    vec = vec.rotateAroundY(yaw);
                    BlockPos pos = new BlockPos(MathHelperMod.round_double(vec.field_72450_a + this.movingWorld.field_70165_t), MathHelperMod.round_double(vec.field_72448_b + this.movingWorld.field_70163_u), MathHelperMod.round_double(vec.field_72449_c + this.movingWorld.field_70161_v));
                    IBlockState state = world.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if ((block == null || block.isAir(state, (IBlockAccess)world, pos) || block.func_149688_o(state).func_76224_d() || assemblyInteractor.canOverwriteState(state)) && MathHelperMod.round_double(vec.field_72448_b + this.movingWorld.field_70163_u) <= world.func_72940_L()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public AssembleResult doDisassemble(MovingWorldAssemblyInteractor assemblyInteractor) {
        BlockPos pos;
        this.movingWorld.disassembling = true;
        this.tileMarker = null;
        if (this.movingWorld.getMobileChunk().marker != null && this.movingWorld.getMobileChunk().marker.tileEntity instanceof TileMovingMarkingBlock) {
            this.tileMarker = (TileMovingMarkingBlock)this.movingWorld.getMobileChunk().marker.tileEntity;
        }
        this.removedFluidBlocks = new LocatedBlockList();
        World world = this.movingWorld.func_130014_f_();
        MobileChunk chunk = this.movingWorld.getMobileChunk();
        LocatedBlockList fillableBlocks = new FloodFiller().floodFillMobileChunk(chunk);
        this.result = new AssembleResult();
        this.result.offset = new BlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        int currentRot = Math.round(this.movingWorld.field_70177_z / 90.0f);
        this.movingWorld.field_70177_z = (float)currentRot * 90.0f;
        this.movingWorld.field_70125_A = 0.0f;
        float yaw = (float)currentRot * 1.5707964f;
        boolean flag = world.func_82736_K().func_82766_b("doTileDrops");
        world.func_82736_K().func_82764_b("doTileDrops", "false");
        LocatedBlockList postList = new LocatedBlockList(4);
        float ox = -chunk.getCenterX();
        float oy = -chunk.minY();
        float oz = -chunk.getCenterZ();
        LocatedBlockList lbList = new LocatedBlockList();
        try {
            for (int i = chunk.minX(); i < chunk.maxX(); ++i) {
                for (int j = chunk.minY(); j < chunk.maxY(); ++j) {
                    for (int k = chunk.minZ(); k < chunk.maxZ(); ++k) {
                        IBlockState blockState = chunk.func_180495_p(new BlockPos(i, j, k));
                        if (blockState.func_177230_c() == Blocks.field_150350_a ? blockState.func_177230_c().func_176201_c(blockState) == 1 : blockState.func_177230_c().isAir(blockState, (IBlockAccess)world, new BlockPos(i, j, k))) continue;
                        TileEntity tileentity = chunk.func_175625_s(new BlockPos(i, j, k));
                        Vec3dMod vec = new Vec3dMod((float)i + ox, (float)j + oy, (float)k + oz);
                        vec = vec.rotateAroundY(yaw);
                        pos = new BlockPos(MathHelperMod.round_double(vec.field_72450_a + this.movingWorld.field_70165_t), MathHelperMod.round_double(vec.field_72448_b + this.movingWorld.field_70163_u), MathHelperMod.round_double(vec.field_72449_c + this.movingWorld.field_70161_v));
                        lbList.add(new LocatedBlock(blockState, tileentity, pos, new BlockPos(i, j, k)));
                    }
                }
            }
            ArrayList<LocatedBlockList> separatedLbLists = lbList.getSortedDisassemblyBlocks();
            for (LocatedBlockList locatedBlockList : separatedLbLists) {
                if (locatedBlockList == null || locatedBlockList.isEmpty()) continue;
                postList = this.processLocatedBlockList(world, locatedBlockList, postList, assemblyInteractor, fillableBlocks, currentRot);
            }
        }
        catch (Exception exception) {
            world.func_82736_K().func_82764_b("doTileDrops", String.valueOf(flag));
            MovingWorldMod.LOG.error("Exception while disassembling, reverting doTileDrops... ", (Throwable)exception);
            this.result.resultType = AssembleResult.ResultType.RESULT_ERROR_OCCURED;
            return this.result;
        }
        world.func_82736_K().func_82764_b("doTileDrops", String.valueOf(flag));
        ArrayList<LocatedBlockList> sortedPostList = postList.getSortedDisassemblyBlocks();
        for (LocatedBlockList pList : sortedPostList) {
            if (pList == null || pList.isEmpty()) continue;
            for (LocatedBlock locatedBlockInstance : pList) {
                pos = locatedBlockInstance.blockPos;
                MovingWorldMod.LOG.debug("Post-rejoining block: " + locatedBlockInstance.toString());
                world.func_180501_a(pos, locatedBlockInstance.blockState, 2);
                assemblyInteractor.blockDisassembled(locatedBlockInstance);
                DisassembleBlockEvent event = new DisassembleBlockEvent(this.movingWorld, locatedBlockInstance);
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.result.assembleBlock(locatedBlockInstance);
            }
        }
        if (this.tileMarker != null) {
            this.tileMarker.removedFluidBlocks = this.removedFluidBlocks;
        }
        this.movingWorld.func_70106_y();
        if (this.result.movingWorldMarkingBlock == null || !assemblyInteractor.isTileMovingWorldMarker(this.result.movingWorldMarkingBlock.tileEntity)) {
            this.result.resultType = AssembleResult.ResultType.RESULT_MISSING_MARKER;
        } else {
            this.result.checkConsistent(world);
        }
        assemblyInteractor.chunkDissasembled(this.result);
        this.result.assemblyInteractor = assemblyInteractor;
        return this.result;
    }

    LocatedBlockList processLocatedBlockList(World world, LocatedBlockList locatedBlocks, LocatedBlockList postList, MovingWorldAssemblyInteractor assemblyInteractor, LocatedBlockList fillList, int currentRot) {
        LocatedBlockList retPostList = new LocatedBlockList();
        retPostList.addAll(postList);
        for (LocatedBlock locatedBlock : locatedBlocks) {
            locatedBlock = this.rotateBlock(locatedBlock, currentRot);
            int i = locatedBlock.bPosNoOffset.func_177958_n();
            int j = locatedBlock.bPosNoOffset.func_177956_o();
            int k = locatedBlock.bPosNoOffset.func_177952_p();
            BlockPos pos = locatedBlock.blockPos;
            IBlockState blockState = locatedBlock.blockState;
            TileEntity tileentity = locatedBlock.tileEntity;
            blockState = assemblyInteractor.blockRotated(blockState, currentRot);
            IBlockState owBlockState = world.func_180495_p(pos);
            Block owBlock = owBlockState.func_177230_c();
            if (owBlock != null) {
                assemblyInteractor.blockOverwritten(owBlock);
            }
            if (!fillList.containsLBOfPos(locatedBlock.bPosNoOffset)) {
                if (world.func_180495_p(pos).func_185904_a().func_76224_d() && !this.removedFluidBlocks.containsLBOfPos(pos)) {
                    this.removedFluidBlocks.add(new LocatedBlock(owBlockState, pos));
                }
                if (!world.func_180501_a(pos, blockState, 2) || blockState.func_177230_c() != world.func_180495_p(pos).func_177230_c()) {
                    retPostList.add(new LocatedBlock(blockState, tileentity, pos));
                    continue;
                }
                if (blockState != world.func_180495_p(pos)) {
                    world.func_180501_a(pos, blockState, 2);
                }
            }
            if (tileentity != null) {
                tileentity.func_174878_a(pos);
                if (tileentity instanceof IMovingTile) {
                    ((IMovingTile)tileentity).setParentMovingWorld(null, new BlockPos(i, j, k));
                }
                NBTTagCompound tileTag = new NBTTagCompound();
                tileentity.func_189515_b(tileTag);
                world.func_175690_a(pos, tileentity);
                world.func_175625_s(pos).func_145839_a(tileTag);
                tileentity.func_145829_t();
                tileentity = world.func_175625_s(pos);
                if (this.tileMarker != null && this.tileMarker.func_174877_v().equals((Object)tileentity.func_174877_v())) {
                    this.tileMarker = (TileMovingMarkingBlock)tileentity;
                }
            }
            blockState = world.func_180495_p(pos);
            tileentity = world.func_175625_s(pos);
            LocatedBlock lb = new LocatedBlock(blockState, tileentity, pos);
            assemblyInteractor.blockDisassembled(lb);
            DisassembleBlockEvent event = new DisassembleBlockEvent(this.movingWorld, lb);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.result.assembleBlock(lb);
        }
        return retPostList;
    }

    private LocatedBlock rotateBlock(LocatedBlock locatedBlock, int deltaRot) {
        if ((deltaRot &= 3) != 0) {
            for (int r = 0; r < deltaRot; ++r) {
                locatedBlock = RotationHelper.rotateBlock(locatedBlock, true);
            }
        }
        return locatedBlock;
    }
}

