/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.common.chunk.mobilechunk;

import com.elytradev.movingworld.MovingWorldMod;
import com.elytradev.movingworld.api.IMovingTile;
import com.elytradev.movingworld.common.chunk.LocatedBlock;
import com.elytradev.movingworld.common.chunk.mobilechunk.world.FakeWorld;
import com.elytradev.movingworld.common.entity.EntityMovingWorld;
import com.elytradev.movingworld.common.util.AABBRotator;
import com.elytradev.movingworld.common.util.Vec3dMod;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.reflect.accessor.Accessor;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.reflect.accessor.Accessors;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class MobileChunk
implements IBlockAccess {
    public static final Accessor<Block> TILE_BLOCK_TYPE = Accessors.findField(TileEntity.class, "blockType", "field_145854_h");
    public static final Accessor<Integer> TILE_METADATA = Accessors.findField(TileEntity.class, "blockMetadata", "field_145847_g");
    public static final int CHUNK_SIZE = 16;
    public static final int CHUNK_MEMORY_USING = 24576;
    public final World world;
    protected final EntityMovingWorld entityMovingWorld;
    public Map<BlockPos, TileEntity> chunkTileEntityMap;
    public List<TileEntity> updatableTiles;
    public boolean isChunkLoaded;
    public boolean isModified;
    public LocatedBlock marker;
    public ArrayList<IMovingTile> movingWorldTileEntities;
    private Map<BlockPos, ExtendedBlockStorage> blockStorageMap;
    private boolean boundsInit;
    private BlockPos minBounds;
    private BlockPos maxBounds;
    private int blockCount;
    private Biome creationSpotBiome;
    private HashBiMap<BlockPos, AxisAlignedBB> boundingBoxes;
    private HashBiMap<BlockPos, AxisAlignedBB> chunkBoundingBoxes;
    private FakeWorld fakeWorld;

    public MobileChunk(World world, EntityMovingWorld entitymovingWorld) {
        this.world = world;
        this.entityMovingWorld = entitymovingWorld;
        this.blockStorageMap = new HashMap<BlockPos, ExtendedBlockStorage>(1);
        this.chunkTileEntityMap = new HashMap<BlockPos, TileEntity>(2);
        this.updatableTiles = new ArrayList<TileEntity>();
        this.boundingBoxes = HashBiMap.create();
        this.chunkBoundingBoxes = HashBiMap.create();
        this.movingWorldTileEntities = new ArrayList();
        this.marker = null;
        this.isChunkLoaded = false;
        this.isModified = false;
        this.boundsInit = false;
        this.minBounds = new BlockPos(-1, -1, -1);
        this.maxBounds = new BlockPos(-1, -1, -1);
        this.blockCount = 0;
        this.creationSpotBiome = Biome.func_150568_d((int)0);
    }

    public FakeWorld getFakeWorld() {
        if (this.fakeWorld != null) {
            return this.fakeWorld;
        }
        this.fakeWorld = FakeWorld.getFakeWorld(this);
        return this.fakeWorld;
    }

    public EntityMovingWorld getEntityMovingWorld() {
        return this.entityMovingWorld;
    }

    public BlockPos getBlockPosFromBounds(AxisAlignedBB bb) {
        return (BlockPos)this.boundingBoxes.inverse().get((Object)bb);
    }

    public Vec3d getWorldPosForChunkPos(BlockPos pos) {
        Vec3d movingWorldPos = new Vec3d(this.entityMovingWorld.field_70165_t, this.entityMovingWorld.field_70163_u, this.entityMovingWorld.field_70161_v);
        movingWorldPos = movingWorldPos.func_178786_a((double)this.maxX() / 2.0, (double)this.maxY() / 2.0, (double)this.maxZ() / 2.0);
        Vec3d returnPos = new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        returnPos.func_178787_e(movingWorldPos);
        return returnPos;
    }

    public Vec3d getWorldPosForChunkPos(Vec3d vec) {
        Vec3d movingWorldPos = new Vec3d(this.entityMovingWorld.field_70165_t, this.entityMovingWorld.field_70163_u, this.entityMovingWorld.field_70161_v);
        movingWorldPos = movingWorldPos.func_178786_a((double)this.maxX() / 2.0, (double)this.maxY() / 2.0, (double)this.maxZ() / 2.0);
        Vec3d returnPos = new Vec3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        returnPos.func_178787_e(movingWorldPos);
        return returnPos;
    }

    public Vec3d getChunkPosForWorldPos(Vec3d pos) {
        Vec3d movingWorldPos = new Vec3d(this.entityMovingWorld.field_70165_t, this.entityMovingWorld.field_70163_u, this.entityMovingWorld.field_70161_v);
        movingWorldPos = movingWorldPos.func_178786_a((double)this.maxX() / 2.0, (double)this.maxY() / 2.0, (double)this.maxZ() / 2.0);
        Vec3d returnPos = new Vec3d(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        returnPos = returnPos.func_178788_d(movingWorldPos);
        return returnPos;
    }

    public AxisAlignedBB offsetWorldBBToChunkBB(AxisAlignedBB axisAlignedBB) {
        double minX = axisAlignedBB.field_72340_a;
        double minY = axisAlignedBB.field_72338_b;
        double minZ = axisAlignedBB.field_72339_c;
        double maxX = axisAlignedBB.field_72336_d;
        double maxY = axisAlignedBB.field_72337_e;
        double maxZ = axisAlignedBB.field_72334_f;
        Vec3d minVec = new Vec3d(minX, minY, minZ);
        Vec3d maxVec = new Vec3d(maxX, maxY, maxZ);
        minVec = this.getChunkPosForWorldPos(minVec);
        maxVec = this.getChunkPosForWorldPos(maxVec);
        axisAlignedBB = new AxisAlignedBB(minVec.field_72450_a, minVec.field_72448_b, minVec.field_72449_c, maxVec.field_72450_a, maxVec.field_72448_b, maxVec.field_72449_c);
        return axisAlignedBB;
    }

    public BlockPos shiftToStorageMapPos(BlockPos blockPosition) {
        return new BlockPos(blockPosition.func_177958_n() >> 4, blockPosition.func_177956_o() >> 4, blockPosition.func_177952_p() >> 4);
    }

    public BlockPos shiftToInternalStoragePos(BlockPos blockPosition) {
        return new BlockPos(blockPosition.func_177958_n() & 0xF, blockPosition.func_177956_o() & 0xF, blockPosition.func_177952_p() & 0xF);
    }

    public ExtendedBlockStorage getBlockStorage(BlockPos pos) {
        return this.blockStorageMap.get(this.shiftToStorageMapPos(pos));
    }

    public ExtendedBlockStorage getBlockStorageOrCreate(BlockPos blockPos) {
        BlockPos shiftedPos = this.shiftToStorageMapPos(blockPos);
        ExtendedBlockStorage storage = this.blockStorageMap.get(shiftedPos);
        if (storage != null) {
            return storage;
        }
        storage = new ExtendedBlockStorage(shiftedPos.func_177956_o(), false);
        this.blockStorageMap.put(shiftedPos, storage);
        return storage;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public float getCenterX() {
        return (float)(this.minBounds.func_177958_n() + this.maxBounds.func_177958_n()) / 2.0f;
    }

    public float getCenterY() {
        return (float)(this.minBounds.func_177956_o() + this.maxBounds.func_177956_o()) / 2.0f;
    }

    public float getCenterZ() {
        return (float)(this.minBounds.func_177952_p() + this.maxBounds.func_177952_p()) / 2.0f;
    }

    public int minX() {
        return this.minBounds.func_177958_n();
    }

    public int maxX() {
        return this.maxBounds.func_177958_n();
    }

    public int minY() {
        return this.minBounds.func_177956_o();
    }

    public int maxY() {
        return this.maxBounds.func_177956_o();
    }

    public int minZ() {
        return this.minBounds.func_177952_p();
    }

    public int maxZ() {
        return this.maxBounds.func_177952_p();
    }

    public void setCreationSpotBiomeGen(Biome biomeGen) {
        this.creationSpotBiome = biomeGen;
    }

    public boolean addBlockWithState(BlockPos pos, IBlockState state) {
        int minX;
        if (state == null) {
            return false;
        }
        Block block = state.func_177230_c();
        int id = Block.func_149682_b((Block)block);
        int meta = block.func_176201_c(state);
        if (block == null) {
            return false;
        }
        ExtendedBlockStorage storage = this.getBlockStorageOrCreate(pos);
        BlockPos internalStoragePos = this.shiftToInternalStoragePos(pos);
        IBlockState currentState = storage.func_177485_a(internalStoragePos.func_177958_n(), internalStoragePos.func_177956_o(), internalStoragePos.func_177952_p());
        Block currentBlock = currentState.func_177230_c();
        int currentID = Block.func_149682_b((Block)currentBlock);
        int currentMeta = currentBlock.func_176201_c(currentState);
        MovingWorldMod.LOG.debug(String.format("Adding block with state: %s, at position %s in a mobile chunk. \n The block id is: %s, and the metadata is: %s", state, pos, id, meta));
        if (currentID == id && currentMeta == meta) {
            return false;
        }
        storage.func_177484_a(internalStoragePos.func_177958_n(), internalStoragePos.func_177956_o(), internalStoragePos.func_177952_p(), state);
        if (this.boundsInit) {
            minX = Math.min(this.minBounds.func_177958_n(), pos.func_177958_n());
            int minY = Math.min(this.minBounds.func_177956_o(), pos.func_177956_o());
            int minZ = Math.min(this.minBounds.func_177952_p(), pos.func_177952_p());
            int maxX = Math.max(this.maxBounds.func_177958_n(), pos.func_177958_n() + 1);
            int maxY = Math.max(this.maxBounds.func_177956_o(), pos.func_177956_o() + 1);
            int maxZ = Math.max(this.maxBounds.func_177952_p(), pos.func_177952_p() + 1);
            this.minBounds = new BlockPos(minX, minY, minZ);
            this.maxBounds = new BlockPos(maxX, maxY, maxZ);
        } else {
            this.boundsInit = true;
            minX = pos.func_177958_n();
            int minY = pos.func_177956_o();
            int minZ = pos.func_177952_p();
            int maxX = pos.func_177958_n() + 1;
            int maxY = pos.func_177956_o() + 1;
            int maxZ = pos.func_177952_p() + 1;
            this.minBounds = new BlockPos(minX, minY, minZ);
            this.maxBounds = new BlockPos(maxX, maxY, maxZ);
        }
        ++this.blockCount;
        this.setChunkModified();
        if (block.hasTileEntity(state)) {
            TileEntity tileentity = this.func_175625_s(pos);
            if (tileentity == null) {
                this.setTileEntity(pos, tileentity);
            } else {
                tileentity.func_145836_u();
                TILE_BLOCK_TYPE.set(tileentity, block);
                TILE_METADATA.set(tileentity, meta);
            }
        }
        return true;
    }

    public void calculateBounds() {
        for (int i = this.minX(); i < this.maxX(); ++i) {
            for (int j = this.minY(); j < this.maxY(); ++j) {
                for (int k = this.minZ(); k < this.maxZ(); ++k) {
                    BlockPos pos = new BlockPos(i, j, k);
                    this.calculateBlockBounds(pos);
                }
            }
        }
    }

    public AxisAlignedBB calculateBlockBounds(BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        if (state == null || state.func_185904_a().equals(Material.field_151579_a)) {
            return null;
        }
        if (!state.func_177230_c().func_149703_v() || state.func_177230_c().func_149703_v() && state.func_185890_d((IBlockAccess)this.getFakeWorld(), pos) == null) {
            return null;
        }
        AxisAlignedBB axisAlignedBB = this.func_180495_p(pos).func_185890_d((IBlockAccess)this.getFakeWorld(), pos);
        this.chunkBoundingBoxes.put((Object)pos, (Object)axisAlignedBB);
        double maxDX = this.maxX();
        double maxDY = this.maxY();
        double maxDZ = this.maxZ();
        maxDX = maxDX / 2.0 * -1.0;
        maxDY = maxDY / 2.0 * -1.0;
        maxDZ = maxDZ / 2.0 * -1.0;
        axisAlignedBB = axisAlignedBB.func_72317_d(this.entityMovingWorld.field_70165_t + maxDX - 0.5, this.entityMovingWorld.field_70163_u + maxDY, this.entityMovingWorld.field_70161_v + maxDZ - 0.5);
        this.boundingBoxes.put((Object)pos, (Object)axisAlignedBB);
        return axisAlignedBB;
    }

    public List<AxisAlignedBB> getBoxes() {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        boxes.addAll(this.boundingBoxes.values());
        return boxes;
    }

    public List getCollidingBoundingBoxes(boolean chunkPos, AxisAlignedBB startBox, AxisAlignedBB endBox) {
        ArrayList<AxisAlignedBB> axisAlignedBBs = new ArrayList<AxisAlignedBB>();
        AxisAlignedBB boxUnion = startBox.func_111270_a(endBox);
        if (!chunkPos) {
            for (AxisAlignedBB axisAlignedBB : this.boundingBoxes.values()) {
                if (!axisAlignedBB.func_72326_a(boxUnion)) continue;
                axisAlignedBBs.add(axisAlignedBB);
            }
        } else {
            for (AxisAlignedBB axisAlignedBB : this.chunkBoundingBoxes.values()) {
                if (!axisAlignedBB.func_72326_a(boxUnion)) continue;
                axisAlignedBBs.add(axisAlignedBB);
            }
        }
        return axisAlignedBBs;
    }

    public List getCollidingBoundingBoxes(boolean chunkPos, AxisAlignedBB box) {
        ArrayList<AxisAlignedBB> axisAlignedBBs = new ArrayList<AxisAlignedBB>();
        if (!chunkPos) {
            for (AxisAlignedBB axisAlignedBB : this.boundingBoxes.values()) {
                if (!axisAlignedBB.func_72326_a(box)) continue;
                axisAlignedBBs.add(axisAlignedBB);
            }
        } else {
            for (AxisAlignedBB axisAlignedBB : this.chunkBoundingBoxes.values()) {
                if (!axisAlignedBB.func_72326_a(box)) continue;
                axisAlignedBBs.add(axisAlignedBB);
            }
        }
        return axisAlignedBBs;
    }

    public void updateBlockBounds(float rotationYaw) {
        HashBiMap newBoundingBoxes = HashBiMap.create();
        for (AxisAlignedBB bb : this.chunkBoundingBoxes.values()) {
            if (bb == null) continue;
            BlockPos offset = (BlockPos)this.chunkBoundingBoxes.inverse().get((Object)bb);
            float rotationRadians = (float)Math.toRadians(rotationYaw);
            AxisAlignedBB axisAlignedBB = bb;
            BlockPos pos = (BlockPos)this.chunkBoundingBoxes.inverse().get((Object)bb);
            double maxDX = this.maxX();
            double maxDY = this.maxY();
            double maxDZ = this.maxZ();
            maxDX = maxDX / 2.0 * -1.0;
            maxDY = maxDY / 2.0 * -1.0 + 1.0;
            maxDZ = maxDZ / 2.0 * -1.0;
            axisAlignedBB = AABBRotator.rotateAABBAroundY(axisAlignedBB, offset.func_177958_n(), offset.func_177952_p(), rotationRadians);
            Vec3dMod vec3 = new Vec3dMod(maxDX, maxDY, maxDZ).rotateAroundY(rotationRadians);
            axisAlignedBB = axisAlignedBB.func_72317_d(this.entityMovingWorld.field_70165_t + vec3.field_72450_a, this.entityMovingWorld.field_70163_u + vec3.field_72448_b, this.entityMovingWorld.field_70161_v + vec3.field_72449_c);
            newBoundingBoxes.put((Object)pos, (Object)axisAlignedBB);
        }
        this.boundingBoxes = newBoundingBoxes;
    }

    public boolean setBlockState(BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        ExtendedBlockStorage storage = this.getBlockStorage(pos);
        if (storage == null) {
            return this.addBlockWithState(pos, state);
        }
        IBlockState checkState = this.func_180495_p(pos);
        if (checkState.func_177230_c().equals(state.func_177230_c()) && checkState.func_177230_c().func_176201_c(checkState) == state.func_177230_c().func_176201_c(state)) {
            return false;
        }
        BlockPos internalStoragePos = this.shiftToInternalStoragePos(pos);
        if (storage.func_177485_a(internalStoragePos.func_177958_n(), internalStoragePos.func_177956_o(), internalStoragePos.func_177952_p()) == null) {
            ++this.blockCount;
        }
        storage.func_177484_a(internalStoragePos.func_177958_n(), internalStoragePos.func_177956_o(), internalStoragePos.func_177952_p(), state);
        state = storage.func_177485_a(internalStoragePos.func_177958_n(), internalStoragePos.func_177956_o(), internalStoragePos.func_177952_p());
        Block block = state.func_177230_c();
        if (block != null && block.hasTileEntity(state) && (tileentity = this.func_175625_s(pos)) != null) {
            tileentity.func_145836_u();
            TILE_METADATA.set(tileentity, block.func_176201_c(state));
        }
        if (this.boundsInit) {
            int minX = Math.min(this.minBounds.func_177958_n(), pos.func_177958_n());
            int minY = Math.min(this.minBounds.func_177956_o(), pos.func_177956_o());
            int minZ = Math.min(this.minBounds.func_177952_p(), pos.func_177952_p());
            int maxX = Math.max(this.maxBounds.func_177958_n(), pos.func_177958_n() + 1);
            int maxY = Math.max(this.maxBounds.func_177956_o(), pos.func_177956_o() + 1);
            int maxZ = Math.max(this.maxBounds.func_177952_p(), pos.func_177952_p() + 1);
            this.minBounds = new BlockPos(minX, minY, minZ);
            this.maxBounds = new BlockPos(maxX, maxY, maxZ);
        } else {
            this.boundsInit = true;
            int minX = pos.func_177958_n();
            int minY = pos.func_177956_o();
            int minZ = pos.func_177952_p();
            int maxX = pos.func_177958_n() + 1;
            int maxY = pos.func_177956_o() + 1;
            int maxZ = pos.func_177952_p() + 1;
            this.minBounds = new BlockPos(minX, minY, minZ);
            this.maxBounds = new BlockPos(maxX, maxY, maxZ);
        }
        this.setChunkModified();
        return true;
    }

    public boolean setBlockAsFilledAir(BlockPos pos) {
        ExtendedBlockStorage storage = this.getBlockStorage(pos);
        if (storage == null) {
            return true;
        }
        IBlockState state = this.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150350_a && block.func_176201_c(state) == 1) {
            return true;
        }
        if (block == null || state.func_185904_a().equals(Material.field_151579_a)) {
            BlockPos internalStoragePos = this.shiftToInternalStoragePos(pos);
            storage.func_177484_a(internalStoragePos.func_177958_n(), internalStoragePos.func_177956_o(), internalStoragePos.func_177952_p(), Blocks.field_150350_a.func_176223_P());
            return true;
        }
        return false;
    }

    public TileEntity func_175625_s(BlockPos pos) {
        TileEntity tileentity = this.chunkTileEntityMap.get(pos);
        if (tileentity == null) {
            IBlockState blockState = this.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (block == null || !block.hasTileEntity(blockState)) {
                return null;
            }
            tileentity = block.createTileEntity(this.world, blockState);
            this.setTileEntity(pos, tileentity);
            tileentity = this.chunkTileEntityMap.get(pos);
        }
        return tileentity;
    }

    public void setTileEntity(BlockPos pos, TileEntity tileentity) {
        if (tileentity == null) {
            this.removeChunkBlockTileEntity(pos);
            return;
        }
        this.setChunkBlockTileEntity(pos, tileentity);
    }

    private void setChunkBlockTileEntity(BlockPos pos, TileEntity newTile) {
        BlockPos chunkPosition = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        newTile.func_174878_a(pos);
        newTile.func_145834_a((World)this.getFakeWorld());
        IBlockState blockState = this.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block != null && block.hasTileEntity(blockState)) {
            if (this.chunkTileEntityMap.containsKey(chunkPosition)) {
                this.chunkTileEntityMap.get(chunkPosition).func_145843_s();
            }
            TILE_METADATA.set(newTile, block.func_176201_c(blockState));
            this.chunkTileEntityMap.put(chunkPosition, newTile);
            if (newTile instanceof IMovingTile) {
                if (!this.movingWorldTileEntities.contains(newTile)) {
                    this.movingWorldTileEntities.add((IMovingTile)newTile);
                }
                ((IMovingTile)newTile).setParentMovingWorld(this.entityMovingWorld, chunkPosition);
            } else if (newTile instanceof ITickable && MovingWorldMod.INSTANCE.getNetworkConfig().isTileUpdatable(newTile.getClass())) {
                this.updatableTiles.add(newTile);
            }
        }
    }

    public void removeChunkBlockTileEntity(BlockPos pos) {
        TileEntity tileentity;
        BlockPos chunkPosition = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (this.isChunkLoaded && (tileentity = this.chunkTileEntityMap.remove(chunkPosition)) != null) {
            if (tileentity instanceof IMovingTile) {
                if (!this.movingWorldTileEntities.contains(tileentity)) {
                    this.movingWorldTileEntities.add((IMovingTile)tileentity);
                }
                ((IMovingTile)tileentity).setParentMovingWorld(null, pos);
            }
            if (tileentity instanceof ITickable && MovingWorldMod.INSTANCE.getNetworkConfig().isTileUpdatable(tileentity.getClass())) {
                this.updatableTiles.remove(tileentity);
            }
            tileentity.func_145843_s();
        }
    }

    public void onChunkLoad() {
        this.isChunkLoaded = true;
        this.world.func_147448_a(this.chunkTileEntityMap.values());
    }

    public void onChunkUnload() {
        this.isChunkLoaded = false;
    }

    public void setChunkModified() {
        this.isModified = true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_175626_b(BlockPos pos, int l) {
        int lv = EnumSkyBlock.SKY.field_77198_c;
        return lv << 20 | l << 4;
    }

    public boolean func_175623_d(BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        return state == null || state.func_185904_a().equals(Material.field_151579_a);
    }

    public boolean isBlockTakingWaterVolume(BlockPos pos) {
        IBlockState blockState = this.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        return block != null && !blockState.func_185904_a().equals(Material.field_151579_a) || block.func_176201_c(blockState) != 1;
    }

    public int getHeight() {
        return 16;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        IBlockState state;
        BlockPos internalStoragePos = this.shiftToInternalStoragePos(pos);
        ExtendedBlockStorage storage = this.getBlockStorage(pos);
        IBlockState iBlockState = state = storage != null ? storage.func_177485_a(internalStoragePos.func_177958_n(), internalStoragePos.func_177956_o(), internalStoragePos.func_177952_p()) : null;
        if (state == null || storage == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    public Biome func_180494_b(BlockPos pos) {
        return this.creationSpotBiome;
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return 0;
    }

    public WorldType func_175624_G() {
        return this.world.func_175624_G();
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (x < -30000000 || z < -30000000 || x >= 30000000 || z >= 30000000) {
            return _default;
        }
        IBlockState state = this.func_180495_p(pos);
        return state.isSideSolid((IBlockAccess)this, new BlockPos(x, y, z), side);
    }

    public final int getMemoryUsage() {
        return 2 + this.blockCount * 9;
    }

    public boolean needsCustomCollision(AxisAlignedBB axisAlignedBB) {
        boolean retVal = false;
        for (AxisAlignedBB bb : this.boundingBoxes.values()) {
            if (!this.bbContainsBB(axisAlignedBB, bb)) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    private boolean bbContainsBB(AxisAlignedBB container, AxisAlignedBB axisAlignedBB) {
        Vec3dMod minVec = new Vec3dMod(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c);
        Vec3d maxVec = new Vec3d(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f);
        if (container.field_72340_a < minVec.field_72450_a || container.field_72338_b < minVec.field_72448_b || container.field_72339_c < minVec.field_72449_c) {
            return true;
        }
        return container.field_72336_d > maxVec.field_72450_a || container.field_72337_e > maxVec.field_72448_b || container.field_72334_f > maxVec.field_72449_c;
    }

    public abstract Side side();

    public void markTileDirty(BlockPos pos) {
        this.setChunkModified();
    }
}

