/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.davincisvessels.client;

import com.elytradev.davincisvessels.DavincisVesselsMod;
import com.elytradev.davincisvessels.client.control.ShipKeyHandler;
import com.elytradev.davincisvessels.client.handler.ClientHookContainer;
import com.elytradev.davincisvessels.client.render.RenderParachute;
import com.elytradev.davincisvessels.client.render.RenderSeat;
import com.elytradev.davincisvessels.client.render.TileEntityGaugeRenderer;
import com.elytradev.davincisvessels.client.render.TileEntityHelmRenderer;
import com.elytradev.davincisvessels.common.CommonProxy;
import com.elytradev.davincisvessels.common.DavincisVesselsConfig;
import com.elytradev.davincisvessels.common.entity.EntityParachute;
import com.elytradev.davincisvessels.common.entity.EntitySeat;
import com.elytradev.davincisvessels.common.entity.EntityShip;
import com.elytradev.davincisvessels.common.object.DavincisVesselsObjects;
import com.elytradev.davincisvessels.common.tileentity.TileGauge;
import com.elytradev.davincisvessels.common.tileentity.TileHelm;
import com.elytradev.movingworld.client.render.RenderMovingWorld;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    public ShipKeyHandler shipKeyHandler;
    public DavincisVesselsConfig syncedConfig;

    @Override
    public ClientHookContainer getHookContainer() {
        return new ClientHookContainer();
    }

    @Override
    public void registerKeyHandlers(DavincisVesselsConfig cfg) {
        this.shipKeyHandler = new ShipKeyHandler(cfg);
        MinecraftForge.EVENT_BUS.register((Object)this.shipKeyHandler);
    }

    @Override
    public void registerRenderers(LoaderState.ModState state) {
        if (state == LoaderState.ModState.PREINITIALIZED) {
            this.registerEntityRenderers();
        }
        if (state == LoaderState.ModState.INITIALIZED) {
            this.registerTileRenderers();
            this.registerStandardItemRenders();
        }
    }

    public void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityShip.class, RenderMovingWorld::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityParachute.class, RenderParachute::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySeat.class, RenderSeat::new);
    }

    public void registerTileRenderers() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileGauge.class, (TileEntitySpecialRenderer)new TileEntityGaugeRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileHelm.class, (TileEntitySpecialRenderer)new TileEntityHelmRenderer());
    }

    public void registerVariantItemRenders() {
        Item itemToRegister = Item.func_150898_a((Block)DavincisVesselsObjects.blockGauge);
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation("davincisvessels:gauge", "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)itemToRegister, (int)0, (ModelResourceLocation)modelResourceLocation);
        modelResourceLocation = new ModelResourceLocation("davincisvessels:gauge_ext", "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)itemToRegister, (int)1, (ModelResourceLocation)modelResourceLocation);
        itemToRegister = Item.func_150898_a((Block)DavincisVesselsObjects.blockBalloon);
        for (EnumDyeColor color : EnumDyeColor.values()) {
            int i = color.func_176765_a();
            modelResourceLocation = new ModelResourceLocation("davincisvessels:balloon_" + color.func_176610_l(), "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)itemToRegister, (int)i, (ModelResourceLocation)modelResourceLocation);
            DavincisVesselsMod.LOG.info("Registering balloon model variant: " + i + " " + modelResourceLocation);
        }
    }

    public void registerStandardItemRenders() {
        Item itemToRegister = null;
        ModelResourceLocation modelResourceLocation = null;
        ItemModelMesher modelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        for (Map.Entry<String, Block> entry : DavincisVesselsObjects.registeredBlocks.entrySet()) {
            if (DavincisVesselsObjects.skipMesh.contains(entry.getKey())) continue;
            modelResourceLocation = new ModelResourceLocation("davincisvessels:" + entry.getKey(), "inventory");
            itemToRegister = Item.func_150898_a((Block)entry.getValue());
            modelMesher.func_178086_a(itemToRegister, 0, modelResourceLocation);
        }
        for (Map.Entry<String, Block> entry : DavincisVesselsObjects.registeredItems.entrySet()) {
            if (DavincisVesselsObjects.skipMesh.contains(entry.getKey())) continue;
            modelResourceLocation = new ModelResourceLocation("davincisvessels:" + entry.getKey(), "inventory");
            itemToRegister = (Item)entry.getValue();
            modelMesher.func_178086_a(itemToRegister, 0, modelResourceLocation);
        }
    }

    @SubscribeEvent
    public void onModelRegistryEvent(ModelRegistryEvent e) {
        this.registerVariantItemRenders();
    }
}

