/*
 * Decompiled with CFR 0.152.
 */
package QuantumStorage.handler;

import QuantumStorage.api.IQuantumBagProvider;
import QuantumStorage.api.QuantumStorageAPI;
import QuantumStorage.network.PacketHandler;
import QuantumStorage.network.SyncBagData;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public final class QunatumBagImpl {
    public static void init() {
        CapabilityManager.INSTANCE.register(IQuantumBagProvider.class, (Capability.IStorage)new Capability.IStorage<IQuantumBagProvider>(){

            public NBTTagCompound writeNBT(Capability<IQuantumBagProvider> capability, IQuantumBagProvider instance, EnumFacing side) {
                return (NBTTagCompound)instance.serializeNBT();
            }

            public void readNBT(Capability<IQuantumBagProvider> capability, IQuantumBagProvider instance, EnumFacing side, NBTBase nbt) {
                if (nbt instanceof NBTTagCompound) {
                    instance.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
                }
            }
        }, DefaultImpl.class);
    }

    private QunatumBagImpl() {
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        public static final ResourceLocation NAME = new ResourceLocation("QuantumStorage", "quantum_bags");
        private final IQuantumBagProvider cap = new DefaultImpl();

        public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
            return capability == QuantumStorageAPI.QUANTUM_BAG_PROVIDER_CAPABILITY;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
            if (capability == QuantumStorageAPI.QUANTUM_BAG_PROVIDER_CAPABILITY) {
                return (T)QuantumStorageAPI.QUANTUM_BAG_PROVIDER_CAPABILITY.cast((Object)this.cap);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)this.cap.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.cap.deserializeNBT((NBTBase)nbt);
        }
    }

    private static class DefaultImpl
    implements IQuantumBagProvider {
        private final Map<EnumDyeColor, IItemHandler> inventories = new EnumMap<EnumDyeColor, IItemHandler>(EnumDyeColor.class);

        private DefaultImpl() {
        }

        @Override
        @Nonnull
        public IItemHandler getBag(@Nonnull EnumDyeColor color) {
            if (!this.inventories.containsKey(color)) {
                this.inventories.put(color, (IItemHandler)new ItemStackHandler(104));
            }
            return this.inventories.get(color);
        }

        @Override
        public void sync(@Nullable EnumDyeColor color, @Nonnull EntityPlayerMP player) {
            PacketHandler.sendTo(new SyncBagData(this.writeNBT(color)), player);
        }

        private NBTTagCompound writeNBT(EnumDyeColor color) {
            EnumDyeColor[] colors;
            EnumDyeColor[] enumDyeColorArray;
            NBTTagCompound ret = new NBTTagCompound();
            if (color == null) {
                enumDyeColorArray = EnumDyeColor.values();
            } else {
                EnumDyeColor[] enumDyeColorArray2 = new EnumDyeColor[1];
                enumDyeColorArray = enumDyeColorArray2;
                enumDyeColorArray2[0] = color;
            }
            for (EnumDyeColor c : colors = enumDyeColorArray) {
                if (!this.inventories.containsKey(c)) continue;
                NBTBase inv = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.getStorage().writeNBT(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)this.inventories.get(c), null);
                ret.func_74782_a(c.func_176610_l(), inv);
            }
            return ret;
        }

        public NBTTagCompound serializeNBT() {
            return this.writeNBT(null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            for (EnumDyeColor e : EnumDyeColor.values()) {
                if (!nbt.func_74764_b(e.func_176610_l())) continue;
                ItemStackHandler inv = new ItemStackHandler(104);
                CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.getStorage().readNBT(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)inv, null, nbt.func_74781_a(e.func_176610_l()));
                this.inventories.put(e, (IItemHandler)inv);
            }
        }
    }
}

