/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.thirteen.Context;
import mcjty.meecreeps.actions.ActionOptions;
import mcjty.meecreeps.actions.ClientActionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketActionOptionToClient
implements IMessage {
    private ActionOptions options;
    private int guiid;

    public void fromBytes(ByteBuf buf) {
        this.options = new ActionOptions(buf);
        this.guiid = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        this.options.writeToBuf(buf);
        buf.writeInt(this.guiid);
    }

    public PacketActionOptionToClient() {
    }

    public PacketActionOptionToClient(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketActionOptionToClient(ActionOptions options, int guiid) {
        this.options = options;
        this.guiid = guiid;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> ClientActionManager.showActionOptions(this.options, this.guiid));
        ctx.setPacketHandled(true);
    }
}

