/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.meecreeps.actions.ActionOptions;
import mcjty.meecreeps.actions.MeeCreepActionType;
import mcjty.meecreeps.actions.ServerActionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketPerformAction
implements IMessage {
    private int id;
    private MeeCreepActionType type;
    private String furtherQuestionId;

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.type = new MeeCreepActionType(NetworkTools.readStringUTF8((ByteBuf)buf));
        this.furtherQuestionId = NetworkTools.readStringUTF8((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        NetworkTools.writeStringUTF8((ByteBuf)buf, (String)this.type.getId());
        NetworkTools.writeStringUTF8((ByteBuf)buf, (String)this.furtherQuestionId);
    }

    public PacketPerformAction() {
    }

    public PacketPerformAction(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketPerformAction(ActionOptions options, MeeCreepActionType type, String furtherQuestionId) {
        this.id = options.getActionId();
        this.type = type;
        this.furtherQuestionId = furtherQuestionId;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> ServerActionManager.getManager().performAction(ctx.getSender(), this.id, this.type, this.furtherQuestionId));
        ctx.setPacketHandled(true);
    }
}

