/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions.workers;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import mcjty.meecreeps.actions.workers.AbstractActionWorker;
import mcjty.meecreeps.api.BuildProgress;
import mcjty.meecreeps.api.IBuildSchematic;
import mcjty.meecreeps.api.IMeeCreep;
import mcjty.meecreeps.api.IWorkerHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public abstract class AbstractBuildActionWorker
extends AbstractActionWorker {
    private AxisAlignedBB actionBox = null;
    private BuildProgress progress = new BuildProgress(2, 0);
    private Set<BlockPos> toSkip = new HashSet<BlockPos>();
    protected IBuildSchematic schematic = null;

    public AbstractBuildActionWorker(IWorkerHelper helper) {
        super(helper);
    }

    @Override
    public boolean onlyStopWhenDone() {
        return true;
    }

    @Override
    public void init(IMeeCreep meeCreep) {
        this.helper.setSpeed(3);
    }

    @Override
    @Nullable
    public AxisAlignedBB getActionBox() {
        if (this.actionBox == null) {
            this.actionBox = new AxisAlignedBB(this.options.getTargetPos().func_177982_a(-12, -5, -12), this.options.getTargetPos().func_177982_a(12, 5, 12));
        }
        return this.actionBox;
    }

    protected abstract IBuildSchematic getSchematic();

    @Override
    public void tick(boolean timeToWrapUp) {
        if (timeToWrapUp) {
            this.helper.done();
            return;
        }
        if (this.progress.getHeight() == 0) {
            if (!this.helper.handleFlatten(this.getSchematic())) {
                this.progress.setHeight(1);
                this.progress.setPass(0);
                this.helper.setSpeed(5);
            }
        } else if (!this.helper.handleBuilding(this.getSchematic(), this.progress, this.toSkip)) {
            this.helper.taskIsDone();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.progress.setHeight(tag.func_74762_e("stage"));
        this.progress.setPass(tag.func_74762_e("pass"));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("stage", this.progress.getHeight());
        tag.func_74768_a("pass", this.progress.getPass());
    }
}

