/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions.workers;

import java.util.HashSet;
import java.util.Set;
import mcjty.lib.varia.SoundTools;
import mcjty.meecreeps.actions.workers.AbstractActionWorker;
import mcjty.meecreeps.actions.workers.DigTunnelActionWorker;
import mcjty.meecreeps.api.IMeeCreep;
import mcjty.meecreeps.api.IWorkerHelper;
import mcjty.meecreeps.varia.GeneralTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DigdownStairsActionWorker
extends AbstractActionWorker {
    private AxisAlignedBB actionBox = null;
    private int offset = 0;
    private int blockidx = 0;
    private int numStairs = 0;
    private int numCobble = 0;
    private EnumFacing direction = null;
    private Set<BlockPos> positionsToSkip = new HashSet<BlockPos>();

    public DigdownStairsActionWorker(IWorkerHelper helper) {
        super(helper);
    }

    @Override
    public void init(IMeeCreep meeCreep) {
        this.helper.setSpeed(5);
    }

    @Override
    public boolean onlyStopWhenDone() {
        return true;
    }

    private EnumFacing getDirection() {
        if (this.direction == null) {
            String id = this.options.getFurtherQuestionId();
            this.direction = EnumFacing.func_176739_a((String)id);
        }
        return this.direction;
    }

    @Override
    public AxisAlignedBB getActionBox() {
        if (this.actionBox == null) {
            this.actionBox = new AxisAlignedBB(this.options.getTargetPos().func_177982_a(-20, -5, -20), this.options.getTargetPos().func_177982_a(20, 5, 20));
        }
        return this.actionBox;
    }

    private boolean isSupportBlock(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBlock ? DigTunnelActionWorker.isNotInterestedIn(((ItemBlock)stack.func_77973_b()).func_179223_d()) : false;
    }

    private void dig(BlockPos p) {
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        IBlockState state = world.func_180495_p(p);
        boolean result = DigTunnelActionWorker.isNotInterestedIn(state.func_177230_c()) ? this.helper.harvestAndDrop(p) : this.helper.harvestAndPickup(p);
        if (!result) {
            this.positionsToSkip.add(p);
        }
    }

    private BlockPos getBlockToDig(BlockPos p, EnumFacing facing, int blockidx) {
        switch (blockidx) {
            case 0: {
                return p.func_177981_b(1).func_177972_a(facing.func_176746_e());
            }
            case 1: {
                return p.func_177981_b(1);
            }
            case 2: {
                return p.func_177981_b(1).func_177972_a(facing.func_176735_f());
            }
            case 3: {
                return p.func_177972_a(facing.func_176746_e());
            }
            case 4: {
                return p;
            }
            case 5: {
                return p.func_177972_a(facing.func_176735_f());
            }
            case 6: {
                return p.func_177979_c(1).func_177972_a(facing.func_176735_f());
            }
            case 7: {
                return p.func_177979_c(1);
            }
            case 8: {
                return p.func_177979_c(1).func_177972_a(facing.func_176746_e());
            }
            case 9: {
                return p.func_177981_b(2).func_177972_a(facing.func_176746_e());
            }
            case 10: {
                return p.func_177981_b(2);
            }
            case 11: {
                return p.func_177981_b(2).func_177972_a(facing.func_176735_f());
            }
            case 12: {
                return p.func_177981_b(3).func_177972_a(facing.func_176746_e());
            }
            case 13: {
                return p.func_177981_b(3);
            }
            case 14: {
                return p.func_177981_b(3).func_177972_a(facing.func_176735_f());
            }
        }
        return p;
    }

    private void buildSupport(BlockPos pos, EntityItem entityItem) {
        IMeeCreep entity = this.helper.getMeeCreep();
        ItemStack blockStack = entityItem.func_92059_d();
        ItemStack actual = blockStack.func_77979_a(1);
        if (blockStack.func_190926_b()) {
            entityItem.func_70106_y();
        }
        if (actual.func_190926_b()) {
            return;
        }
        Item item = actual.func_77973_b();
        if (!(item instanceof ItemBlock)) {
            return;
        }
        World world = entity.getWorld();
        Block block = ((ItemBlock)item).func_179223_d();
        IBlockState stateForPlacement = block.getStateForPlacement(world, pos, EnumFacing.UP, 0.0f, 0.0f, 0.0f, item.getMetadata(actual), (EntityLivingBase)GeneralTools.getHarvester(world), EnumHand.MAIN_HAND);
        world.func_180501_a(pos, stateForPlacement, 3);
        SoundTools.playSound((World)world, (SoundEvent)block.func_185467_w().func_185841_e(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)1.0, (double)1.0);
    }

    private void buildStairs(BlockPos pos) {
        IMeeCreep entity = this.helper.getMeeCreep();
        --this.numStairs;
        World world = entity.getWorld();
        Block block = Blocks.field_150446_ar;
        IBlockState stateForPlacement = block.getStateForPlacement(world, pos, EnumFacing.UP, 0.0f, 0.0f, 0.0f, this.getDirection().func_176734_d().ordinal() - 2, (EntityLivingBase)GeneralTools.getHarvester(world), EnumHand.MAIN_HAND);
        stateForPlacement = stateForPlacement.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)this.getDirection().func_176734_d());
        world.func_180501_a(pos, stateForPlacement, 3);
        SoundTools.playSound((World)world, (SoundEvent)block.func_185467_w().func_185841_e(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)1.0, (double)1.0);
    }

    private void collectCobble(EntityItem entityItem) {
        ItemStack blockStack = entityItem.func_92059_d();
        ItemStack actual = blockStack.func_77979_a(6);
        if (blockStack.func_190926_b()) {
            entityItem.func_70106_y();
        }
        if (actual.func_190926_b()) {
            return;
        }
        Item item = actual.func_77973_b();
        if (!(item instanceof ItemBlock)) {
            return;
        }
        this.numCobble += actual.func_190916_E();
    }

    private boolean isStair(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof BlockStairs;
    }

    private boolean isCobble(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d() == Blocks.field_150347_e;
    }

    @Override
    public void tick(boolean timeToWrapUp) {
        IMeeCreep entity = this.helper.getMeeCreep();
        if (timeToWrapUp) {
            if (this.numStairs > 0) {
                entity.getEntity().func_70099_a(new ItemStack(Blocks.field_150446_ar, this.numStairs), 0.0f);
                this.numStairs = 0;
            }
            if (this.numCobble > 0) {
                entity.getEntity().func_70099_a(new ItemStack(Blocks.field_150347_e, this.numCobble), 0.0f);
                this.numCobble = 0;
            }
            this.helper.done();
            return;
        }
        EnumFacing facing = this.getDirection();
        BlockPos p = this.helper.getContext().getTargetPos().func_177984_a().func_177967_a(facing, this.offset).func_177979_c(this.offset + 1);
        if (p.func_177956_o() < 6) {
            this.helper.taskIsDone();
            return;
        }
        if (this.checkSupports(facing, p)) {
            return;
        }
        BlockPos digpos = this.getBlockToDig(p, facing, this.blockidx);
        this.helper.navigateTo(p.func_177972_a(facing.func_176734_d()), blockPos -> this.helper.delayForHardBlocks(digpos, pp -> this.dig(digpos)));
        this.handleNextPosition(facing, p);
    }

    private void handleNextPosition(EnumFacing facing, BlockPos p) {
        IMeeCreep entity = this.helper.getMeeCreep();
        ++this.blockidx;
        if (this.blockidx >= 15) {
            this.blockidx = 14;
            if (this.checkClear(p, facing)) {
                if (this.checkForStairs(p, facing)) {
                    ++this.offset;
                    this.blockidx = 0;
                } else {
                    if (entity.hasItem(this::isStair)) {
                        ++this.numStairs;
                        entity.consumeItem(this::isStair, 1);
                    }
                    if (this.numCobble >= 6) {
                        this.numStairs += 4;
                        this.numCobble -= 6;
                    }
                    if (this.numStairs > 0) {
                        this.helper.navigateTo(p, blockPos -> this.placeStair(facing, p));
                    } else {
                        BlockPos position = entity.getEntity().func_180425_c();
                        AxisAlignedBB box = new AxisAlignedBB(position.func_177982_a(-15, -8, -15), position.func_177982_a(15, 8, 15));
                        if (!this.helper.findItemOnGround(box, this::isStair, entityItem -> this.placeStair(facing, p, (EntityItem)entityItem)) && !this.helper.findItemOnGround(box, this::isCobble, this::collectCobble)) {
                            this.helper.showMessage("message.meecreeps.cant_find_stairs_or_cobble", new String[0]);
                        }
                    }
                }
            } else {
                this.blockidx = 0;
            }
        }
    }

    private void placeStair(EnumFacing facing, BlockPos pos, EntityItem entityItem) {
        ItemStack blockStack = entityItem.func_92059_d();
        ItemStack actual = blockStack.func_77979_a(32);
        this.numStairs += 32;
        if (blockStack.func_190926_b()) {
            entityItem.func_70106_y();
        }
        if (actual.func_190926_b()) {
            return;
        }
        Item item = actual.func_77973_b();
        if (!(item instanceof ItemBlock)) {
            return;
        }
        this.placeStair(facing, pos);
    }

    private void placeStair(EnumFacing facing, BlockPos p) {
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        if (!this.isStair(p.func_177977_b(), world)) {
            this.buildStairs(p.func_177977_b());
        } else if (!this.isStair(p.func_177977_b().func_177972_a(facing.func_176746_e()), world)) {
            this.buildStairs(p.func_177977_b().func_177972_a(facing.func_176746_e()));
        } else if (!this.isStair(p.func_177977_b().func_177972_a(facing.func_176735_f()), world)) {
            this.buildStairs(p.func_177977_b().func_177972_a(facing.func_176735_f()));
        }
    }

    private boolean needsStair() {
        return this.blockidx >= 6 && this.blockidx <= 8;
    }

    private boolean checkClear(BlockPos p, EnumFacing facing) {
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        if (this.canDig(p, world)) {
            return false;
        }
        if (this.canDig(p.func_177972_a(facing.func_176746_e()), world)) {
            return false;
        }
        if (this.canDig(p.func_177972_a(facing.func_176735_f()), world)) {
            return false;
        }
        if (this.canDig(p.func_177984_a(), world)) {
            return false;
        }
        if (this.canDig(p.func_177984_a().func_177972_a(facing.func_176746_e()), world)) {
            return false;
        }
        if (this.canDig(p.func_177984_a().func_177972_a(facing.func_176735_f()), world)) {
            return false;
        }
        if (this.canDig(p.func_177981_b(2), world)) {
            return false;
        }
        if (this.canDig(p.func_177981_b(2).func_177972_a(facing.func_176746_e()), world)) {
            return false;
        }
        if (this.canDig(p.func_177981_b(2).func_177972_a(facing.func_176735_f()), world)) {
            return false;
        }
        if (this.canDigOrStair(p.func_177977_b(), world)) {
            return false;
        }
        if (this.canDigOrStair(p.func_177977_b().func_177972_a(facing.func_176746_e()), world)) {
            return false;
        }
        return !this.canDigOrStair(p.func_177977_b().func_177972_a(facing.func_176735_f()), world);
    }

    private boolean checkForStairs(BlockPos p, EnumFacing facing) {
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        if (!this.isStair(p.func_177977_b(), world)) {
            return false;
        }
        if (!this.isStair(p.func_177977_b().func_177972_a(facing.func_176746_e()), world)) {
            return false;
        }
        return this.isStair(p.func_177977_b().func_177972_a(facing.func_176735_f()), world);
    }

    private boolean canDig(BlockPos p, World world) {
        return !world.func_175623_d(p) && !this.positionsToSkip.contains(p);
    }

    private boolean canDigOrStair(BlockPos p, World world) {
        return !world.func_175623_d(p) && !this.positionsToSkip.contains(p) && !(world.func_180495_p(p).func_177230_c() instanceof BlockStairs);
    }

    private boolean isStair(BlockPos p, World world) {
        return this.positionsToSkip.contains(p) || world.func_180495_p(p).func_177230_c() instanceof BlockStairs;
    }

    private boolean checkSupports(EnumFacing facing, BlockPos p) {
        if (this.checkForLiquid(p.func_177979_c(1).func_177967_a(facing.func_176746_e(), 2))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177967_a(facing.func_176746_e(), 2))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177981_b(1).func_177967_a(facing.func_176746_e(), 2))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177981_b(2).func_177967_a(facing.func_176746_e(), 2))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177981_b(3).func_177967_a(facing.func_176746_e(), 2))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177979_c(1).func_177967_a(facing.func_176735_f(), 2))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177967_a(facing.func_176735_f(), 2))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177981_b(1).func_177967_a(facing.func_176735_f(), 2))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177981_b(2).func_177967_a(facing.func_176735_f(), 2))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177981_b(3).func_177967_a(facing.func_176735_f(), 2))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177981_b(4))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177981_b(4).func_177972_a(facing.func_176746_e()))) {
            return true;
        }
        return this.checkForLiquid(p.func_177981_b(4).func_177972_a(facing.func_176735_f()));
    }

    private boolean checkForSupport(BlockPos p) {
        IMeeCreep entity = this.helper.getMeeCreep();
        if (entity.getWorld().func_175623_d(p) || this.isLiquid(p)) {
            if (!this.helper.findItemOnGround(this.getSearchBox(), this::isSupportBlock, entityItem -> this.buildSupport(p, (EntityItem)entityItem))) {
                this.helper.showMessage("message.meecreeps.cant_continue", new String[0]);
                this.helper.taskIsDone();
            }
            return true;
        }
        return false;
    }

    private boolean checkForLiquid(BlockPos p) {
        if (this.isLiquid(p)) {
            if (!this.helper.findItemOnGround(this.getSearchBox(), this::isSupportBlock, entityItem -> this.buildSupport(p, (EntityItem)entityItem))) {
                this.helper.showMessage("message.meecreeps.cant_continue", new String[0]);
                this.helper.taskIsDone();
            }
            return true;
        }
        return false;
    }

    private boolean isLiquid(BlockPos p) {
        IMeeCreep entity = this.helper.getMeeCreep();
        Block block = entity.getWorld().func_180495_p(p).func_177230_c();
        return block instanceof BlockLiquid || block instanceof BlockDynamicLiquid || block instanceof BlockStaticLiquid;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.offset = tag.func_74762_e("offset");
        this.blockidx = tag.func_74762_e("blockidx");
        this.numStairs = tag.func_74762_e("stairs");
        this.numCobble = tag.func_74762_e("cobble");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("offset", this.offset);
        tag.func_74768_a("blockidx", this.blockidx);
        tag.func_74768_a("stairs", this.numStairs);
        tag.func_74768_a("cobble", this.numCobble);
    }
}

