/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions.workers;

import mcjty.meecreeps.actions.workers.AbstractActionWorker;
import mcjty.meecreeps.actions.workers.WorkerHelper;
import mcjty.meecreeps.api.IMeeCreep;
import mcjty.meecreeps.api.IWorkerHelper;
import mcjty.meecreeps.entities.EntityMeeCreeps;
import mcjty.meecreeps.varia.GeneralTools;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;

public class FollowAndLightupActionWorker
extends AbstractActionWorker {
    public FollowAndLightupActionWorker(IWorkerHelper helper) {
        super(helper);
    }

    @Override
    public AxisAlignedBB getActionBox() {
        return null;
    }

    @Override
    public boolean onlyStopWhenDone() {
        return true;
    }

    @Override
    public boolean needsToFollowPlayer() {
        return true;
    }

    private BlockPos findDarkSpot() {
        World world = this.helper.getMeeCreep().getWorld();
        BlockPos position = this.options.getPlayer().func_180425_c();
        AxisAlignedBB box = new AxisAlignedBB(position.func_177982_a(-6, -4, -6), position.func_177982_a(6, 4, 6));
        return GeneralTools.traverseBoxFirst(box, p -> {
            int light;
            if (world.func_175623_d(p) && WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND, (World)world, (BlockPos)p) && (light = world.func_175671_l(p)) < 7) {
                return p;
            }
            return null;
        });
    }

    private void placeTorch(BlockPos pos) {
        ItemStack torch;
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        int light = world.func_175671_l(pos);
        if (light < 7 && !(torch = entity.consumeItem(WorkerHelper::isTorch, 1)).func_190926_b()) {
            this.helper.placeStackAt(torch, world, pos);
        }
    }

    @Override
    public void tick(boolean timeToWrapUp) {
        IMeeCreep entity = this.helper.getMeeCreep();
        EntityMeeCreeps meeCreep = (EntityMeeCreeps)entity;
        EntityPlayer player = this.options.getPlayer();
        if (timeToWrapUp) {
            this.helper.done();
        } else if (player == null) {
            this.helper.taskIsDone();
        } else if (!entity.hasItem(WorkerHelper::isTorch)) {
            if (!this.helper.findItemOnGroundOrInChest(WorkerHelper::isTorch, Integer.MAX_VALUE, "message.meecreeps.cant_find_torches", new String[0])) {
                this.helper.taskIsDone();
            }
        } else {
            BlockPos darkSpot = this.findDarkSpot();
            if (darkSpot != null) {
                this.helper.navigateTo(darkSpot, this::placeTorch);
            } else if (player.func_130014_f_().field_73011_w.getDimension() == meeCreep.func_130014_f_().field_73011_w.getDimension()) {
                BlockPos p = this.helper.findSuitablePositionNearPlayer(4.0);
                this.helper.navigateTo(p, blockPos -> {});
            }
        }
    }
}

