/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions.workers;

import java.util.List;
import mcjty.meecreeps.actions.workers.AbstractActionWorker;
import mcjty.meecreeps.api.IMeeCreep;
import mcjty.meecreeps.api.IWorkerHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class PickupActionWorker
extends AbstractActionWorker {
    private AxisAlignedBB actionBox = null;

    public PickupActionWorker(IWorkerHelper helper) {
        super(helper);
    }

    @Override
    public AxisAlignedBB getActionBox() {
        if (this.actionBox == null) {
            this.actionBox = new AxisAlignedBB(this.options.getTargetPos().func_177982_a(-10, -10, -10), this.options.getTargetPos().func_177982_a(10, 10, 10));
        }
        return this.actionBox;
    }

    @Override
    public void tick(boolean timeToWrapUp) {
        if (timeToWrapUp) {
            this.helper.done();
        } else {
            this.tryFindingItemsToPickup();
        }
    }

    private void tryFindingItemsToPickup() {
        IMeeCreep entity = this.helper.getMeeCreep();
        BlockPos position = entity.getEntity().func_180425_c();
        List items = entity.getWorld().func_72872_a(EntityItem.class, this.getActionBox());
        if (!items.isEmpty()) {
            items.sort((o1, o2) -> {
                double d1 = position.func_177954_c(o1.field_70165_t, o1.field_70163_u, o1.field_70161_v);
                double d2 = position.func_177954_c(o2.field_70165_t, o2.field_70163_u, o2.field_70161_v);
                return Double.compare(d1, d2);
            });
            EntityItem entityItem = (EntityItem)items.get(0);
            this.helper.navigateTo((Entity)entityItem, pos -> this.helper.pickup(entityItem));
        } else if (entity.hasStuffInInventory()) {
            this.helper.putStuffAway();
        }
    }
}

