/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.blocks;

import mcjty.meecreeps.blocks.PortalTileEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class PortalTESR
extends TileEntitySpecialRenderer<PortalTileEntity> {
    private static final ResourceLocation portal = new ResourceLocation("meecreeps", "textures/effects/portal.png");
    private static double angle = 0.0;
    private static Face[] faces = new Face[6];
    private static Face[] revertedfaces = new Face[6];

    public void render(PortalTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        super.func_192841_a((TileEntity)te, x, y, z, partialTicks, destroyStage, alpha);
        if (te.getPortalSide() == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179112_b((int)770, (int)771);
        this.func_147499_a(portal);
        long time = System.currentTimeMillis();
        angle = (double)time / 400.0 % 360.0;
        float scale = 1.0f;
        int start = te.getStart();
        if (start < 10) {
            scale = (float)start / 10.0f;
        } else {
            int timeout = te.getTimeout();
            if (timeout < 10) {
                scale = (float)timeout / 10.0f;
            }
        }
        Face face = faces[te.getPortalSide().ordinal()];
        Face rface = revertedfaces[te.getPortalSide().ordinal()];
        GlStateManager.func_179137_b((double)((double)((float)x) + face.ox), (double)((double)((float)y) + face.oy), (double)((double)((float)z) + face.oz));
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        PortalTESR.renderQuadBright(angle, face, rface);
        GlStateManager.func_179121_F();
    }

    public static void renderQuadBright(double angle, Face face, Face rface) {
        int brightness = 240;
        int b1 = brightness >> 16 & 0xFFFF;
        int b2 = brightness & 0xFFFF;
        GlStateManager.func_179094_E();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
        double f = 1.75;
        PortalTESR.renderFace(face, angle, b1, b2, buffer, f, 200);
        PortalTESR.renderFace(face, -angle, b1, b2, buffer, f, 60);
        PortalTESR.renderFace(rface, angle, b1, b2, buffer, f, 200);
        PortalTESR.renderFace(rface, -angle, b1, b2, buffer, f, 60);
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private static void renderFace(Face face, double angle, int b1, int b2, BufferBuilder buffer, double f, int alpha) {
        double u = Math.cos(angle) / f;
        double v = Math.sin(angle) / f;
        buffer.func_181662_b(face.x0, face.y0, face.z0).func_187315_a(u + 0.5, v + 0.5).func_187314_a(b1, b2).func_181669_b(255, 255, 255, alpha).func_181675_d();
        double swap = u;
        u = -v;
        v = swap;
        buffer.func_181662_b(face.x1, face.y1, face.z1).func_187315_a(u + 0.5, v + 0.5).func_187314_a(b1, b2).func_181669_b(255, 255, 255, alpha).func_181675_d();
        swap = u;
        u = -v;
        v = swap;
        buffer.func_181662_b(face.x2, face.y2, face.z2).func_187315_a(u + 0.5, v + 0.5).func_187314_a(b1, b2).func_181669_b(255, 255, 255, alpha).func_181675_d();
        swap = u;
        u = -v;
        v = swap;
        buffer.func_181662_b(face.x3, face.y3, face.z3).func_187315_a(u + 0.5, v + 0.5).func_187314_a(b1, b2).func_181669_b(255, 255, 255, alpha).func_181675_d();
    }

    public static void register() {
        ClientRegistry.bindTileEntitySpecialRenderer(PortalTileEntity.class, (TileEntitySpecialRenderer)new PortalTESR());
    }

    static {
        double half = 1.0;
        PortalTESR.faces[EnumFacing.DOWN.ordinal()] = new Face(0.5, 0.9, 0.5, -1.0, 0.0, -1.0, -1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, -1.0);
        PortalTESR.faces[EnumFacing.UP.ordinal()] = new Face(0.5, 0.1, 0.5, -1.0, 0.0, -1.0, -1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, -1.0);
        PortalTESR.faces[EnumFacing.SOUTH.ordinal()] = new Face(0.5, 1.0, 0.1, -half, -1.0, 0.0, -half, 1.0, 0.0, half, 1.0, 0.0, half, -1.0, 0.0);
        PortalTESR.faces[EnumFacing.NORTH.ordinal()] = new Face(0.5, 1.0, 0.9, -half, -1.0, 0.0, -half, 1.0, 0.0, half, 1.0, 0.0, half, -1.0, 0.0);
        PortalTESR.faces[EnumFacing.EAST.ordinal()] = new Face(0.1, 1.0, 0.5, 0.0, -1.0, -half, 0.0, 1.0, -half, 0.0, 1.0, half, 0.0, -1.0, half);
        PortalTESR.faces[EnumFacing.WEST.ordinal()] = new Face(0.9, 1.0, 0.5, 0.0, -1.0, -half, 0.0, 1.0, -half, 0.0, 1.0, half, 0.0, -1.0, half);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            PortalTESR.revertedfaces[facing.ordinal()] = faces[facing.ordinal()].reverse();
        }
    }

    private static class Face {
        public final double ox;
        public final double oy;
        public final double oz;
        public final double x0;
        public final double y0;
        public final double z0;
        public final double x1;
        public final double y1;
        public final double z1;
        public final double x2;
        public final double y2;
        public final double z2;
        public final double x3;
        public final double y3;
        public final double z3;

        public Face(double ox, double oy, double oz, double x0, double y0, double z0, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3) {
            this.ox = ox;
            this.oy = oy;
            this.oz = oz;
            this.x0 = x0;
            this.y0 = y0;
            this.z0 = z0;
            this.x1 = x1;
            this.y1 = y1;
            this.z1 = z1;
            this.x2 = x2;
            this.y2 = y2;
            this.z2 = z2;
            this.x3 = x3;
            this.y3 = y3;
            this.z3 = z3;
        }

        public Face reverse() {
            return new Face(this.ox, this.oy, this.oz, this.x3, this.y3, this.z3, this.x2, this.y2, this.z2, this.x1, this.y1, this.z1, this.x0, this.y0, this.z0);
        }
    }
}

