/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.blocks;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.lib.varia.SoundTools;
import mcjty.lib.varia.TeleportationTools;
import mcjty.meecreeps.config.ConfigSetup;
import mcjty.meecreeps.teleport.TeleportDestination;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PortalTileEntity
extends TileEntity
implements ITickable {
    private int timeout;
    private boolean soundStart = false;
    private boolean soundEnd = false;
    private int start;
    private TeleportDestination other;
    private EnumFacing portalSide;
    private AxisAlignedBB box = null;
    private Set<UUID> blackListed = new HashSet<UUID>();

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            SoundEvent sound;
            this.tickTime();
            if (this.timeout <= 0) {
                this.killPortal();
                this.getOther().ifPresent(PortalTileEntity::killPortal);
                return;
            }
            if (!this.soundStart && this.timeout > ConfigSetup.portalTimeout.get() - 10) {
                this.soundStart = true;
                sound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("meecreeps", "portal"));
                SoundTools.playSound((World)this.field_145850_b, (SoundEvent)sound, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)1.0, (double)1.0);
            }
            if (!this.soundEnd && this.timeout < 10) {
                this.soundEnd = true;
                if (ConfigSetup.teleportVolume.get() > (double)0.01f) {
                    sound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("meecreeps", "portal"));
                    SoundTools.playSound((World)this.field_145850_b, (SoundEvent)sound, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)ConfigSetup.teleportVolume.get(), (double)1.0);
                }
            }
            this.getOther().ifPresent(otherPortal -> {
                double otherX = (double)otherPortal.func_174877_v().func_177958_n() + 0.5;
                double otherY = (double)otherPortal.func_174877_v().func_177956_o() + 0.5;
                double otherZ = (double)otherPortal.func_174877_v().func_177952_p() + 0.5;
                List entities = this.field_145850_b.func_72872_a(Entity.class, this.getTeleportBox());
                for (Entity entity : entities) {
                    if (this.blackListed.contains(entity.func_110124_au())) continue;
                    otherPortal.addBlackList(entity.func_110124_au());
                    double oy = otherY;
                    if (otherPortal.getPortalSide() == EnumFacing.DOWN) {
                        oy -= (double)entity.field_70131_O + 0.7;
                    }
                    TeleportationTools.teleportEntity((Entity)entity, (World)otherPortal.func_145831_w(), (double)otherX, (double)oy, (double)otherZ, (EnumFacing)otherPortal.getPortalSide());
                    this.setTimeout(ConfigSetup.portalTimeoutAfterEntry.get());
                    otherPortal.setTimeout(ConfigSetup.portalTimeoutAfterEntry.get());
                    if (!(entity instanceof EntityPlayer) || !(ConfigSetup.teleportVolume.get() > (double)0.01f)) continue;
                    SoundEvent sound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("meecreeps", "teleport"));
                    SoundTools.playSound((World)otherPortal.func_145831_w(), (SoundEvent)sound, (double)otherX, (double)otherY, (double)otherZ, (double)ConfigSetup.teleportVolume.get(), (double)1.0);
                }
            });
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74768_a("timeout", this.timeout);
        nbtTag.func_74768_a("start", ConfigSetup.portalTimeout.get() - this.timeout);
        nbtTag.func_74774_a("portalSide", this.portalSide == null ? (byte)127 : (byte)this.portalSide.ordinal());
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.timeout = packet.func_148857_g().func_74762_e("timeout");
        this.start = packet.func_148857_g().func_74762_e("start");
        byte side = packet.func_148857_g().func_74771_c("portalSide");
        this.portalSide = side == 127 ? null : EnumFacing.field_82609_l[side];
    }

    private AxisAlignedBB getTeleportBox() {
        if (this.box == null) {
            switch (this.portalSide) {
                case DOWN: {
                    this.box = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 0.7, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() - 0.7, (double)this.field_174879_c.func_177958_n() + 1.7, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 1.7);
                    break;
                }
                case UP: {
                    this.box = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 0.7, (double)this.field_174879_c.func_177956_o() - 0.2, (double)this.field_174879_c.func_177952_p() - 0.7, (double)this.field_174879_c.func_177958_n() + 1.7, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 1.7);
                    break;
                }
                case SOUTH: {
                    this.box = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 0.2, (double)this.field_174879_c.func_177956_o() - 1.2, (double)this.field_174879_c.func_177952_p() - 0.2, (double)this.field_174879_c.func_177958_n() + 1.2, (double)this.field_174879_c.func_177956_o() + 2.2, (double)this.field_174879_c.func_177952_p() + 0.2);
                    break;
                }
                case NORTH: {
                    this.box = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 0.2, (double)this.field_174879_c.func_177956_o() - 1.2, (double)this.field_174879_c.func_177952_p() + 0.8, (double)this.field_174879_c.func_177958_n() + 1.2, (double)this.field_174879_c.func_177956_o() + 2.2, (double)this.field_174879_c.func_177952_p() + 1.2);
                    break;
                }
                case EAST: {
                    this.box = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 0.2, (double)this.field_174879_c.func_177956_o() - 1.2, (double)this.field_174879_c.func_177952_p() - 0.2, (double)this.field_174879_c.func_177958_n() + 0.2, (double)this.field_174879_c.func_177956_o() + 2.2, (double)this.field_174879_c.func_177952_p() + 1.2);
                    break;
                }
                case WEST: {
                    this.box = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() + 0.8, (double)this.field_174879_c.func_177956_o() - 1.2, (double)this.field_174879_c.func_177952_p() - 0.2, (double)this.field_174879_c.func_177958_n() + 1.2, (double)this.field_174879_c.func_177956_o() + 2.2, (double)this.field_174879_c.func_177952_p() + 1.2);
                }
            }
        }
        return this.box;
    }

    public void addBlackList(UUID uuid) {
        this.blackListed.add(uuid);
        this.markDirtyQuick();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getStart() {
        return this.start;
    }

    private void markDirtyClient() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    private void markDirtyQuick() {
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }

    public EnumFacing getPortalSide() {
        return this.portalSide;
    }

    public void setPortalSide(EnumFacing portalSide) {
        this.portalSide = portalSide;
        this.box = null;
        this.markDirtyClient();
    }

    public void tickTime() {
        --this.timeout;
        this.getOther().ifPresent(otherPortal -> {
            int otherTimeout = otherPortal.getTimeout();
            if (this.timeout > otherTimeout) {
                this.timeout = otherTimeout;
            }
        });
        this.markDirtyClient();
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
        this.markDirtyClient();
    }

    public void setOther(TeleportDestination other) {
        this.other = other;
        this.markDirtyQuick();
    }

    public void killPortal() {
        this.field_145850_b.func_175698_g(this.func_174877_v());
    }

    private Optional<PortalTileEntity> getOther() {
        World otherWorld = TeleportationTools.getWorldForDimension((int)this.other.getDimension());
        TileEntity te = otherWorld.func_175625_s(this.other.getPos());
        if (te instanceof PortalTileEntity) {
            return Optional.of((PortalTileEntity)te);
        }
        return Optional.empty();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.timeout = compound.func_74762_e("timeout");
        byte pside = compound.func_74771_c("portalSide");
        this.portalSide = pside == 127 ? null : EnumFacing.field_82609_l[pside];
        BlockPos pos = BlockPos.func_177969_a((long)compound.func_74763_f("pos"));
        int dim = compound.func_74762_e("dim");
        EnumFacing side = EnumFacing.field_82609_l[compound.func_74771_c("side")];
        this.other = new TeleportDestination("", dim, pos, side);
        NBTTagList list = compound.func_150295_c("bl", 10);
        this.blackListed.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tc = list.func_150305_b(i);
            UUID uuid = new UUID(tc.func_74763_f("m"), tc.func_74763_f("l"));
            this.blackListed.add(uuid);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("timeout", this.timeout);
        compound.func_74774_a("portalSide", this.portalSide == null ? (byte)127 : (byte)this.portalSide.ordinal());
        compound.func_74772_a("pos", this.other.getPos().func_177986_g());
        compound.func_74768_a("dim", this.other.getDimension());
        compound.func_74774_a("side", (byte)this.other.getSide().ordinal());
        NBTTagList list = new NBTTagList();
        for (UUID uuid : this.blackListed) {
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74772_a("m", uuid.getMostSignificantBits());
            tc.func_74772_a("l", uuid.getLeastSignificantBits());
            list.func_74742_a((NBTBase)tc);
        }
        compound.func_74782_a("bl", (NBTBase)list);
        return super.func_189515_b(compound);
    }
}

