/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.network.PacketSendServerCommand;
import mcjty.lib.typed.TypedMap;
import mcjty.meecreeps.CommandHandler;
import mcjty.meecreeps.MeeCreeps;
import mcjty.meecreeps.actions.ClientActionManager;
import mcjty.meecreeps.gui.GuiAskName;
import mcjty.meecreeps.items.PortalGunItem;
import mcjty.meecreeps.network.MeeCreepsMessages;
import mcjty.meecreeps.teleport.TeleportDestination;
import mcjty.meecreeps.teleport.TeleportationTools;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiWheel
extends GuiScreen {
    private static final int WIDTH = 160;
    private static final int HEIGHT = 160;
    private int guiLeft;
    private int guiTop;
    private int lastSelected = -1;
    private static final ResourceLocation background = new ResourceLocation("meecreeps", "textures/gui/wheel.png");
    private static final ResourceLocation hilight = new ResourceLocation("meecreeps", "textures/gui/wheel_hilight.png");
    public static BlockPos selectedBlock;
    public static EnumFacing selectedSide;
    private static final List<Pair<Integer, Integer>> iconOffsets;

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - 160) / 2;
        this.guiTop = (this.field_146295_m - 160) / 2;
    }

    private static boolean isKeyDown(KeyBinding key) {
        int i = key.func_151463_i();
        return i != 0 && i < 256 ? (i < 0 ? Mouse.isButtonDown((int)(i + 100)) : Keyboard.isKeyDown((int)i)) : false;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        ItemStack heldItem;
        List<TeleportDestination> destinations;
        super.func_73869_a(typedChar, keyCode);
        if ((keyCode == 211 || keyCode == 14) && this.lastSelected != -1 && (destinations = PortalGunItem.getDestinations(heldItem = PortalGunItem.getGun((EntityPlayer)this.field_146297_k.field_71439_g))).get(this.lastSelected) != null) {
            MeeCreepsMessages.INSTANCE.sendToServer((IMessage)new PacketSendServerCommand("meecreeps", "delete_dest", TypedMap.builder().put(CommandHandler.PARAM_ID, (Object)this.lastSelected).build()));
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int cx = mouseX - this.guiLeft - 80;
        int cy = mouseY - this.guiTop - 80;
        int q = this.getSelectedSection(cx, cy);
        if (q == -1) {
            this.closeThis();
        } else {
            ItemStack heldItem = PortalGunItem.getGun((EntityPlayer)this.field_146297_k.field_71439_g);
            if (!heldItem.func_190926_b()) {
                List<TeleportDestination> destinations = PortalGunItem.getDestinations(heldItem);
                if (destinations.get(q) != null) {
                    MeeCreepsMessages.INSTANCE.sendToServer((IMessage)new PacketSendServerCommand("meecreeps", "set_current", TypedMap.builder().put(CommandHandler.PARAM_ID, (Object)q).build()));
                } else {
                    BlockPos bestPosition = TeleportationTools.findBestPosition((World)this.field_146297_k.field_71441_e, selectedBlock, selectedSide);
                    if (bestPosition == null) {
                        this.closeThis();
                        ClientActionManager.showProblem("message.meecreeps.cant_find_portal_spot", new String[0]);
                        return;
                    }
                    GuiAskName.destinationIndex = q;
                    GuiAskName.destination = new TeleportDestination("", this.field_146297_k.field_71441_e.field_73011_w.getDimension(), bestPosition, selectedSide);
                    this.closeThis();
                    this.field_146297_k.field_71439_g.openGui((Object)MeeCreeps.instance, 4, (World)this.field_146297_k.field_71441_e, selectedBlock.func_177958_n(), selectedBlock.func_177956_o(), selectedBlock.func_177952_p());
                    return;
                }
            }
            this.closeThis();
        }
    }

    private void closeThis() {
        this.field_146297_k.func_147108_a(null);
        if (this.field_146297_k.field_71462_r == null) {
            this.field_146297_k.func_71381_h();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int currentDestination;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179147_l();
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 160, 160);
        int cx = mouseX - this.guiLeft - 80;
        int cy = mouseY - this.guiTop - 80;
        int offset = 4;
        this.lastSelected = this.getSelectedSection(cx, cy);
        if (this.lastSelected != -1) {
            this.drawSelectedSection(offset, this.lastSelected, 0);
            if (this.lastSelected < 8) {
                this.drawTooltip(this.lastSelected);
            }
        }
        if ((currentDestination = PortalGunItem.getCurrentDestination(PortalGunItem.getGun((EntityPlayer)this.field_146297_k.field_71439_g))) != -1) {
            this.drawSelectedSection(offset, currentDestination, 128);
        }
        this.drawIcons(offset, this.lastSelected);
        if (this.lastSelected != -1 && this.lastSelected < 8) {
            List<TeleportDestination> destinations = PortalGunItem.getDestinations(PortalGunItem.getGun((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
            TeleportDestination destination = destinations.get(this.lastSelected);
            ArrayList<String> tooltips = new ArrayList<String>();
            if (destination == null) {
                tooltips.add(TextFormatting.BLUE + "Click: " + TextFormatting.WHITE + "to set current location as destination");
            } else {
                tooltips.add(TextFormatting.BLUE + "Click: " + TextFormatting.WHITE + "to set this destination as current");
                tooltips.add(TextFormatting.BLUE + "Del: " + TextFormatting.WHITE + "to remove this destination");
            }
            this.func_146283_a(tooltips, mouseX, mouseY);
        }
    }

    private void drawIcons(int offset, int q) {
        List<TeleportDestination> destinations = PortalGunItem.getDestinations(PortalGunItem.getGun((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        for (int i = 0; i < 8; ++i) {
            String id = destinations.get(i) == null ? "" : destinations.get(i).getName();
            int offs = (i - offset + 8) % 8;
            double angle = Math.PI * 2 * (double)offs / 8.0 - 1.5707963267948966 + 0.39269908169872414;
            int tx = (int)((double)(this.guiLeft + 80) + 60.0 * Math.cos(angle));
            int ty = (int)((double)(this.guiTop + 80) + 60.0 * Math.sin(angle));
            RenderHelper.renderText((Minecraft)this.field_146297_k, (int)(tx - this.field_146297_k.field_71466_p.func_78256_a(id) / 2), (int)(ty - this.field_146297_k.field_71466_p.field_78288_b / 2), (String)id);
        }
    }

    private void renderTooltipText(String desc) {
        int width = this.field_146297_k.field_71466_p.func_78256_a(desc);
        int x = this.guiLeft + (160 - width) / 2;
        int y = this.guiTop + 160 + 5;
        RenderHelper.renderText((Minecraft)this.field_146297_k, (int)x, (int)y, (String)desc);
    }

    private void drawTooltip(int q) {
        List<TeleportDestination> destinations = PortalGunItem.getDestinations(PortalGunItem.getGun((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        TeleportDestination destination = destinations.get(q);
        if (destination == null) {
            this.renderTooltipText(I18n.func_135052_a((String)"message.meecreeps.gui.destination_not_set", (Object[])new Object[0]));
        } else {
            BlockPos p = destination.getPos();
            if (destination.getDimension() == Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension()) {
                double dist = Math.sqrt(p.func_177951_i((Vec3i)Minecraft.func_71410_x().field_71439_g.func_180425_c()));
                this.renderTooltipText(p.func_177958_n() + "," + p.func_177956_o() + "," + p.func_177952_p() + " (" + (int)dist + " blocks)");
            } else {
                this.renderTooltipText(p.func_177958_n() + "," + p.func_177956_o() + "," + p.func_177952_p() + " (dim " + destination.getDimension() + ")");
            }
        }
    }

    private void drawSelectedSection(int offset, int q, int voffset) {
        this.field_146297_k.func_110434_K().func_110577_a(hilight);
        switch ((q - offset + 8) % 8) {
            case 0: {
                this.func_73729_b(this.guiLeft + 78, this.guiTop, 0, voffset, 63, 63);
                break;
            }
            case 1: {
                this.func_73729_b(this.guiLeft + 107, this.guiTop + 22, 64, voffset, 63, 63);
                break;
            }
            case 2: {
                this.func_73729_b(this.guiLeft + 107, this.guiTop + 78, 128, voffset, 63, 63);
                break;
            }
            case 3: {
                this.func_73729_b(this.guiLeft + 78, this.guiTop + 108, 192, voffset, 63, 63);
                break;
            }
            case 4: {
                this.func_73729_b(this.guiLeft + 23, this.guiTop + 107, 0, voffset + 64, 63, 63);
                break;
            }
            case 5: {
                this.func_73729_b(this.guiLeft, this.guiTop + 78, 64, voffset + 64, 63, 63);
                break;
            }
            case 6: {
                this.func_73729_b(this.guiLeft, this.guiTop + 22, 128, voffset + 64, 63, 63);
                break;
            }
            case 7: {
                this.func_73729_b(this.guiLeft + 22, this.guiTop, 192, voffset + 64, 63, 63);
            }
        }
    }

    private int getSelectedSection(int cx, int cy) {
        double dist = Math.sqrt(cx * cx + cy * cy);
        if (dist < 37.0 || dist > 80.0) {
            return -1;
        }
        int q = -1;
        if (cx >= 0 && cy < 0 && Math.abs(cx) < Math.abs(cy)) {
            q = 0;
        } else if (cx >= 0 && cy < 0 && Math.abs(cx) >= Math.abs(cy)) {
            q = 1;
        } else if (cx >= 0 && cy >= 0 && Math.abs(cx) >= Math.abs(cy)) {
            q = 2;
        } else if (cx >= 0 && cy >= 0 && Math.abs(cx) < Math.abs(cy)) {
            q = 3;
        } else if (cx < 0 && cy >= 0 && Math.abs(cx) < Math.abs(cy)) {
            q = 4;
        } else if (cx < 0 && cy >= 0 && Math.abs(cx) >= Math.abs(cy)) {
            q = 5;
        } else if (cx < 0 && cy < 0 && Math.abs(cx) >= Math.abs(cy)) {
            q = 6;
        } else if (cx < 0 && cy < 0 && Math.abs(cx) < Math.abs(cy)) {
            q = 7;
        }
        int offset = 4;
        return (q + offset) % 8;
    }

    static {
        iconOffsets = new ArrayList<Pair<Integer, Integer>>();
        iconOffsets.add((Pair<Integer, Integer>)Pair.of((Object)86, (Object)8));
        iconOffsets.add((Pair<Integer, Integer>)Pair.of((Object)119, (Object)41));
        iconOffsets.add((Pair<Integer, Integer>)Pair.of((Object)119, (Object)87));
        iconOffsets.add((Pair<Integer, Integer>)Pair.of((Object)87, (Object)119));
        iconOffsets.add((Pair<Integer, Integer>)Pair.of((Object)41, (Object)118));
        iconOffsets.add((Pair<Integer, Integer>)Pair.of((Object)10, (Object)87));
        iconOffsets.add((Pair<Integer, Integer>)Pair.of((Object)9, (Object)41));
        iconOffsets.add((Pair<Integer, Integer>)Pair.of((Object)41, (Object)8));
    }
}

