/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.mirror.stream;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.shadowfacts.mirror.MirrorClass;
import net.shadowfacts.mirror.stream.FieldStream;
import net.shadowfacts.mirror.stream.MethodStream;

public class ClassStream
implements Stream<MirrorClass<?>> {
    private Stream<MirrorClass<?>> underlying;

    public ClassStream(Stream<MirrorClass<?>> underlying) {
        this.underlying = underlying;
    }

    public Stream<Class<?>> unwrap() {
        return this.map((Function)MirrorClass::unwrap);
    }

    public ClassStream isInner() {
        return this.filter(MirrorClass::isInner);
    }

    public ClassStream isNotInner() {
        return this.filter(MirrorClass::isNotInner);
    }

    public ClassStream isSubClassOf(Class<?> clazz) {
        return this.filter((T c) -> c.isSubClassOf(clazz));
    }

    public ClassStream isSubClassOf(MirrorClass<?> clazz) {
        return this.isSubClassOf(clazz.unwrap());
    }

    public ClassStream isSuperClassOf(Class<?> clazz) {
        return this.filter((T c) -> c.isSuperClassOf(clazz));
    }

    public ClassStream isSuperClassOf(MirrorClass<?> clazz) {
        return this.isSuperClassOf(clazz.unwrap());
    }

    public ClassStream isInterface() {
        return this.filter(MirrorClass::isInterface);
    }

    public ClassStream isNotInterface() {
        return this.filter(MirrorClass::isNotInterface);
    }

    public ClassStream mapToSuperClass() {
        return new ClassStream(this.map((Function)MirrorClass::getSuperClass));
    }

    public ClassStream flatMapToInterfaces() {
        return new ClassStream(this.map((Function)MirrorClass::getInterfaces).flatMap(Arrays::stream));
    }

    public ClassStream hasAnnotation(Class<? extends Annotation> clazz) {
        return this.filter((T c) -> c.hasAnnotation(clazz));
    }

    public <A extends Annotation> Stream<A> getAnnotation(Class<A> clazz) {
        return this.hasAnnotation(clazz).map((Function)c -> c.getAnnotation(clazz));
    }

    public FieldStream mapToField(String ... names) {
        return new FieldStream(this.map((Function)c -> c.field(names)).filter(Optional::isPresent).map(Optional::get));
    }

    public FieldStream mapToDeclaredField(String ... names) {
        return new FieldStream(this.map((Function)c -> c.declaredField(names)).filter(Optional::isPresent).map(Optional::get));
    }

    public FieldStream flatMapToFields() {
        return new FieldStream(this.flatMap((Function)MirrorClass::fields));
    }

    public FieldStream flatMapToDeclaredFields() {
        return new FieldStream(this.flatMap((Function)MirrorClass::declaredFields));
    }

    public MethodStream mapToMethod(String[] names, Class<?> ... args) {
        return new MethodStream(this.map((Function)c -> c.method(names, args)).filter(Optional::isPresent).map(Optional::get));
    }

    public MethodStream mapToMethod(String name, Class<?> ... args) {
        return this.mapToMethod(new String[]{name}, args);
    }

    public MethodStream mapToDeclaredMethod(String[] names, Class<?> ... args) {
        return new MethodStream(this.map((Function)c -> c.declaredMethod(names, args)).filter(Optional::isPresent).map(Optional::get));
    }

    public MethodStream mapToDeclaredMethod(String name, Class<?> ... args) {
        return this.mapToDeclaredMethod(new String[]{name}, args);
    }

    public MethodStream flatMapToMethods() {
        return new MethodStream(this.flatMap((Function)MirrorClass::methods));
    }

    public MethodStream flatMapToDeclaredMethods() {
        return new MethodStream(this.flatMap((Function)MirrorClass::declaredMethods));
    }

    public ClassStream filter(Predicate<? super MirrorClass<?>> predicate) {
        return new ClassStream(this.underlying.filter(predicate));
    }

    @Override
    public <R> Stream<R> map(Function<? super MirrorClass<?>, ? extends R> mapper) {
        return this.underlying.map(mapper);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super MirrorClass<?>> mapper) {
        return this.underlying.mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super MirrorClass<?>> mapper) {
        return this.underlying.mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super MirrorClass<?>> mapper) {
        return this.underlying.mapToDouble(mapper);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super MirrorClass<?>, ? extends Stream<? extends R>> mapper) {
        return this.underlying.flatMap(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super MirrorClass<?>, ? extends IntStream> mapper) {
        return this.underlying.flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super MirrorClass<?>, ? extends LongStream> mapper) {
        return this.underlying.flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super MirrorClass<?>, ? extends DoubleStream> mapper) {
        return this.underlying.flatMapToDouble(mapper);
    }

    public ClassStream distinct() {
        return new ClassStream(this.underlying.distinct());
    }

    public ClassStream sorted() {
        return new ClassStream(this.underlying.sorted());
    }

    public ClassStream sorted(Comparator<? super MirrorClass<?>> comparator) {
        return new ClassStream(this.underlying.sorted(comparator));
    }

    public ClassStream peek(Consumer<? super MirrorClass<?>> action) {
        return new ClassStream(this.underlying.peek(action));
    }

    public ClassStream limit(long maxSize) {
        return new ClassStream(this.underlying.limit(maxSize));
    }

    public ClassStream skip(long n) {
        return new ClassStream(this.underlying.skip(n));
    }

    @Override
    public void forEach(Consumer<? super MirrorClass<?>> action) {
        this.underlying.forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super MirrorClass<?>> action) {
        this.underlying.forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.underlying.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.underlying.toArray(generator);
    }

    @Override
    public MirrorClass<?> reduce(MirrorClass<?> identity, BinaryOperator<MirrorClass<?>> accumulator) {
        return this.underlying.reduce(identity, accumulator);
    }

    @Override
    public Optional<MirrorClass<?>> reduce(BinaryOperator<MirrorClass<?>> accumulator) {
        return this.underlying.reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super MirrorClass<?>, U> accumulator, BinaryOperator<U> combiner) {
        return this.underlying.reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super MirrorClass<?>> accumulator, BiConsumer<R, R> combiner) {
        return this.underlying.collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super MirrorClass<?>, A, R> collector) {
        return this.underlying.collect(collector);
    }

    @Override
    public Optional<MirrorClass<?>> min(Comparator<? super MirrorClass<?>> comparator) {
        return this.underlying.min(comparator);
    }

    @Override
    public Optional<MirrorClass<?>> max(Comparator<? super MirrorClass<?>> comparator) {
        return this.underlying.max(comparator);
    }

    @Override
    public long count() {
        return this.underlying.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super MirrorClass<?>> predicate) {
        return this.underlying.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super MirrorClass<?>> predicate) {
        return this.underlying.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super MirrorClass<?>> predicate) {
        return this.underlying.noneMatch(predicate);
    }

    @Override
    public Optional<MirrorClass<?>> findFirst() {
        return this.underlying.findFirst();
    }

    @Override
    public Optional<MirrorClass<?>> findAny() {
        return this.underlying.findAny();
    }

    @Override
    public Iterator<MirrorClass<?>> iterator() {
        return this.underlying.iterator();
    }

    @Override
    public Spliterator<MirrorClass<?>> spliterator() {
        return this.underlying.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.underlying.isParallel();
    }

    @Override
    public ClassStream sequential() {
        return new ClassStream((Stream)this.underlying.sequential());
    }

    @Override
    public ClassStream parallel() {
        return new ClassStream((Stream)this.underlying.parallel());
    }

    @Override
    public ClassStream unordered() {
        return new ClassStream((Stream)this.underlying.unordered());
    }

    @Override
    public ClassStream onClose(Runnable closeHandler) {
        return new ClassStream((Stream)this.underlying.onClose(closeHandler));
    }

    @Override
    public void close() {
        this.underlying.close();
    }
}

