/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat;

import buildcraft.api.core.BCLog;
import buildcraft.compat.CompatModuleBase;
import buildcraft.compat.module.crafttweaker.CompatModuleCraftTweaker;
import buildcraft.compat.module.forestry.CompatModuleForestry;
import buildcraft.compat.module.ic2.CompatModuleIndustrialCraft2;
import buildcraft.compat.module.theoneprobe.CompatModuleTheOneProbe;
import buildcraft.compat.network.CompatGui;
import buildcraft.core.BCCoreConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

@Mod(modid="buildcraftcompat", name="BuildCraft Compat", version="7.99.24.7", updateJSON="https://mod-buildcraft.com/version/versions-compat.json", acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:forge@[14.23.0.2544,);required-after:buildcraftcore@[7.99.24.7,);after:buildcrafttransport;after:buildcraftbuilders;after:buildcraftsilicon;after:theoneprobe;after:forestry;after:crafttweaker;after:ic2")
public class BCCompat {
    static final String DEPENDENCIES = "required-after:forge@[14.23.0.2544,);required-after:buildcraftcore@[7.99.24.7,);after:buildcrafttransport;after:buildcraftbuilders;after:buildcraftsilicon;after:theoneprobe;after:forestry;after:crafttweaker;after:ic2";
    public static final String MODID = "buildcraftcompat";
    public static final String VERSION = "7.99.24.7";
    public static final String GIT_BRANCH = "8.0.x-1.12.2";
    public static final String GIT_COMMIT_HASH = "9a9b21a4571700fb84f507820f8d029c958f523e";
    public static final String GIT_COMMIT_MSG = "Update bc (3)";
    public static final String GIT_COMMIT_AUTHOR = "AlexIIL";
    @Mod.Instance(value="buildcraftcompat")
    public static BCCompat instance;
    private static final Map<String, CompatModuleBase> modules;

    private static void offerAndPreInitModule(CompatModuleBase module) {
        String cModId = module.compatModId();
        if (module.canLoad()) {
            Property prop = BCCoreConfig.config.get("modules", cModId, true);
            if (prop.getBoolean(true)) {
                modules.put(cModId, module);
                BCLog.logger.info("[compat]   + " + cModId);
                module.preInit();
            } else {
                BCLog.logger.info("[compat]   x " + cModId + " (It has been disabled in the config)");
            }
        } else {
            BCLog.logger.info("[compat]   x " + cModId + " (It cannot load)");
        }
    }

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent evt) {
        BCLog.logger.info("");
        BCLog.logger.info("Starting BuildCraftCompat 7.99.24.7");
        BCLog.logger.info("Copyright (c) the BuildCraft team, 2011-2017");
        BCLog.logger.info("https://www.mod-buildcraft.com");
        if (!GIT_COMMIT_HASH.startsWith("${")) {
            BCLog.logger.info("Detailed Build Information:");
            BCLog.logger.info("  Branch 8.0.x-1.12.2");
            BCLog.logger.info("  Commit 9a9b21a4571700fb84f507820f8d029c958f523e");
            BCLog.logger.info("    Update bc (3)");
            BCLog.logger.info("    committed by AlexIIL");
        }
        BCLog.logger.info("");
        BCLog.logger.info("[compat] Module list:");
        BCCompat.offerAndPreInitModule(new CompatModuleForestry());
        BCCompat.offerAndPreInitModule(new CompatModuleTheOneProbe());
        BCCompat.offerAndPreInitModule(new CompatModuleCraftTweaker());
        BCCompat.offerAndPreInitModule(new CompatModuleIndustrialCraft2());
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent evt) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)CompatGui.guiHandlerProxy);
        for (CompatModuleBase m : modules.values()) {
            m.init();
        }
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent evt) {
        for (CompatModuleBase m : modules.values()) {
            m.postInit();
        }
    }

    static {
        modules = new HashMap<String, CompatModuleBase>();
    }
}

