/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.containers.IRedstoneStatementContainer;
import buildcraft.api.statements.containers.ISidedStatementContainer;
import buildcraft.core.BCCoreSprites;
import buildcraft.core.BCCoreStatements;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.statements.StatementParamGateSideOnly;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.LocaleUtil;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ActionRedstoneOutput
extends BCStatement
implements IActionInternal {
    protected ActionRedstoneOutput(String s) {
        super(s);
    }

    public ActionRedstoneOutput() {
        super("buildcraft:redstone.output", "buildcraft.redstone.output");
    }

    @Override
    public String getDescription() {
        return LocaleUtil.localize("gate.action.redstone.signal");
    }

    @Override
    public IStatementParameter createParameter(int index) {
        switch (index) {
            case 0: {
                return StatementParamGateSideOnly.ANY;
            }
        }
        return null;
    }

    @Override
    public int maxParameters() {
        return 1;
    }

    protected boolean isSideOnly(IStatementParameter[] parameters) {
        if (parameters != null && parameters.length >= this.getRGSOSlot() + 1 && parameters[this.getRGSOSlot()] instanceof StatementParamGateSideOnly) {
            return ((StatementParamGateSideOnly)parameters[this.getRGSOSlot()]).isSpecific;
        }
        return false;
    }

    @Override
    public void actionActivate(IStatementContainer source, IStatementParameter[] parameters) {
        if (source instanceof IRedstoneStatementContainer) {
            EnumFacing side = null;
            if (source instanceof ISidedStatementContainer && this.isSideOnly(parameters)) {
                side = ((ISidedStatementContainer)source).getSide();
            }
            ((IRedstoneStatementContainer)((Object)source)).setRedstoneOutput(side, this.getSignalLevel(parameters));
        }
    }

    protected int getRGSOSlot() {
        return 0;
    }

    protected int getSignalLevel(IStatementParameter[] parameters) {
        return 15;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SpriteHolderRegistry.SpriteHolder getSprite() {
        return BCCoreSprites.ACTION_REDSTONE;
    }

    @Override
    public <T> T convertTo(Class<T> clazz) {
        T obj = super.convertTo(clazz);
        if (obj != null) {
            return obj;
        }
        if (clazz.isInstance(BCCoreStatements.TRIGGER_REDSTONE_ACTIVE)) {
            return clazz.cast(BCCoreStatements.TRIGGER_REDSTONE_ACTIVE);
        }
        return null;
    }
}

