/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.capabilities.entitydata;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import org.orecruncher.dsurround.capabilities.entitydata.IEntityDataSettable;
import org.orecruncher.dsurround.network.Network;
import org.orecruncher.dsurround.network.PacketEntityData;

public final class EntityData
implements IEntityDataSettable {
    public static final int NO_ENTITY = -1;
    private final EntityLiving entity;
    private boolean isAttacking;
    private boolean isFleeing;
    private boolean sync;

    public EntityData() {
        this.entity = null;
    }

    public EntityData(@Nonnull EntityLiving entity) {
        this.entity = entity;
    }

    @Override
    public EntityLiving getEntity() {
        return this.entity;
    }

    @Override
    public int getEntityId() {
        return this.entity != null ? this.entity.func_145782_y() : -1;
    }

    @Override
    public boolean isAttacking() {
        return this.isAttacking;
    }

    @Override
    public void setAttacking(boolean flag) {
        this.sync = this.isAttacking != flag | this.sync;
        this.isAttacking = flag;
    }

    @Override
    public boolean isFleeing() {
        return this.isFleeing;
    }

    @Override
    public void setFleeing(boolean flag) {
        this.sync = this.isFleeing != flag | this.sync;
        this.isFleeing = flag;
    }

    @Override
    public boolean needsSync() {
        return this.sync;
    }

    private void clearSync() {
        this.sync = false;
    }

    @Override
    public void sync() {
        if (this.needsSync() && this.entity != null && !this.entity.func_130014_f_().field_72995_K) {
            Network.sendToEntityViewers((Entity)this.entity, new PacketEntityData(this));
            this.clearSync();
        }
    }

    @Nonnull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("a", this.isAttacking());
        nbt.func_74757_a("f", this.isFleeing());
        return nbt;
    }

    public void deserializeNBT(@Nonnull NBTTagCompound nbt) {
        this.setAttacking(nbt.func_74767_n("a"));
        this.setFleeing(nbt.func_74767_n("f"));
    }

    private static class NBT {
        public static final String ATTACKING = "a";
        public static final String FLEEING = "f";

        private NBT() {
        }
    }
}

