/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.effects;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.effects.EventEffect;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.sound.ISoundInstance;
import org.orecruncher.dsurround.client.sound.Sounds;

@SideOnly(value=Side.CLIENT)
public class CraftingSoundEffect
extends EventEffect {
    private int craftSoundThrottle = 0;

    @SubscribeEvent
    public void onEvent(@Nonnull PlayerEvent.ItemCraftedEvent event) {
        if (!ModOptions.sound.enableCraftingSound || !this.isClientValid((PlayerEvent)event)) {
            return;
        }
        if (this.craftSoundThrottle >= EnvironStateHandler.EnvironState.getTickCounter() - 30) {
            return;
        }
        this.craftSoundThrottle = EnvironStateHandler.EnvironState.getTickCounter();
        ISoundInstance fx = this.getState().createSound(Sounds.CRAFTING, (Entity)event.player);
        this.getState().playSound(fx);
    }
}

