/*
 * Decompiled with CFR 0.152.
 */
package com.expensivekoala.refined_avaritia.network;

import com.expensivekoala.refined_avaritia.inventory.ItemHandlerRestricted;
import com.expensivekoala.refined_avaritia.network.Message;
import com.expensivekoala.refined_avaritia.tile.TileExtremePatternEncoder;
import com.expensivekoala.refined_avaritia.util.ExtendedCraftingUtil;
import com.expensivekoala.refined_avaritia.util.RecipeType;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageTransferAvaritiaRecipe
extends Message<MessageTransferAvaritiaRecipe>
implements IMessage {
    private int x;
    private int y;
    private int z;
    private NonNullList<ItemStack> items;
    private RecipeType type;

    public MessageTransferAvaritiaRecipe() {
    }

    public MessageTransferAvaritiaRecipe(int x, int y, int z, NonNullList<ItemStack> items, RecipeType type) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.items = items;
        this.type = type;
    }

    @Override
    public void handle(MessageTransferAvaritiaRecipe message, EntityPlayerMP player) {
        TileEntity tile;
        BlockPos pos = new BlockPos(message.x, message.y, message.z);
        if (player.func_130014_f_().func_175667_e(pos) && (tile = player.func_130014_f_().func_175625_s(pos)) instanceof TileExtremePatternEncoder) {
            TileExtremePatternEncoder encoder = (TileExtremePatternEncoder)tile;
            ItemHandlerRestricted recipe = (ItemHandlerRestricted)encoder.getRecipe();
            if (message.type == RecipeType.AVARITIA || message.type == RecipeType.EC_ULTIMATE) {
                for (int i = 0; i < recipe.getSlots(); ++i) {
                    recipe.setStackInSlot(i, (ItemStack)message.items.get(i));
                }
                encoder.setTableSize(ExtendedCraftingUtil.TableSize.ULTIMATE);
                encoder.setAvaritia(message.type == RecipeType.AVARITIA);
            } else {
                for (int i = 0; i < message.items.size(); ++i) {
                    int x = i % message.type.width;
                    int y = i / message.type.height;
                    recipe.setStackInSlot((y + (9 - message.type.height) / 2) * 9 + (x + (9 - message.type.width) / 2), (ItemStack)message.items.get(i));
                }
                encoder.setAvaritia(false);
                switch (message.type) {
                    case EC_BASIC: {
                        encoder.setTableSize(ExtendedCraftingUtil.TableSize.BASIC);
                        break;
                    }
                    case EC_ADVANCED: {
                        encoder.setTableSize(ExtendedCraftingUtil.TableSize.ADVANCED);
                        break;
                    }
                    case EC_ELITE: {
                        encoder.setTableSize(ExtendedCraftingUtil.TableSize.ELITE);
                        break;
                    }
                    case EC_ULTIMATE: {
                        encoder.setTableSize(ExtendedCraftingUtil.TableSize.ULTIMATE);
                    }
                }
            }
            ((TileExtremePatternEncoder)tile).onContentsChanged();
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.type = RecipeType.values()[buf.readInt()];
        if (this.items == null) {
            this.items = NonNullList.func_191197_a((int)(this.type.width * this.type.height), (Object)ItemStack.field_190927_a);
        }
        for (int i = 0; i < this.type.width * this.type.height; ++i) {
            this.items.set(i, (Object)ByteBufUtils.readItemStack((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.type.ordinal());
        for (int i = 0; i < this.type.width * this.type.height; ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStack)this.items.get(i)));
        }
    }
}

