/*
 * Decompiled with CFR 0.152.
 */
package com.expensivekoala.refined_avaritia.util;

import com.expensivekoala.refined_avaritia.item.ItemExtremePattern;
import com.expensivekoala.refined_avaritia.util.AvaritiaRecipeManagerWrapper;
import com.expensivekoala.refined_avaritia.util.ECRecipeManagerWrapper;
import com.expensivekoala.refined_avaritia.util.RecipeType;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.item.ItemPattern;
import java.util.ArrayList;
import java.util.List;
import morph.avaritia.recipe.extreme.IExtremeRecipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class ExtremePattern
implements ICraftingPattern {
    private ICraftingPatternContainer container;
    private ItemStack stack;
    private IExtremeRecipe avaritiaRecipe;
    private IRecipe extendedRecipe;
    private RecipeType recipeType;
    private boolean processing;
    private boolean oredict;
    private boolean valid;
    private List<NonNullList<ItemStack>> inputs = new ArrayList<NonNullList<ItemStack>>();
    private NonNullList<ItemStack> outputs = NonNullList.func_191196_a();
    private NonNullList<ItemStack> byproducts = NonNullList.func_191196_a();

    /*
     * WARNING - void declaration
     */
    public ExtremePattern(World world, ICraftingPatternContainer container, ItemStack stack) {
        this.container = container;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Type")) {
            this.recipeType = ItemExtremePattern.getType(stack);
        } else {
            if (stack.func_77942_o()) {
                return;
            }
            this.recipeType = RecipeType.AVARITIA;
        }
        this.stack = stack;
        this.processing = ItemPattern.isProcessing((ItemStack)stack);
        this.oredict = ItemExtremePattern.isOredict(stack);
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, this.recipeType.width, this.recipeType.height);
        for (int i = 0; i < this.recipeType.width * this.recipeType.height; ++i) {
            ItemStack itemStack = ItemExtremePattern.getSlot(stack, i);
            this.inputs.add((NonNullList<ItemStack>)(itemStack.func_190926_b() ? NonNullList.func_191196_a() : NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{itemStack})));
            if (itemStack.func_190926_b()) continue;
            inv.func_70299_a(i, itemStack);
        }
        if (!this.processing) {
            if (this.recipeType == RecipeType.AVARITIA) {
                for (IExtremeRecipe iExtremeRecipe : AvaritiaRecipeManagerWrapper.getRecipes()) {
                    if (!iExtremeRecipe.matches(inv, world)) continue;
                    this.avaritiaRecipe = iExtremeRecipe;
                    break;
                }
            } else {
                for (IExtremeRecipe iExtremeRecipe : ECRecipeManagerWrapper.getRecipes()) {
                    IRecipe r = (IRecipe)iExtremeRecipe;
                    if (!r.func_77569_a(inv, world)) continue;
                    this.extendedRecipe = r;
                    break;
                }
            }
            if (this.avaritiaRecipe != null || this.extendedRecipe != null) {
                ItemStack output;
                ItemStack itemStack = output = this.recipeType == RecipeType.AVARITIA ? this.avaritiaRecipe.getCraftingResult(inv) : this.extendedRecipe.func_77572_b(inv);
                if (!output.func_190926_b()) {
                    this.valid = true;
                    this.outputs.add((Object)output.func_77946_l());
                    NonNullList nonNullList = this.byproducts = this.recipeType == RecipeType.AVARITIA ? this.avaritiaRecipe.getRemainingItems(inv) : this.extendedRecipe.func_179532_b(inv);
                    if (this.oredict) {
                        void var6_16;
                        boolean bl = false;
                        if (this.recipeType == RecipeType.AVARITIA && this.avaritiaRecipe != null) {
                            int n = this.avaritiaRecipe.getIngredients().size();
                        } else if (this.extendedRecipe != null) {
                            int n = this.extendedRecipe.func_192400_c().size();
                        } else {
                            this.valid = false;
                        }
                        if (var6_16 > 0) {
                            this.inputs.clear();
                            for (Ingredient ingredient : this.recipeType == RecipeType.AVARITIA ? this.avaritiaRecipe.getIngredients() : this.extendedRecipe.func_192400_c()) {
                                this.inputs.add((NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])ingredient.func_193365_a()));
                            }
                        } else {
                            this.valid = false;
                        }
                    }
                }
            }
        }
    }

    public ICraftingPatternContainer getContainer() {
        return this.container;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isProcessing() {
        return false;
    }

    public boolean isOredict() {
        return this.oredict;
    }

    public NonNullList<ItemStack> getByproducts(NonNullList<ItemStack> took) {
        if (took.size() != this.inputs.size()) {
            throw new IllegalArgumentException("The items that are taken (" + took.size() + ") should match the inputs for this pattern (" + this.inputs.size() + ")");
        }
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, this.recipeType.width, this.recipeType.height);
        for (int i = 0; i < took.size(); ++i) {
            inv.func_70299_a(i, (ItemStack)took.get(i));
        }
        NonNullList remainingItems = this.recipeType == RecipeType.AVARITIA ? this.avaritiaRecipe.getRemainingItems(inv) : this.extendedRecipe.func_179532_b(inv);
        NonNullList sanitized = NonNullList.func_191196_a();
        for (ItemStack item : remainingItems) {
            if (item.func_190926_b()) continue;
            sanitized.add((Object)item);
        }
        return sanitized;
    }

    public String getId() {
        return "normal";
    }

    public List<NonNullList<ItemStack>> getInputs() {
        return this.inputs;
    }

    public NonNullList<ItemStack> getOutputs() {
        return this.outputs;
    }

    public ItemStack getOutput(NonNullList<ItemStack> took) {
        ItemStack result;
        if (took.size() != this.inputs.size()) {
            throw new IllegalArgumentException("The items that are taken (" + took.size() + ") should match the inputs for this pattern (" + this.inputs.size() + ")");
        }
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, this.recipeType.width, this.recipeType.height);
        for (int i = 0; i < took.size(); ++i) {
            inv.func_70299_a(i, (ItemStack)took.get(i));
        }
        ItemStack itemStack = result = this.recipeType == RecipeType.AVARITIA ? this.avaritiaRecipe.getCraftingResult(inv) : this.extendedRecipe.func_77572_b(inv);
        if (result.func_190926_b()) {
            throw new IllegalStateException("Cannot have empty result");
        }
        return result;
    }

    public NonNullList<ItemStack> getByproducts() {
        return this.byproducts;
    }

    public NonNullList<FluidStack> getFluidInputs() {
        return NonNullList.func_191196_a();
    }

    public NonNullList<FluidStack> getFluidOutputs() {
        return NonNullList.func_191196_a();
    }

    public boolean canBeInChainWith(ICraftingPattern other) {
        int i;
        if (other.isProcessing() || other.isOredict() != this.oredict) {
            return false;
        }
        if (other.getInputs().size() != this.inputs.size() || other.getFluidInputs().size() > 0 || other.getOutputs().size() != this.outputs.size() || other.getFluidOutputs().size() > 0) {
            return false;
        }
        if (other.getByproducts().size() != this.byproducts.size()) {
            return false;
        }
        for (i = 0; i < this.inputs.size(); ++i) {
            List inputs = (List)this.inputs.get(i);
            List otherInputs = (List)other.getInputs().get(i);
            if (inputs.size() != otherInputs.size()) {
                return false;
            }
            for (int j = 0; j < inputs.size(); ++j) {
                if (API.instance().getComparer().isEqual((ItemStack)inputs.get(j), (ItemStack)otherInputs.get(j))) continue;
                return false;
            }
        }
        for (i = 0; i < this.outputs.size(); ++i) {
            if (API.instance().getComparer().isEqual((ItemStack)this.outputs.get(i), (ItemStack)other.getOutputs().get(i))) continue;
            return false;
        }
        for (i = 0; i < this.byproducts.size(); ++i) {
            if (API.instance().getComparer().isEqual((ItemStack)this.byproducts.get(i), (ItemStack)other.getByproducts().get(i))) continue;
            return false;
        }
        return true;
    }

    public int getChainHashCode() {
        int result = 0;
        result = 31 * result + (this.oredict ? 1 : 0);
        for (List list : this.inputs) {
            for (ItemStack input : list) {
                result = 31 * result + API.instance().getItemStackHashCode(input);
            }
        }
        for (ItemStack itemStack : this.outputs) {
            result = 31 * result + API.instance().getItemStackHashCode(itemStack);
        }
        for (ItemStack itemStack : this.byproducts) {
            result = 31 * result + API.instance().getItemStackHashCode(itemStack);
        }
        return result;
    }
}

