/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.entity.ai;

import com.dhanantry.scapeandrunparasites.SRPMain;
import com.dhanantry.scapeandrunparasites.client.particle.ParticleSpawner;
import com.dhanantry.scapeandrunparasites.client.particle.SRPEnumParticle;
import com.dhanantry.scapeandrunparasites.entity.SRPAttributes;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIParasiteFollow;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIWanderStatus;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import com.dhanantry.scapeandrunparasites.world.SRPWorldData;
import com.dhanantry.scapeandrunparasites.world.biome.BiomeParasite;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public abstract class EntityParasiteBase
extends EntityMob {
    public double killcount = 0.0;
    protected boolean canD = true;
    private int waitInt;
    private boolean canWorkTask;
    private EntityParasiteBase owner;
    private static final DataParameter<Integer> SPECIAL = EntityDataManager.func_187226_a(EntityParasiteBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SELFE = EntityDataManager.func_187226_a(EntityParasiteBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SKIN = EntityDataManager.func_187226_a(EntityParasiteBase.class, (DataSerializer)DataSerializers.field_187192_b);
    protected int srpTicks;
    protected int lastActiveTime;
    protected int timeSinceIgnited;
    protected int fuseTime = 40;
    protected byte canModRender = 0;
    protected int attackCooldown;
    protected double madeRng = -1.0;
    protected byte type = 0;
    protected int damageCap = 1;
    protected byte phaseCreated;
    protected EntityAIJumping jumpT = new EntityAIJumping((EntityLiving)this);
    protected EntityAIWait wait = new EntityAIWait();
    protected EntityAIParasiteFollow folow = new EntityAIParasiteFollow(this, 1.3, 10.0, 2.0, true);
    protected EntityAIWanderStatus aiWander = new EntityAIWanderStatus(this, 1.0, 0.001f, true);
    protected EntityAINearestAttackableTarget<EntityPlayer> aiNearestAttackablePlayer = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true);
    protected EntityAINearestAttackableTarget<EntityLiving> aiAllMobs = new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, true, true, (Predicate)new Predicate<EntityLiving>(){

        public boolean apply(@Nullable EntityLiving entity) {
            return !(entity instanceof EntityWaterMob) && !(entity instanceof EntityCreeper) && !(entity instanceof EntityParasiteBase) && !(entity instanceof EntityAnimal) && !(entity instanceof EntityVillager) && !ParasiteEventEntity.checkEntity(entity, SRPConfig.mobattackingBlackList, SRPConfig.mobattackingBlackListWhite);
        }
    });

    public EntityParasiteBase(World worldIn) {
        super(worldIn);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.wait);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiWander);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.folow);
        this.field_70715_bh.func_75776_a(2, this.aiNearestAttackablePlayer);
        this.attackCooldown = 0;
        if (SRPConfig.mobattacking) {
            this.field_70715_bh.func_75776_a(3, this.aiAllMobs);
        }
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.jumpT);
        this.canWorkTask = true;
        this.srpTicks = 0;
        this.madeRng = -1.0;
    }

    public boolean func_175446_cd() {
        return super.func_175446_cd();
    }

    public void applyBonuses(int colony, int node, byte phase) {
        this.phaseCreated = phase;
        if (this.phaseCreated >= SRPConfig.evolutionAssimilatedDehiding) {
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, true));
        }
        this.setColonyBonus(colony);
        this.setNodeBonus(node);
    }

    private void setColonyBonus(int totalColonyPoints) {
        if (totalColonyPoints == 0) {
            return;
        }
        double bonus = (float)totalColonyPoints / SRPConfig.colonyExtraHealthPoint * SRPConfig.colonyExtraHealthValue;
        double currentV = this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(currentV + currentV * bonus);
        this.func_70606_j((float)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
        bonus = (float)totalColonyPoints / SRPConfig.colonyExtraArmorPoint * SRPConfig.colonyExtraArmorValue;
        currentV = this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111125_b();
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(currentV + currentV * bonus);
        bonus = (float)totalColonyPoints / SRPConfig.colonyExtraDamagePoint * SRPConfig.colonyExtraDamageValue;
        currentV = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(currentV + currentV * bonus);
        bonus = (float)totalColonyPoints / SRPConfig.colonyExtraKDResPoint * SRPConfig.colonyExtraKDResValue;
        currentV = this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111125_b();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(currentV + currentV * bonus);
        bonus = (float)totalColonyPoints / SRPConfig.colonyDamageCapPoint * SRPConfig.colonyDamageCapValue;
        this.damageCap = (int)((double)this.damageCap + (double)this.damageCap * bonus);
    }

    private void setNodeBonus(int totalPoints) {
        if (totalPoints == 0) {
            return;
        }
        String[] here = new String[3];
        for (String i : SRPConfig.potionEffectForNodes) {
            here = i.split(";");
            int level = Integer.parseInt(here[0]);
            if (totalPoints < level) continue;
            int amp = Integer.parseInt(here[2]);
            Potion potion = Potion.func_180142_b((String)here[1]);
            if (potion == null) continue;
            this.func_70690_d(new PotionEffect(potion, 7777, amp));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPECIAL, (Object)0);
        this.field_70180_af.func_187214_a(SELFE, (Object)-1);
        this.field_70180_af.func_187214_a(SKIN, (Object)0);
    }

    public void cannotDespawn(boolean in) {
        this.canD = in;
    }

    public boolean canDespawnMob() {
        return this.canD;
    }

    protected boolean func_70692_ba() {
        return this.canD;
    }

    public void func_70636_d() {
        if (this.getWait() > 0) {
            int j1 = this.getWait() - 1;
            if (j1 == 0) {
                this.setParasiteStatus(0);
            }
            this.setWait(j1);
        } else {
            super.func_70636_d();
        }
        if (!this.field_70170_p.field_72995_K) {
            ++this.srpTicks;
            int k = this.getParasiteStatus();
            if (this.getAttackCooldownAni() != 0 || k == 1 || k == 2) {
                if (this.getAttackCooldownAni() != 0) {
                    int i = this.getAttackCooldownAni() - 1;
                    this.setAttackCooldownAni(i);
                }
                if (k == 1 || k == 2) {
                    if (this.func_70638_az() != null) {
                        if (!this.func_70638_az().func_70089_S()) {
                            this.setParasiteStatus(0);
                        }
                    } else {
                        this.setParasiteStatus(0);
                    }
                }
            }
            if (this.srpTicks > 30) {
                this.srpTicks = 0;
                if (this.func_70638_az() instanceof EntityPlayer) {
                    try {
                        this.fearPlayer(this.func_70638_az());
                    }
                    catch (Exception e) {
                        SRPMain.logger.log(Level.ERROR, "Problem with Player", (Throwable)e);
                    }
                }
                if (SRPConfig.useEvolution && this.killcount >= 0.0) {
                    switch (this.phaseCreated) {
                        case 1: {
                            this.killcount += SRPConfig.phaseKillCountPlusOne;
                            break;
                        }
                        case 2: {
                            this.killcount += SRPConfig.phaseKillCountPlusTwo;
                            break;
                        }
                        case 3: {
                            this.killcount += SRPConfig.phaseKillCountPlusThree;
                            break;
                        }
                        case 4: {
                            this.killcount += SRPConfig.phaseKillCountPlusFour;
                            break;
                        }
                        case 5: {
                            this.killcount += SRPConfig.phaseKillCountPlusFive;
                            break;
                        }
                        case 6: {
                            this.killcount += SRPConfig.phaseKillCountPlusSix;
                            break;
                        }
                        case 7: {
                            this.killcount += SRPConfig.phaseKillCountPlusSeven;
                            break;
                        }
                        case 8: {
                            this.killcount += SRPConfig.phaseKillCountPlusEight;
                        }
                    }
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.killcount >= 0.0) {
                    this.killcount += SRPConfig.killcountplus;
                }
            }
        }
    }

    private void fearPlayer(EntityLivingBase player) {
        if (player == null) {
            return;
        }
        byte type = this.getParasiteType();
        if (type >= 60) {
            if (!player.func_70644_a(SRPPotions.FEAR_E)) {
                player.func_70690_d(new PotionEffect(SRPPotions.FEAR_E, 300, 3, false, false));
            } else if (player.func_70660_b(SRPPotions.FEAR_E).func_76458_c() < 3) {
                player.func_70690_d(new PotionEffect(SRPPotions.FEAR_E, 300, 3, false, false));
            }
        } else if (type >= 40) {
            if (!player.func_70644_a(SRPPotions.FEAR_E)) {
                player.func_70690_d(new PotionEffect(SRPPotions.FEAR_E, 300, 2, false, false));
            } else if (player.func_70660_b(SRPPotions.FEAR_E).func_76458_c() < 2) {
                player.func_70690_d(new PotionEffect(SRPPotions.FEAR_E, 300, 2, false, false));
            }
        } else if (type >= 30) {
            if (!player.func_70644_a(SRPPotions.FEAR_E)) {
                player.func_70690_d(new PotionEffect(SRPPotions.FEAR_E, 300, 1, false, false));
            } else if (player.func_70660_b(SRPPotions.FEAR_E).func_76458_c() < 1) {
                player.func_70690_d(new PotionEffect(SRPPotions.FEAR_E, 300, 1, false, false));
            }
        } else if (type >= 15 && !player.func_70644_a(SRPPotions.FEAR_E)) {
            player.func_70690_d(new PotionEffect(SRPPotions.FEAR_E, 300, 0, false, false));
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.getWait() > 0) {
            int j1 = this.getWait() - 1;
            if (j1 == 0) {
                this.setParasiteStatus(0);
            }
            this.setWait(j1);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        float damage;
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.madeRng == -1.0) {
            this.madeRng = this.field_70146_Z.nextInt(3);
            if (this.madeRng == 0.0) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)40);
            }
        }
        if (source == DamageSource.field_76380_i) {
            return super.func_70097_a(source, amount);
        }
        if (source == DamageSource.field_76372_a || source == DamageSource.field_76370_b) {
            if (!this.field_70178_ae) {
                super.func_70097_a(source, amount * SRPConfig.firemultyplier);
            } else {
                return false;
            }
        }
        if (amount >= (damage = this.func_110138_aP() / (float)this.damageCap + this.func_110138_aP() % (float)this.damageCap * 0.5f)) {
            source.func_76348_h();
        }
        return super.func_70097_a(source, Math.min(amount, damage));
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            this.setAttackCooldownAni(100);
        }
        return flag;
    }

    protected void alertOthers(double rangeXZ, double rangeY) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72314_b(rangeXZ, rangeY, rangeXZ);
        List moblist = this.field_70170_p.func_72872_a(EntityParasiteBase.class, axisalignedbb);
        for (EntityParasiteBase mob : moblist) {
            if (mob == null || !mob.func_70089_S() || mob == this || mob.func_70638_az() != null) continue;
            mob.func_70624_b(this.func_70638_az());
        }
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        if (this.killcount >= 0.0) {
            this.killcount += 1.0;
        }
        if (!this.field_70170_p.field_72995_K && SRPConfig.useEvolution) {
            SRPWorldData data = SRPWorldData.get(this.field_70170_p);
            data.setTotalKills(SRPConfig.valueKill, true, this.field_70170_p);
        }
        if (entityLivingIn.func_70644_a(SRPPotions.COTH_E) && this.field_70146_Z.nextDouble() < (double)SRPConfig.cothConvert) {
            ParasiteEventEntity.convertEntity(entityLivingIn, entityLivingIn.getEntityData(), true, SRPConfig.COTHVictimParasite);
        }
        this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 80, 0, false, false));
        this.setWait(10);
    }

    public int getSelfeState() {
        return (Integer)this.field_70180_af.func_187225_a(SELFE);
    }

    public void setSelfeState(int state) {
        this.field_70180_af.func_187227_b(SELFE, (Object)state);
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        if (potioneffectIn.func_188419_a() == MobEffects.field_76436_u || potioneffectIn.func_188419_a() == SRPPotions.COTH_E || potioneffectIn.func_188419_a() == SRPPotions.VIRA_E || potioneffectIn.func_188419_a() == SRPPotions.CORRO_E) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    protected boolean func_184228_n(Entity entityIn) {
        if (entityIn instanceof EntityBoat || entityIn instanceof EntityMinecart) {
            return false;
        }
        return super.func_184228_n(entityIn);
    }

    public void setWorkTask(boolean in) {
        this.canWorkTask = in;
    }

    public boolean shouldWorkTask() {
        return this.canWorkTask;
    }

    public void setParasiteToFollow(@Nullable EntityParasiteBase in) {
        this.owner = in;
    }

    public EntityParasiteBase getParasiteFollowing() {
        if (this.owner != null) {
            if (this.owner.func_70089_S()) {
                return this.owner;
            }
            this.setParasiteToFollow(null);
        }
        return null;
    }

    public int getParasiteStatus() {
        return (Integer)this.field_70180_af.func_187225_a(SPECIAL);
    }

    public void setParasiteStatus(int state) {
        this.field_70180_af.func_187227_b(SPECIAL, (Object)state);
    }

    public void setWait(int in) {
        this.waitInt = in;
    }

    public int getWait() {
        return this.waitInt;
    }

    public int getSkin() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN);
    }

    public void setSkin(int texture) {
        this.field_70180_af.func_187227_b(SKIN, (Object)texture);
    }

    public void setAttackCooldownAni(int i) {
        this.attackCooldown = i;
    }

    public int getAttackCooldownAni() {
        return this.attackCooldown;
    }

    public void setKillC(double i) {
        this.killcount = i;
    }

    public double getKillC() {
        return this.killcount;
    }

    public byte getParasiteType() {
        return this.type;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && SRPConfig.rsEnabled) {
            SRPWorldData data = SRPWorldData.get(this.field_70170_p);
            if (SRPConfig.rsPlayer) {
                if (cause.func_76346_g() instanceof EntityPlayer) {
                    if (SRPConfig.useEvolution) {
                        this.spawnBeckonE(data);
                    } else {
                        this.spawnBeckonNE(data, SRPConfig.rschance);
                    }
                }
            } else if (SRPConfig.useEvolution) {
                this.spawnBeckonE(data);
            } else {
                this.spawnBeckonNE(data, SRPConfig.rschance);
            }
        }
    }

    protected void spawnBeckonNE(SRPWorldData data, double chance) {
        long worldT = this.field_70170_p.func_72820_D();
        long seconds = (worldT - SRPAttributes.lastTimeD1) / 20L;
        if (this.field_70146_Z.nextDouble() < chance && data.getCurrentV() < SRPConfig.rsMaxVenkrols && (long)SRPConfig.rsCooldown < Math.abs(seconds) && ParasiteEventEntity.SummonM(this, new String[]{"srparasites:beckon_si;1;1"}, 7, this.func_70638_az())) {
            if (SRPConfig.rsSounds) {
                this.func_184185_a(SRPSounds.VENKROLSI, 4.0f, 1.0f);
            }
            data.setCurrentV(1);
            SRPAttributes.lastTimeD1 = worldT;
        }
    }

    protected void spawnBeckonE(SRPWorldData data) {
        switch (data.getEvolutionPhase()) {
            case 1: {
                this.spawnBeckonNE(data, SRPConfig.reinforcementSystemChanceOne);
                break;
            }
            case 2: {
                this.spawnBeckonNE(data, SRPConfig.reinforcementSystemChanceTwo);
                break;
            }
            case 3: {
                this.spawnBeckonNE(data, SRPConfig.reinforcementSystemChanceThree);
                break;
            }
            case 4: {
                this.spawnBeckonNE(data, SRPConfig.reinforcementSystemChanceFour);
                break;
            }
            case 5: {
                this.spawnBeckonNE(data, SRPConfig.reinforcementSystemChanceFive);
                break;
            }
            case 6: {
                this.spawnBeckonNE(data, SRPConfig.reinforcementSystemChanceSix);
                break;
            }
            case 7: {
                this.spawnBeckonNE(data, SRPConfig.reinforcementSystemChanceSeven);
                break;
            }
            case 8: {
                this.spawnBeckonNE(data, SRPConfig.reinforcementSystemChanceEight);
            }
        }
    }

    protected void func_70609_aI() {
        if (this.canModRender == 1) {
            if (this.madeRng == 0.0) {
                this.setSelfeState(1);
                this.setParasiteStatus(6);
                this.dyingBurst(true, 1);
            } else {
                this.onDeathUpdateOG();
            }
        } else if (this.canModRender == 2) {
            if (this.madeRng == 0.0) {
                this.selfExplode();
                this.OnDeathHelper();
            } else {
                this.onDeathUpdateOG();
            }
        } else {
            this.onDeathUpdateOG();
        }
    }

    private void onDeathUpdateOG() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 20) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            this.func_70106_y();
            if (this.field_70170_p.field_72995_K) {
                for (int k = 0; k < 20; ++k) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 127, 0, 0);
                }
            }
        }
    }

    protected void dyingBurst(boolean fromDeath, int value) {
        int i = this.getSelfeState();
        if (i <= 0 || this.timeSinceIgnited == 0) {
            // empty if block
        }
        this.timeSinceIgnited += i * value;
        if (this.timeSinceIgnited < 0) {
            this.timeSinceIgnited = 0;
        }
        if (this.timeSinceIgnited >= this.fuseTime) {
            this.timeSinceIgnited = this.fuseTime;
            this.selfExplode();
            if (fromDeath) {
                this.OnDeathHelper();
            }
        }
    }

    public void OnDeathHelper() {
        if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
            int j;
            int i = this.func_70693_a(this.field_70717_bb);
            for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
        }
    }

    protected void selfExplode() {
        if (this.field_70170_p.field_72995_K) {
            this.spawnEffects();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.spawnGore();
            this.func_184185_a(SRPSounds.MOBEXPLOTION, 1.0f, 1.0f);
            this.field_70729_aU = true;
            this.func_70106_y();
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entityareaeffectcloud.func_184483_a(this.field_70130_N);
            entityareaeffectcloud.func_184485_d(10);
            entityareaeffectcloud.func_184486_b(entityareaeffectcloud.func_184489_o() / 2);
            entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
            entityareaeffectcloud.func_184496_a(new PotionEffect(MobEffects.field_76436_u, 300, 0));
            entityareaeffectcloud.func_184496_a(new PotionEffect(SRPPotions.COTH_E, 3600, 0, false, false));
            this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
        }
    }

    protected void spawnGore() {
    }

    public boolean func_70601_bi() {
        if (SRPConfig.useEvolution) {
            if (this.phaseCreated >= SRPConfig.evolutionSpawningIgnoreSunlight) {
                IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
                return iblockstate.func_189884_a((Entity)this) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevelTwo() && SRPConfig.spawnDays <= (int)this.field_70170_p.func_72820_D();
            }
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
            return iblockstate.func_189884_a((Entity)this) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevelOne() && SRPConfig.spawnDays <= (int)this.field_70170_p.func_72820_D();
        }
        if (SRPConfig.ignoreL) {
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
            return iblockstate.func_189884_a((Entity)this) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevelTwo() && SRPConfig.spawnDays <= (int)this.field_70170_p.func_72820_D();
        }
        IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        return iblockstate.func_189884_a((Entity)this) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevelOne() && SRPConfig.spawnDays <= (int)this.field_70170_p.func_72820_D();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isValidLightLevelOne() {
        if (this.field_70170_p.func_180494_b(this.func_180425_c()) instanceof BiomeParasite) {
            return this.isValidLightLevelTwo();
        }
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int i = this.field_70170_p.func_175671_l(blockpos);
        if (this.field_70170_p.func_72911_I()) {
            int j = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            i = this.field_70170_p.func_175671_l(blockpos);
            this.field_70170_p.func_175692_b(j);
        }
        if (i > this.field_70146_Z.nextInt(8)) return false;
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (!(this.func_180484_a(blockPos) >= 0.0f)) return false;
        return true;
    }

    protected boolean isValidLightLevelTwo() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        int light = this.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, blockpos);
        if (light > this.field_70146_Z.nextInt(1000) || light > 7) {
            return false;
        }
        return this.field_70146_Z.nextInt(8) == 0;
    }

    private boolean isInParasiteBiome() {
        return this.field_70146_Z.nextInt(8) == 0 && this.field_70170_p.func_180494_b(this.func_180425_c()) instanceof BiomeParasite;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("parasitetype", this.getSkin());
        compound.func_74757_a("parasitedespawn", this.func_70692_ba());
        compound.func_74776_a("parasitekills", (float)this.getKillC());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("parasitetype", 99)) {
            this.setSkin(compound.func_74762_e("parasitetype"));
        }
        if (compound.func_150297_b("parasitedespawn", 99)) {
            this.cannotDespawn(compound.func_74767_n("parasitedespawn"));
        }
        if (compound.func_150297_b("parasitekills", 99)) {
            this.setKillC(compound.func_74760_g("parasitekills"));
        }
    }

    public void particleStatus(int id) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)id);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnEffects() {
        if (this.type == 14) {
            for (int i = 0; i <= 60; ++i) {
                if (i % 5 == 0) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 0, 0, 127);
                }
                if (i % 5 != 0) continue;
                this.spawnParticles(SRPEnumParticle.GSPLASH, 1, -1, -1);
            }
            return;
        }
        if (this.type == 31) {
            for (int i = 0; i <= 60; ++i) {
                if (i % 4 == 0) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 150, 0, 0);
                }
                if (i % 5 != 0) continue;
                this.spawnParticles(SRPEnumParticle.GSPLASH, 2, -1, -1);
            }
            return;
        }
        if (this.type == 41) {
            for (int i = 0; i <= 80; ++i) {
                if (i % 3 == 0) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 200, 200, 0);
                }
                if (i % 5 != 0) continue;
                this.spawnParticles(SRPEnumParticle.GSPLASH, 3, -1, -1);
            }
            return;
        }
        for (int i = 0; i <= 60; ++i) {
            if (i % 5 == 0) {
                this.spawnParticles(SRPEnumParticle.GCLOUD, 127, 0, 0);
            }
            if (i % 5 != 0) continue;
            this.spawnParticles(SRPEnumParticle.GSPLASH, 0, -1, -1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 5: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.RHAPPY, 0, 0, 0);
                }
                break;
            }
            case 6: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 127, 0, 0);
                }
                break;
            }
            case 7: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(EnumParticleTypes.EXPLOSION_LARGE);
                }
                break;
            }
            case 8: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.BIOMASS, 0, 0, 0);
                }
                break;
            }
            case 9: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(EnumParticleTypes.CRIT_MAGIC);
                }
                break;
            }
            case 10: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(EnumParticleTypes.CRIT_MAGIC);
                }
                break;
            }
            case 11: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 0, 0, 0);
                }
                break;
            }
            case 12: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 0, 0, 0);
                }
                break;
            }
            case 13: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.GSPLASH, 4, -1, -1);
                }
                break;
            }
            case 40: {
                this.madeRng = 0.0;
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(EnumParticleTypes particleType) {
        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
        this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(SRPEnumParticle particleType, int r, int g, int b) {
        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
        ParticleSpawner.spawnParticle(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, r, g, b);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(SRPEnumParticle particleType, int r, int g, int b, double d0, double d1, double d2, double d3, double d4, double d5) {
        ParticleSpawner.spawnParticle(particleType, d0, d1, d2, d3, d4, d5, r, g, b);
    }

    @SideOnly(value=Side.CLIENT)
    public float getSelfeFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / (float)(this.fuseTime - 2);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float getscale(float p_70831_1_) {
        return 0.0f;
    }

    public class EntityAIJumping
    extends EntityAIBase {
        private final EntityLiving parent;
        private int secs;

        public EntityAIJumping(EntityLiving parentIn) {
            this.parent = parentIn;
            this.func_75248_a(4);
            if (parentIn.func_70661_as() instanceof PathNavigateGround) {
                ((PathNavigateGround)parentIn.func_70661_as()).func_179693_d(true);
            } else if (parentIn.func_70661_as() instanceof PathNavigateFlying) {
                ((PathNavigateFlying)parentIn.func_70661_as()).func_192877_c(true);
            }
        }

        public boolean func_75250_a() {
            ++this.secs;
            if (this.secs < 10) {
                return false;
            }
            this.secs = 0;
            EntityLivingBase target = this.parent.func_70638_az();
            if (target == null) {
                return false;
            }
            if (target.func_70092_e(this.parent.field_70165_t, target.field_70163_u, this.parent.field_70161_v) < 4.0 && target.field_70163_u - (this.parent.field_70163_u + (double)this.parent.func_70047_e()) > 1.0 && this.parent.field_70122_E) {
                this.parent.func_70661_as().func_75499_g();
                double dd0 = target.field_70165_t - this.parent.field_70165_t;
                double dd1 = target.field_70161_v - this.parent.field_70161_v;
                float f = MathHelper.func_76133_a((double)(dd0 * dd0 + dd1 * dd1));
                this.parent.field_70159_w += dd0 / (double)f * 0.5 * (double)0.8f + this.parent.field_70159_w * (double)0.2f;
                this.parent.field_70179_y += dd1 / (double)f * 0.5 * (double)0.8f + this.parent.field_70179_y * (double)0.2f;
                this.parent.field_70181_x = 0.2 + (double)this.parent.field_70131_O * 0.15;
            }
            return false;
        }

        public void func_75246_d() {
            if (this.parent.func_70681_au().nextFloat() < 0.8f) {
                this.parent.func_70683_ar().func_75660_a();
            }
        }
    }

    class EntityAIWait
    extends EntityAIBase {
        public EntityAIWait() {
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            return EntityParasiteBase.this.getWait() > 0;
        }

        public void func_75246_d() {
        }
    }
}

