/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.entity.monster.primitive;

import com.dhanantry.scapeandrunparasites.entity.SRPAttributes;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIAttackProjectile;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIFlightAttack;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIFlightLimits;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityPPrimitive;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityEmanaAdapted;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityEmana
extends EntityPPrimitive {
    protected static final DataParameter<Byte> VEX_FLAGS = EntityDataManager.func_187226_a(EntityEmana.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityEmana(World worldIn) {
        super(worldIn);
        this.field_70765_h = new AIMoveControl(this);
        this.func_70105_a(0.4f, 1.5f);
        this.func_189654_d(true);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAllMobs);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.folow);
        if (SRPConfig.emanaMaxY != 256) {
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFlightLimits(this, SRPConfig.emanaMaxY, true));
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFlightAttack(this, 20.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackProjectile(this, 80, 2, 20, 1));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(SRPAttributes.EMANA_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(SRPAttributes.EMANA_ARMOR);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(SRPAttributes.EMANA_KD_RESISTANCE);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(SRPConfig.primitiveFollow);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70122_E && !this.field_70170_p.field_72995_K) {
            this.field_70765_h.func_75642_a(this.field_70165_t, this.field_70163_u + 5.0, this.field_70161_v, 0.5);
        }
        if (this.field_70173_aa % 20 == 0 && !this.field_70170_p.field_72995_K && this.killcount > SRPConfig.adaptedKills) {
            ParasiteEventEntity.spawnNext(this, new EntityEmanaAdapted(this.field_70170_p), true, true);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_189654_d(true);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public float func_70047_e() {
        return 0.7f;
    }

    protected SoundEvent func_184639_G() {
        return SRPSounds.EMANA_GROWL;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SRPSounds.EMANA_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SRPSounds.EMANA_DEATH;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        this.func_145775_I();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VEX_FLAGS, (Object)0);
    }

    public static void registerFixesEmana(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityEmana.class);
    }

    private boolean getVexFlag(int mask) {
        byte i = (Byte)this.field_70180_af.func_187225_a(VEX_FLAGS);
        return (i & mask) != 0;
    }

    private void setVexFlag(int mask, boolean value) {
        int i = ((Byte)this.field_70180_af.func_187225_a(VEX_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.field_70180_af.func_187227_b(VEX_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !EntityEmana.this.func_70605_aq().func_75640_a() && EntityEmana.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = new BlockPos((Entity)EntityEmana.this);
            int flag = 1;
            double speed = 0.5;
            if (EntityEmana.this.func_70638_az() != null) {
                if (EntityEmana.this.func_70068_e((Entity)EntityEmana.this.func_70638_az()) > 100.0) {
                    blockpos = new BlockPos((Entity)EntityEmana.this.func_70638_az());
                    flag = 2;
                    speed += 0.25;
                } else if (EntityEmana.this.func_70068_e((Entity)EntityEmana.this.func_70638_az()) < 36.0) {
                    blockpos = new BlockPos((Entity)EntityEmana.this.func_70638_az());
                    flag = 3;
                    speed += 0.25;
                }
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityEmana.this.field_70146_Z.nextInt(15) - 7, EntityEmana.this.field_70146_Z.nextInt(11) - 5, EntityEmana.this.field_70146_Z.nextInt(15) - 7);
                if (flag == 2) {
                    blockpos1 = blockpos.func_177982_a(EntityEmana.this.field_70146_Z.nextInt(6) - 2, EntityEmana.this.field_70146_Z.nextInt(7) - 2, EntityEmana.this.field_70146_Z.nextInt(6) - 2);
                } else if (flag == 3) {
                    blockpos1 = blockpos.func_177982_a(EntityEmana.this.field_70146_Z.nextInt(4) + 3, EntityEmana.this.field_70146_Z.nextInt(5) + 4, EntityEmana.this.field_70146_Z.nextInt(4) + 3);
                }
                if (!EntityEmana.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityEmana.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, speed);
                if (EntityEmana.this.func_70638_az() != null) break;
                EntityEmana.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityEmana vex) {
            super((EntityLiving)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityEmana.this.field_70165_t;
                double d1 = this.field_75647_c - EntityEmana.this.field_70163_u;
                double d2 = this.field_75644_d - EntityEmana.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityEmana.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityEmana.this.field_70159_w *= 0.5;
                    EntityEmana.this.field_70181_x *= 0.5;
                    EntityEmana.this.field_70179_y *= 0.5;
                } else {
                    EntityEmana.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    EntityEmana.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityEmana.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityEmana.this.func_70638_az() == null) {
                        EntityEmana.this.field_70761_aq = EntityEmana.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityEmana.this.field_70159_w, (double)EntityEmana.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityEmana.this.func_70638_az().field_70165_t - EntityEmana.this.field_70165_t;
                        double d5 = EntityEmana.this.func_70638_az().field_70161_v - EntityEmana.this.field_70161_v;
                        EntityEmana.this.field_70761_aq = EntityEmana.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

