/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.common.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ICountWidget;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;

public class DroneEntityAIInventoryImport
extends DroneAIImExBase {
    public DroneEntityAIInventoryImport(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.importItems(pos, true);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        return this.importItems(pos, false) && super.doBlockInteraction(pos, distToBlock);
    }

    private boolean importItems(BlockPos pos, boolean simulate) {
        TileEntity te = this.drone.world().func_175625_s(pos);
        boolean[] sides = ((ISidedWidget)((Object)this.widget)).getSides();
        for (int d = 0; d < sides.length; ++d) {
            IItemHandler inv;
            if (!sides[d] || (inv = IOHelper.getInventoryForTE(te, EnumFacing.func_82600_a((int)d))) == null) continue;
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                if (this.widget.isItemValidForFilters(stack)) {
                    ItemStack importedStack = inv.extractItem(i, stack.func_190916_E(), true);
                    if (importedStack.func_190926_b()) continue;
                    importedStack = importedStack.func_77946_l();
                    if (((ICountWidget)((Object)this.widget)).useCount()) {
                        importedStack.func_190920_e(Math.min(importedStack.func_190916_E(), this.getRemainingCount()));
                    }
                    ItemStack remainder = IOHelper.insert(this.drone, importedStack, EnumFacing.UP, simulate);
                    int removedItems = importedStack.func_190916_E() - remainder.func_190916_E();
                    if (!simulate) {
                        inv.extractItem(i, removedItems, false);
                        this.decreaseCount(removedItems);
                        this.drone.addAir(null, -10);
                        if (!((ICountWidget)((Object)this.widget)).useCount() || this.getRemainingCount() > 0) continue;
                        return false;
                    }
                    if (removedItems > 0) {
                        return true;
                    }
                    this.drone.addDebugEntry("gui.progWidget.inventoryImport.debug.filledToMax", pos);
                    continue;
                }
                this.drone.addDebugEntry("gui.progWidget.inventoryImport.debug.stackdoesntPassFilter", pos);
            }
        }
        return false;
    }
}

