/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.events;

import de.maxhenkel.car.Config;
import de.maxhenkel.car.entity.car.base.EntityVehicleBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PlayerEvents {
    private Minecraft minecraft = Minecraft.func_71410_x();
    private EntityVehicleBase lastVehicle = null;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.side.equals((Object)Side.SERVER)) {
            return;
        }
        if (!evt.player.equals((Object)this.getPlayer())) {
            return;
        }
        EntityVehicleBase vehicle = this.getRidingVehicle();
        if (vehicle != null && this.lastVehicle == null) {
            if (vehicle.doesEnterThirdPerson()) {
                this.setThirdPerson(true);
            }
        } else if (vehicle == null && this.lastVehicle != null && this.lastVehicle.doesEnterThirdPerson()) {
            this.setThirdPerson(false);
        }
        this.lastVehicle = vehicle;
    }

    private void setThirdPerson(boolean third) {
        if (!Config.thirdPersonEnter) {
            return;
        }
        this.minecraft.field_71474_y.field_74320_O = third ? 1 : 0;
    }

    private EntityPlayerSP getPlayer() {
        return this.minecraft.field_71439_g;
    }

    private Entity getRidingEntity() {
        return this.getPlayer().func_184187_bx();
    }

    private EntityVehicleBase getRidingVehicle() {
        Entity e = this.getRidingEntity();
        if (e instanceof EntityVehicleBase) {
            return (EntityVehicleBase)e;
        }
        return null;
    }
}

