/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.IHoverTextWidget;
import com.supermartijn642.core.gui.widget.ITickableWidget;
import com.supermartijn642.core.gui.widget.TextFieldWidget;
import com.supermartijn642.core.gui.widget.Widget;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class BaseScreen
extends GuiScreen {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("supermartijn642corelib", "textures/gui/background.png");
    private final List<Widget> widgets = new LinkedList<Widget>();
    private final List<ITickableWidget> tickableWidgets = new LinkedList<ITickableWidget>();
    protected ITextComponent title;
    protected FontRenderer font;

    protected BaseScreen(ITextComponent title) {
        this.title = title;
    }

    protected abstract float sizeX();

    protected abstract float sizeY();

    protected float left() {
        return ((float)this.field_146294_l - this.sizeX()) / 2.0f;
    }

    protected float top() {
        return ((float)this.field_146295_m - this.sizeY()) / 2.0f;
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        this.font = this.field_146289_q;
    }

    public void func_73866_w_() {
        this.widgets.clear();
        this.tickableWidgets.clear();
        this.addWidgets();
    }

    protected abstract void addWidgets();

    protected <T extends Widget> T addWidget(T widget) {
        this.widgets.add(widget);
        if (widget instanceof ITickableWidget) {
            this.tickableWidgets.add((ITickableWidget)((Object)widget));
        }
        return widget;
    }

    protected <T extends Widget> T removeWidget(T widget) {
        this.widgets.remove(widget);
        if (widget instanceof ITickableWidget) {
            this.tickableWidgets.remove(widget);
        }
        return widget;
    }

    public void func_73876_c() {
        this.tick();
    }

    public void tick() {
        for (Widget widget : this.widgets) {
            if (!(widget instanceof ITickableWidget)) continue;
            ((ITickableWidget)((Object)widget)).tick();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179109_b((float)this.left(), (float)this.top(), (float)0.0f);
        mouseX = (int)((float)mouseX - this.left());
        mouseY = (int)((float)mouseY - this.top());
        GlStateManager.func_179094_E();
        this.render(mouseX, mouseY);
        GlStateManager.func_179121_F();
        for (Widget widget : this.widgets) {
            widget.blitOffset = this.field_73735_i;
            widget.wasHovered = widget.hovered;
            widget.hovered = mouseX > widget.x && mouseX < widget.x + widget.width && mouseY > widget.y && mouseY < widget.y + widget.height;
            widget.render(mouseX, mouseY, partialTicks);
            widget.narrate();
        }
        for (Widget widget : this.widgets) {
            ITextComponent text;
            if (!(widget instanceof IHoverTextWidget) || !widget.isHovered() || (text = ((IHoverTextWidget)((Object)widget)).getHoverText()) == null) continue;
            this.func_146279_a(text.func_150254_d(), mouseX, mouseY);
        }
        this.renderTooltips(mouseX, mouseY);
    }

    protected abstract void render(int var1, int var2);

    protected void renderTooltips(int mouseX, int mouseY) {
    }

    protected void drawScreenBackground(float x, float y, float width, float height) {
        ScreenUtils.drawScreenBackground(x, y, width, height);
    }

    protected void drawScreenBackground() {
        ScreenUtils.drawScreenBackground(0.0f, 0.0f, this.sizeX(), this.sizeY());
    }

    public boolean func_73868_f() {
        return this.isPauseScreen();
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        this.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.onMousePress((int)(mouseX -= (double)this.left()), (int)(mouseY -= (double)this.top()), button);
        for (Widget widget : this.widgets) {
            widget.mouseClicked((int)mouseX, (int)mouseY, button);
        }
        try {
            super.func_73864_a((int)mouseX, (int)mouseY, button);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected void onMousePress(int mouseX, int mouseY, int button) {
    }

    protected void func_146286_b(int mouseX, int mouseY, int button) {
        this.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.onMouseRelease((int)(mouseX -= (double)this.left()), (int)(mouseY -= (double)this.top()), button);
        for (Widget widget : this.widgets) {
            widget.mouseReleased((int)mouseX, (int)mouseY, button);
        }
        super.func_146286_b((int)mouseX, (int)mouseY, button);
        return false;
    }

    protected void onMouseRelease(int mouseX, int mouseY, int button) {
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - (int)this.left();
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1 - (int)this.top();
        int scroll = Mouse.getEventDWheel() / 120;
        if (scroll != 0) {
            this.mouseScrolled(mouseX, mouseY, scroll);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        this.onMouseScroll((int)mouseX, (int)mouseY, delta);
        for (Widget widget : this.widgets) {
            widget.mouseScrolled((int)mouseX, (int)mouseY, delta);
        }
        return false;
    }

    protected void onMouseScroll(int mouseX, int mouseY, double scroll) {
    }

    public void func_146282_l() throws IOException {
        if (Keyboard.getEventKeyState()) {
            if (Keyboard.getEventCharacter() >= ' ') {
                super.func_146282_l();
            }
            if (!this.keyPressed(Keyboard.getEventKey())) {
                super.func_146282_l();
            }
        } else if (!this.keyReleased(Keyboard.getEventKey())) {
            super.func_146282_l();
        }
    }

    public boolean keyPressed(int keyCode) {
        boolean handled = false;
        for (Widget widget : this.widgets) {
            if (widget instanceof TextFieldWidget && ((TextFieldWidget)widget).canWrite()) {
                handled = true;
            }
            widget.keyPressed(keyCode);
        }
        if (handled) {
            return true;
        }
        if (keyCode == 1 || ClientUtils.getMinecraft().field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.closeScreen();
            return true;
        }
        return false;
    }

    public boolean keyReleased(int keyCode) {
        for (Widget widget : this.widgets) {
            widget.keyReleased(keyCode);
        }
        return false;
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        this.charTyped(typedChar);
    }

    public boolean charTyped(char c) {
        for (Widget widget : this.widgets) {
            widget.charTyped(c);
        }
        return false;
    }

    protected void closeScreen() {
        ClientUtils.closeScreen();
    }
}

