/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui.widget;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.ITickableWidget;
import com.supermartijn642.core.gui.widget.Widget;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class TextFieldWidget
extends Widget
implements ITickableWidget {
    private String text;
    private String suggestion = "";
    protected int maxLength;
    private int cursorBlinkCounter;
    protected boolean focused;
    protected int lineScrollOffset;
    protected int cursorPosition;
    protected int selectionPos;
    protected boolean drawBackground = true;
    protected int activeTextColor = 0xE0E0E0;
    protected int inactiveTextColor = 0x707070;
    private final BiConsumer<String, String> changeListener;

    public TextFieldWidget(int x, int y, int width, int height, String defaultText, int maxLength, BiConsumer<String, String> changeListener) {
        super(x, y, width, height);
        this.text = defaultText;
        this.maxLength = maxLength;
        this.changeListener = changeListener;
        this.cursorPosition = this.selectionPos = defaultText.length();
    }

    public TextFieldWidget(int x, int y, int width, int height, String defaultText, int maxLength, Consumer<String> changeListener) {
        this(x, y, width, height, defaultText, maxLength, changeListener == null ? null : (a, b) -> changeListener.accept((String)b));
    }

    public TextFieldWidget(int x, int y, int width, int height, String defaultText, int maxLength) {
        this(x, y, width, height, defaultText, maxLength, (BiConsumer<String, String>)null);
    }

    @Override
    protected ITextComponent getNarrationMessage() {
        return TextComponents.translation("gui.narrate.editBox", this.suggestion, this.text).get();
    }

    @Override
    public void tick() {
        ++this.cursorBlinkCounter;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.drawBackground) {
            this.drawBackground();
        }
        int textColor = this.active ? this.activeTextColor : this.inactiveTextColor;
        int relativeCursor = this.cursorPosition - this.lineScrollOffset;
        int relativeSelection = this.selectionPos - this.lineScrollOffset;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String s = fontRenderer.func_78269_a(this.text.substring(this.lineScrollOffset), this.width - 8);
        boolean cursorInView = relativeCursor >= 0 && relativeCursor <= s.length();
        boolean shouldBlink = this.focused && this.cursorBlinkCounter / 8 % 2 == 0 && cursorInView;
        int left = this.x + 4;
        int top = this.y + (this.height - 8) / 2;
        int leftOffset = left;
        if (relativeSelection > s.length()) {
            relativeSelection = s.length();
        }
        if (!s.isEmpty()) {
            String s1 = cursorInView ? s.substring(0, relativeCursor) : s;
            leftOffset = fontRenderer.func_78276_b(s1, left, top, textColor) + 1;
        }
        boolean cursorAtEnd = this.cursorPosition < this.text.length();
        int cursorX = leftOffset;
        if (!cursorInView) {
            cursorX = relativeCursor > 0 ? left + this.width : left;
        } else if (cursorAtEnd) {
            cursorX = leftOffset - 1;
            --leftOffset;
        }
        if (!s.isEmpty() && cursorInView && relativeCursor < s.length()) {
            fontRenderer.func_78276_b(s.substring(relativeCursor), leftOffset, top, textColor);
        }
        if (!this.suggestion.isEmpty() && this.text.isEmpty()) {
            fontRenderer.func_175063_a(fontRenderer.func_78269_a(this.suggestion, this.width - 8 - fontRenderer.func_78256_a("...")) + "...", (float)cursorX, (float)top, -8355712);
        }
        if (shouldBlink) {
            if (cursorAtEnd) {
                ScreenUtils.fillRect((float)cursorX - 0.5f, top - 1, 1.0f, fontRenderer.field_78288_b, -3092272);
            } else {
                fontRenderer.func_175063_a("_", (float)cursorX, (float)top, textColor);
            }
        }
        if (relativeSelection != relativeCursor) {
            int l1 = left + fontRenderer.func_78256_a(s.substring(0, relativeSelection));
            this.drawSelectionBox(cursorX, top - 1, l1 - 1, top + 1 + fontRenderer.field_78288_b);
        }
    }

    protected void drawBackground() {
        ScreenUtils.fillRect(this.x, this.y, this.width, this.height, this.focused ? -1 : -6250336);
        ScreenUtils.fillRect(this.x + 1, this.y + 1, this.width - 2, this.height - 2, -16777216);
    }

    protected void drawSelectionBox(int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.x + this.width) {
            endX = this.x + this.width;
        }
        if (startX > this.x + this.width) {
            startX = this.x + this.width;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)startX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)startY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)startX, (double)startY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }

    public void clear() {
        this.setText("");
    }

    public void setText(String text) {
        String oldText = this.text;
        this.setTextSuppressed(text);
        if (!oldText.equals(this.text)) {
            this.onTextChanged(oldText, text);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setTextSuppressed(String text) {
        if (text == null) {
            text = "";
        } else if (text.length() > this.maxLength) {
            text = ChatAllowedCharacters.func_71565_a((String)text.substring(0, this.maxLength));
        }
        this.lineScrollOffset = 0;
        this.cursorPosition = 0;
        this.selectionPos = 0;
        this.text = text;
    }

    protected void addTextAtCursor(String text) {
        String oldText = this.text;
        if ((text = ChatAllowedCharacters.func_71565_a((String)text)).length() + this.text.length() - this.getSelectedText().length() > this.maxLength) {
            text = text.substring(0, this.maxLength - this.text.length() + this.getSelectedText().length() + 1);
        }
        int min = Math.min(this.cursorPosition, this.selectionPos);
        int max = Math.max(this.cursorPosition, this.selectionPos);
        this.text = this.text.substring(0, min) + text + this.text.substring(max);
        this.selectionPos = this.cursorPosition = min + text.length();
        this.moveLineOffsetToCursor();
        if (!oldText.equals(this.text)) {
            this.cursorBlinkCounter = 1;
            this.onTextChanged(oldText, this.text);
        }
    }

    protected void removeAtCursor(boolean left) {
        if (this.text.isEmpty()) {
            return;
        }
        String oldText = this.text;
        if (this.cursorPosition != this.selectionPos) {
            this.text = this.text.substring(0, Math.min(this.cursorPosition, this.selectionPos)) + this.text.substring(Math.max(this.cursorPosition, this.selectionPos));
            this.cursorPosition = this.selectionPos = Math.min(this.cursorPosition, this.selectionPos);
        } else if (left && this.cursorPosition > 0) {
            this.text = this.text.substring(0, this.cursorPosition - 1) + this.text.substring(this.cursorPosition);
            --this.cursorPosition;
            --this.selectionPos;
        } else if (!left && this.cursorPosition < this.text.length()) {
            this.text = this.text.substring(0, this.cursorPosition) + this.text.substring(this.cursorPosition + 1);
        }
        this.moveLineOffsetToCursor();
        this.cursorBlinkCounter = 1;
        this.onTextChanged(oldText, this.text);
    }

    protected void moveLineOffsetToCursor() {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int availableWidth = this.width - 8 - (this.cursorPosition == this.text.length() ? fontRenderer.func_78256_a("_") : 0);
        int min = Math.min(this.cursorPosition + 1, this.text.length()) - fontRenderer.func_78269_a(new StringBuilder(this.text.substring(0, Math.min(this.text.length(), this.cursorPosition + 2))).reverse().toString(), availableWidth).length();
        int max = Math.max(this.cursorPosition - 1, 0) + fontRenderer.func_78269_a(this.text.substring(Math.max(this.cursorPosition - 1, 0)), availableWidth).length();
        max -= fontRenderer.func_78269_a(new StringBuilder(this.text.substring(0, max)).reverse().toString(), availableWidth).length();
        this.lineScrollOffset = Math.min(Math.max(this.lineScrollOffset, min), max);
    }

    public String getSelectedText() {
        if (this.cursorPosition == this.selectionPos) {
            return "";
        }
        return this.text.substring(Math.min(this.cursorPosition, this.selectionPos), Math.max(this.cursorPosition, this.selectionPos));
    }

    protected void onTextChanged(String oldText, String newText) {
        if (this.changeListener != null) {
            this.changeListener.accept(oldText, newText);
        }
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion == null ? "" : suggestion;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public void setTextColors(int activeTextColor, int inactiveTextColor) {
        this.activeTextColor = activeTextColor;
        this.inactiveTextColor = inactiveTextColor;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    @Override
    public void keyPressed(int keyCode) {
        if (!this.canWrite()) {
            return;
        }
        boolean shift = GuiScreen.func_146272_n();
        if (keyCode == 1) {
            this.setFocused(false);
        } else if (GuiScreen.func_175278_g((int)keyCode)) {
            this.lineScrollOffset = 0;
            this.cursorPosition = this.text.length();
            this.selectionPos = 0;
        } else if (GuiScreen.func_175280_f((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
        } else if (GuiScreen.func_175279_e((int)keyCode)) {
            this.addTextAtCursor(GuiScreen.func_146277_j());
        } else if (GuiScreen.func_175277_d((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            this.addTextAtCursor("");
        } else {
            switch (keyCode) {
                case 14: {
                    this.removeAtCursor(true);
                    break;
                }
                default: {
                    break;
                }
                case 211: {
                    this.removeAtCursor(false);
                    break;
                }
                case 205: {
                    if (!shift && this.cursorPosition != this.selectionPos) {
                        this.cursorPosition = this.selectionPos = Math.max(this.cursorPosition, this.selectionPos);
                    } else if (this.cursorPosition < this.text.length()) {
                        ++this.cursorPosition;
                        if (!shift) {
                            this.selectionPos = this.cursorPosition;
                        }
                    }
                    this.moveLineOffsetToCursor();
                    break;
                }
                case 203: {
                    if (!shift && this.cursorPosition != this.selectionPos) {
                        this.cursorPosition = this.selectionPos = Math.min(this.cursorPosition, this.selectionPos);
                    } else if (this.cursorPosition > 0) {
                        --this.cursorPosition;
                        if (!shift) {
                            this.selectionPos = this.cursorPosition;
                        }
                    }
                    this.moveLineOffsetToCursor();
                    break;
                }
                case 199: {
                    this.selectionPos = 0;
                    this.cursorPosition = 0;
                    this.moveLineOffsetToCursor();
                    break;
                }
                case 207: {
                    this.cursorPosition = this.selectionPos = this.text.length();
                    this.moveLineOffsetToCursor();
                }
            }
        }
    }

    @Override
    public void charTyped(char c) {
        if (!this.canWrite()) {
            return;
        }
        if (ChatAllowedCharacters.func_71566_a((char)c)) {
            this.addTextAtCursor(Character.toString(c));
        }
    }

    public boolean canWrite() {
        return this.active && this.focused;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button) {
        boolean bl = this.focused = this.active && mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
        if (this.focused) {
            if (button == 1) {
                this.clear();
            } else {
                int offset = MathHelper.func_76141_d((float)mouseX) - this.x - 4;
                FontRenderer font = Minecraft.func_71410_x().field_71466_p;
                String s = font.func_78269_a(this.text.substring(this.lineScrollOffset), Math.min(offset, this.width - 8));
                this.cursorPosition = s.length() + this.lineScrollOffset;
                if (!GuiScreen.func_146272_n()) {
                    this.selectionPos = this.cursorPosition;
                }
            }
        }
    }
}

