/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.network;

import com.supermartijn642.core.CoreSide;
import com.supermartijn642.core.network.BlockPosBasePacket;
import com.supermartijn642.core.network.PacketContext;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;

public abstract class TileEntityBasePacket<T extends TileEntity>
extends BlockPosBasePacket {
    public DimensionType dimension;

    public TileEntityBasePacket() {
    }

    public TileEntityBasePacket(DimensionType dimension, BlockPos pos) {
        super(pos);
        this.dimension = dimension;
    }

    public TileEntityBasePacket(World world, BlockPos pos) {
        this(world == null ? null : world.field_73011_w.func_186058_p(), pos);
    }

    public TileEntityBasePacket(BlockPos pos) {
        this((DimensionType)null, pos);
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.dimension != null);
        if (this.dimension != null) {
            buffer.writeInt(this.dimension.func_186068_a());
        }
    }

    @Override
    public void read(PacketBuffer buffer) {
        super.read(buffer);
        if (buffer.readBoolean()) {
            this.dimension = DimensionType.func_186069_a((int)buffer.readInt());
        }
    }

    @Override
    protected void handle(BlockPos pos, PacketContext context) {
        T tile = this.getTileEntity(context);
        if (tile != null) {
            this.handle(tile, context);
        }
    }

    protected abstract void handle(T var1, PacketContext var2);

    private T getTileEntity(PacketContext context) {
        World world;
        Object object = this.dimension == null ? context.getWorld() : (context.getHandlingSide() == CoreSide.CLIENT ? (context.getWorld().field_73011_w.func_186058_p() == this.dimension ? context.getWorld() : null) : (world = context.getWorld().func_73046_m().func_71218_a(this.dimension.func_186068_a())));
        if (world == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile == null) {
            return null;
        }
        try {
            return (T)tile;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }
}

