/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.block.BlockShape;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    public static boolean depthTest = true;

    public static void enableDepthTest() {
        depthTest = true;
    }

    public static void disableDepthTest() {
        depthTest = false;
    }

    public static void resetState() {
        depthTest = true;
    }

    public static Vec3d getCameraPosition() {
        RenderManager renderManager = ClientUtils.getMinecraft().func_175598_ae();
        return new Vec3d(renderManager.field_78730_l, renderManager.field_78731_m, renderManager.field_78728_n);
    }

    public static void renderShape(BlockShape shape, float red, float green, float blue, float alpha) {
        boolean depthTest = GL11.glIsEnabled((int)2929);
        boolean texture = GL11.glIsEnabled((int)3553);
        boolean lighting = GL11.glIsEnabled((int)2896);
        boolean blend = GL11.glIsEnabled((int)3042);
        boolean cull = GL11.glIsEnabled((int)2884);
        if (RenderUtils.depthTest) {
            GlStateManager.func_179126_j();
        } else {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179129_p();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        shape.forEachEdge((x1, y1, z1, x2, y2, z2) -> {
            buffer.func_181662_b(x1, y1, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x2, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        });
        tessellator.func_78381_a();
        if (depthTest) {
            GlStateManager.func_179126_j();
        } else {
            GlStateManager.func_179097_i();
        }
        if (texture) {
            GlStateManager.func_179098_w();
        }
        if (lighting) {
            GlStateManager.func_179145_e();
        }
        if (!blend) {
            GlStateManager.func_179084_k();
        }
        if (cull) {
            GlStateManager.func_179089_o();
        }
    }

    public static void renderShapeSides(BlockShape shape, float red, float green, float blue, float alpha) {
        boolean depthTest = GL11.glIsEnabled((int)2929);
        boolean texture = GL11.glIsEnabled((int)3553);
        boolean lighting = GL11.glIsEnabled((int)2896);
        boolean blend = GL11.glIsEnabled((int)3042);
        boolean cull = GL11.glIsEnabled((int)2884);
        if (RenderUtils.depthTest) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179132_a((boolean)false);
        } else {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179129_p();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        shape.forEachBox(box -> {
            float minX = (float)box.field_72340_a;
            float maxX = (float)box.field_72336_d;
            float minY = (float)box.field_72338_b;
            float maxY = (float)box.field_72337_e;
            float minZ = (float)box.field_72339_c;
            float maxZ = (float)box.field_72334_f;
            builder.func_181662_b((double)minX, (double)minY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)maxY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)maxY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)minY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)minY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)minY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)maxY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)maxY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)minY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)minY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)minY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)minY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)maxY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)maxY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)maxY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)maxY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)minY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)minY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)maxY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)maxY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)minY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)maxY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)maxY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)minY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        });
        tessellator.func_78381_a();
        if (depthTest) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
        } else {
            GlStateManager.func_179097_i();
        }
        if (texture) {
            GlStateManager.func_179098_w();
        }
        if (lighting) {
            GlStateManager.func_179145_e();
        }
        if (!blend) {
            GlStateManager.func_179084_k();
        }
        if (cull) {
            GlStateManager.func_179089_o();
        }
    }

    public static void renderBox(AxisAlignedBB box, float red, float green, float blue, float alpha) {
        RenderUtils.renderShape(BlockShape.create(box), red, green, blue, alpha);
    }

    public static void renderBoxSides(AxisAlignedBB box, float red, float green, float blue, float alpha) {
        RenderUtils.renderShapeSides(BlockShape.create(box), red, green, blue, alpha);
    }

    public static void renderShape(BlockShape shape, float red, float green, float blue) {
        RenderUtils.renderShape(shape, red, green, blue, 1.0f);
    }

    public static void renderShapeSides(BlockShape shape, float red, float green, float blue) {
        RenderUtils.renderShapeSides(shape, red, green, blue, 1.0f);
    }

    public static void renderBox(AxisAlignedBB box, float red, float green, float blue) {
        RenderUtils.renderShape(BlockShape.create(box), red, green, blue, 1.0f);
    }

    public static void renderBoxSides(AxisAlignedBB box, float red, float green, float blue) {
        RenderUtils.renderShapeSides(BlockShape.create(box), red, green, blue, 1.0f);
    }
}

