/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.energymeters.client;

import com.vladmarica.energymeters.tile.TileEntityEnergyMeterBase;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

public class EnergyMeterScreenRenderer
extends TileEntitySpecialRenderer<TileEntityEnergyMeterBase> {
    private static final float PIXEL_WIDTH = 0.0625f;
    private static float[] FACE_TO_ANGLE = new float[]{0.0f, 0.0f, 180.0f, 0.0f, -90.0f, 90.0f};
    private static final int SCREEN_SIZE = 50;
    private static boolean DRAW_DEBUG_SQUARE = false;
    private static final int WHITE = 0xFFFFFF;
    private static final String DISABLED_TEXT = TextFormatting.RED + "DISABLED";
    private static int disabledTextWidth = -1;

    public void render(TileEntityEnergyMeterBase tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        super.func_192841_a((TileEntity)tile, x, y, z, partialTicks, destroyStage, alpha);
        if (!tile.isFullyConnected()) {
            return;
        }
        if (disabledTextWidth == -1) {
            disabledTextWidth = this.func_147498_b().func_78256_a(DISABLED_TEXT);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.0), (double)(z + 0.5));
        GlStateManager.func_179114_b((float)FACE_TO_ANGLE[tile.getScreenSide().func_176745_a()], (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)0.501);
        GlStateManager.func_179109_b((float)0.125f, (float)-0.125f, (float)0.0f);
        GlStateManager.func_187432_a((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.015f, (float)-0.015f, (float)0.015f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179126_j();
        this.func_190053_a(true);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        FontRenderer fontRenderer = this.func_147498_b();
        GL11.glColor4f((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
        if (DRAW_DEBUG_SQUARE) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181666_a(0.5f, 0.0f, 0.0f, 0.75f).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 50.0, 0.0).func_181666_a(0.5f, 0.0f, 0.0f, 0.75f).func_181675_d();
            bufferbuilder.func_181662_b(50.0, 50.0, 0.0).func_181666_a(0.5f, 0.0f, 0.0f, 0.75f).func_181675_d();
            bufferbuilder.func_181662_b(50.0, 0.0, 0.0).func_181666_a(0.5f, 0.0f, 0.0f, 0.75f).func_181675_d();
            tessellator.func_78381_a();
        }
        if (tile.isDisabled()) {
            fontRenderer.func_78276_b(DISABLED_TEXT, (50 - disabledTextWidth) / 2, 20, 0xFFFFFF);
        } else {
            String displayText = EnergyMeterScreenRenderer.formatRate(tile.getTransferRate() / (float)tile.getEnergyScale());
            int displayTextWidth = fontRenderer.func_78256_a(displayText);
            fontRenderer.func_78276_b(TextFormatting.WHITE + displayText, (50 - displayTextWidth) / 2, 15, 0xFFFFFF);
            fontRenderer.func_78276_b(TextFormatting.WHITE + tile.getEnergyAlias().getDisplayName() + "/t", 14, 25, 0xFFFFFF);
        }
        this.func_190053_a(false);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private static String formatRate(float rate) {
        if (rate < 1000.0f) {
            return String.format("%.1f", Float.valueOf(rate));
        }
        int exp = (int)(Math.log(rate) / Math.log(1000.0));
        return String.format("%.1f%c", (double)rate / Math.pow(1000.0, exp), Character.valueOf("KMBTQ".charAt(exp - 1)));
    }
}

