/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.abstracts;

import cassiokf.industrialrenewal.blocks.BlockBase;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.init.IRSoundRegister;
import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockBasicElectricFence
extends BlockBase {
    public BlockBasicElectricFence(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(5.0f);
        this.func_149752_b(25.0f);
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!(entityIn instanceof EntityLivingBase)) {
            return;
        }
        int mode = IRConfig.MainConfig.Main.electricFenceMode;
        float damage = (float)IRConfig.MainConfig.Main.electricFenceDamageAmount;
        if (mode == 4) {
            return;
        }
        if (mode == 0 && (entityIn instanceof EntityMob || entityIn instanceof EntityPlayer)) {
            float damageR = entityIn instanceof EntityPlayer ? 0.0f : damage;
            this.DoDamage(worldIn, pos, entityIn, damageR);
        } else if (mode == 1 && (entityIn instanceof EntityMob || entityIn instanceof EntityPlayer)) {
            this.DoDamage(worldIn, pos, entityIn, damage);
        } else if (mode == 2) {
            this.DoDamage(worldIn, pos, entityIn, 0.0f);
        } else if (mode == 3) {
            this.DoDamage(worldIn, pos, entityIn, damage);
        }
    }

    private void DoDamage(World world, BlockPos pos, Entity entityIn, float amount) {
        entityIn.func_70097_a(DamageSource.field_180137_b, amount);
        float knockback = (float)IRConfig.MainConfig.Main.electricFenceKnockBack;
        if (knockback > 0.0f) {
            ((EntityLivingBase)entityIn).func_70653_a(entityIn, knockback, (double)pos.func_177958_n() - entityIn.field_70165_t, (double)pos.func_177952_p() - entityIn.field_70161_v);
        }
        Random r = new Random();
        float pitch = r.nextFloat() * 0.20000005f + 0.9f;
        world.func_184133_a(null, pos, IRSoundRegister.EFFECT_SHOCK, SoundCategory.BLOCKS, 0.6f * IRConfig.MainConfig.Sounds.masterVolumeMult, pitch);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

