## Magnetic Card Reader

![](https://i.imgur.com/cVOiDlQ.png)

Reads [Magnetic Cards](MagneticCard) when right clicked.

### Methods
```lua
-- Sets the event name returned when you click it with a card, default is magData
setEventName(string eventName) 
```

This block queues signals when it is clicked with a [Magnetic Cards](MagneticCard).

The event parameters are 
```lua
eventName    -- defaults to magData, can be changed
address      -- address of the magnetic card reader
playerName   -- name of the player that used the card
cardData     -- data stored on the card
cardUniqueId -- unique card id
isCardLocked -- writelock state of card
side         -- block side of card reader which the player used the card on
```

### example script
```lua
event = require("event")

function myFunction(eventName, address, playerName, cardData, cardUniqueId, isCardLocked, side)
   print("player " .. playerName .. " used card " .. cardUniqueId .. ", data: " .. cardData)
end

-- subscribe to the event "magData" with myFunction()
event.listen("magData", myFunction)

-- wait for an interrupt before closing the script (CTRL + C)
event.pull("interrupted")

-- unsubscribe from the event bus
event.ignore("magData", myFunction)
```