/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.wireless;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.logic.wireless.RedstoneChannelTileEntity;
import mcjty.rftools.blocks.logic.wireless.RedstoneChannels;
import mcjty.rftools.items.screenmodules.ButtonModuleItem;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class RedstoneChannelBlock<T extends RedstoneChannelTileEntity, C extends Container>
extends LogicSlabBlock<T, C> {
    public RedstoneChannelBlock(Material material, Class<? extends T> tileEntityClass, BiFunction<EntityPlayer, IInventory, C> containerFactory, Function<Block, ItemBlock> itemBlockFactory, String name) {
        super((ModBase)RFTools.instance, material, tileEntityClass, containerFactory, itemBlockFactory, name, false);
        this.func_149647_a(RFTools.setup.getTab());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            int channel = tagCompound.func_74762_e("channel");
            list.add(TextFormatting.GREEN + "Channel: " + channel);
        }
    }

    private boolean isRedstoneChannelItem(Item item) {
        return item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof RedstoneChannelBlock || item instanceof ButtonModuleItem;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        ItemStack stack = player.func_184586_b(hand);
        if (this.isRedstoneChannelItem(stack.func_77973_b()) && (te = world.func_175625_s(pos)) instanceof RedstoneChannelTileEntity) {
            if (!world.field_72995_K) {
                int channel;
                RedstoneChannelTileEntity rcte = (RedstoneChannelTileEntity)te;
                NBTTagCompound tagCompound = stack.func_77978_p();
                if (tagCompound == null) {
                    tagCompound = new NBTTagCompound();
                    stack.func_77982_d(tagCompound);
                }
                if (!player.func_70093_af()) {
                    channel = rcte.getChannel(true);
                    tagCompound.func_74768_a("channel", channel);
                } else {
                    channel = tagCompound.func_74764_b("channel") ? tagCompound.func_74762_e("channel") : -1;
                    if (channel == -1) {
                        RedstoneChannels redstoneChannels = RedstoneChannels.getChannels(world);
                        channel = redstoneChannels.newChannel();
                        redstoneChannels.save();
                        tagCompound.func_74768_a("channel", channel);
                    }
                    rcte.setChannel(channel);
                }
                Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Channel set to " + channel + "!"));
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }
}

