/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.orecruncher.lib.LibLog;

public final class JsonUtils {
    private JsonUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T loadFromJar(@Nonnull Class<T> clazz, @Nonnull String path) throws Exception {
        try (InputStream stream = clazz.getResourceAsStream(path);){
            T throwable3 = JsonUtils.load(stream, clazz);
            return throwable3;
        }
        catch (Throwable t2) {
            String msg = String.format("Unable to load resource [%s] from JAR", path);
            LibLog.log().error(msg, t2);
            return clazz.newInstance();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T load(@Nonnull InputStream stream, @Nonnull Class<T> clazz) throws Exception {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            Object object = new Gson().fromJson((Reader)reader, clazz);
            return (T)object;
        }
        catch (Throwable t) {
            LibLog.log().error("Unable to process Json from stream", t);
            return clazz.newInstance();
        }
    }

    public static class JsonValidationFailed
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public JsonValidationFailed(@Nonnull String cause, @Nonnull Throwable t) {
            super(cause, t);
        }
    }
}

