/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.random.XorShiftRandom;

public class WeightTable<T>
extends ObjectArray<IItem<? extends T>> {
    protected static final Random RANDOM = XorShiftRandom.current();
    protected int totalWeight = 0;

    public WeightTable() {
    }

    @SafeVarargs
    public WeightTable(IEntrySource<? extends T> ... src) {
        super(src.length);
        for (int i = 0; i < src.length; ++i) {
            if (!src[i].matches()) continue;
            this.add(src[i].getEntry());
        }
    }

    public boolean add(final @Nonnull T e, final int weight) {
        return this.add(new IItem<T>(){

            @Override
            public int getWeight() {
                return weight;
            }

            @Override
            public T getItem() {
                return e;
            }
        });
    }

    @Override
    public boolean add(@Nonnull IItem<? extends T> entry) {
        this.totalWeight += entry.getWeight();
        return super.add(entry);
    }

    @Nullable
    public T next() {
        if (this.totalWeight <= 0) {
            return null;
        }
        int targetWeight = RANDOM.nextInt(this.totalWeight);
        IItem selected = null;
        int i = -1;
        while ((targetWeight -= (selected = (IItem)this.data[++i]).getWeight()) >= 0) {
        }
        return selected.getItem();
    }

    public static interface IEntrySource<T> {
        public IItem<T> getEntry();

        public boolean matches();
    }

    public static interface IItem<T> {
        public int getWeight();

        public T getItem();
    }
}

