/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.DataSerializerEntry;

public class Owner {
    @GameRegistry.ObjectHolder(value="securitycraft:owner")
    public static final DataSerializerEntry SERIALIZER = null;
    private String ownerName = "owner";
    private String ownerUUID = "ownerUUID";
    private boolean validated = true;

    public Owner() {
    }

    public Owner(String playerName, String playerUUID) {
        this.ownerName = playerName;
        this.ownerUUID = playerUUID;
    }

    public Owner(String playerName, String playerUUID, boolean validated) {
        this.ownerName = playerName;
        this.ownerUUID = playerUUID;
        this.validated = validated;
    }

    public static Owner fromCompound(NBTTagCompound tag) {
        Owner owner = new Owner();
        if (tag != null) {
            owner.readFromNBT(tag);
        }
        return owner;
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("owner")) {
            this.ownerName = tag.func_74779_i("owner");
        }
        if (tag.func_74764_b("ownerUUID")) {
            this.ownerUUID = tag.func_74779_i("ownerUUID");
        }
        if (tag.func_74764_b("ownerValidated")) {
            this.validated = tag.func_74767_n("ownerValidated");
        }
    }

    public void writeToNBT(NBTTagCompound tag, boolean saveValidationStatus) {
        tag.func_74778_a("owner", this.ownerName);
        tag.func_74778_a("ownerUUID", this.ownerUUID);
        if (saveValidationStatus) {
            tag.func_74757_a("ownerValidated", this.validated);
        }
    }

    public boolean owns(IOwnable ... ownables) {
        for (IOwnable ownable : ownables) {
            if (ownable == null) continue;
            String uuidToCheck = ownable.getOwner().getUUID();
            String nameToCheck = ownable.getOwner().getName();
            if (ConfigHandler.enableTeamOwnership && !PlayerUtils.areOnSameTeam(this.ownerName, nameToCheck)) {
                return false;
            }
            if (uuidToCheck != null && !uuidToCheck.equals(this.ownerUUID)) {
                return false;
            }
            if (nameToCheck == null || !uuidToCheck.equals("ownerUUID") || nameToCheck.equals("owner") || nameToCheck.equals(this.ownerName)) continue;
            return false;
        }
        return true;
    }

    public boolean isOwner(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        String uuidToCheck = player.func_146103_bH().getId().toString();
        String nameToCheck = player.func_70005_c_();
        if (ConfigHandler.enableTeamOwnership && PlayerUtils.areOnSameTeam(this.ownerName, nameToCheck)) {
            return true;
        }
        if (uuidToCheck != null && uuidToCheck.equals(this.ownerUUID)) {
            return true;
        }
        return nameToCheck != null && this.ownerUUID.equals("ownerUUID") && nameToCheck.equals(this.ownerName);
    }

    public void set(String uuid, String name) {
        this.ownerName = name;
        this.ownerUUID = uuid;
    }

    public void setOwnerName(String name) {
        this.ownerName = name;
    }

    public void setOwnerUUID(String uuid) {
        this.ownerUUID = uuid;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public String getName() {
        return this.ownerName;
    }

    public String getUUID() {
        return this.ownerUUID;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public String toString() {
        return "Name: " + this.ownerName + "  UUID: " + this.ownerUUID;
    }

    @Deprecated
    public boolean equals(Object obj) {
        return obj instanceof Owner && this.getName().equals(((Owner)obj).getName()) && this.getUUID().equals(((Owner)obj).getUUID());
    }

    public static DataSerializer<Owner> getSerializer() {
        return SERIALIZER.getSerializer();
    }
}

