/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntityAllowlistOnly;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockReinforcedButton
extends BlockButton
implements IReinforcedBlock {
    private final boolean isWooden;

    public BlockReinforcedButton(boolean isWooden) {
        super(isWooden);
        if (isWooden) {
            this.func_149672_a(SoundType.field_185848_a);
        }
        this.isWooden = isWooden;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.isAllowedToPress(world, pos, (TileEntityAllowlistOnly)world.func_175625_s(pos), player)) {
            return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
        }
        return false;
    }

    public boolean isAllowedToPress(World world, BlockPos pos, TileEntityAllowlistOnly te, EntityPlayer entity) {
        return te.getOwner().isOwner(entity) || ModuleUtils.isAllowed((IModuleInventory)te, (Entity)entity);
    }

    protected void func_185615_a(EntityPlayer player, World world, BlockPos pos) {
        world.func_184133_a(player, pos, this.isWooden ? SoundEvents.field_187885_gS : SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.3f, 0.6f);
    }

    protected void func_185617_b(World world, BlockPos pos) {
        world.func_184133_a(null, pos, this.isWooden ? SoundEvents.field_187883_gR : SoundEvents.field_187837_fU, SoundCategory.BLOCKS, 0.3f, 0.5f);
    }

    public Material func_149688_o(IBlockState state) {
        return this.isWooden ? Material.field_151575_d : Material.field_151576_e;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.IGNORE;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityAllowlistOnly();
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public List<Block> getVanillaBlocks() {
        return Arrays.asList(this.isWooden ? Blocks.field_150471_bO : Blocks.field_150430_aB);
    }
}

