/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.IViewActivated;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.gui.components.HoverChecker;
import net.geforcemods.securitycraft.gui.components.PatronScrollList;
import net.geforcemods.securitycraft.gui.components.StackHoverChecker;
import net.geforcemods.securitycraft.gui.components.StringHoverChecker;
import net.geforcemods.securitycraft.items.ItemSCManual;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.geforcemods.securitycraft.util.GuiUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiSCManual
extends GuiScreen {
    private ResourceLocation infoBookTexture = new ResourceLocation("securitycraft:textures/gui/info_book_texture.png");
    private ResourceLocation infoBookTextureSpecial = new ResourceLocation("securitycraft:textures/gui/info_book_texture_special.png");
    private ResourceLocation infoBookTitlePage = new ResourceLocation("securitycraft:textures/gui/info_book_title_page.png");
    private ResourceLocation infoBookIcons = new ResourceLocation("securitycraft:textures/gui/info_book_icons.png");
    private static ResourceLocation bookGuiTextures = new ResourceLocation("textures/gui/book.png");
    private List<HoverChecker> hoverCheckers = new ArrayList<HoverChecker>();
    private static int lastPage = -1;
    private int currentPage = lastPage;
    private NonNullList<Ingredient> recipe;
    private int startX = -1;
    private List<String> subpages = new ArrayList<String>();
    private List<String> author = new ArrayList<String>();
    private int currentSubpage = 0;
    private final int subpageLength = 1285;
    private final String intro1 = Utils.localize("gui.securitycraft:scManual.intro.1", new Object[0]).func_150255_a(new Style().func_150228_d(Boolean.valueOf(true))).func_150254_d();
    private final String ourPatrons = Utils.localize("gui.securitycraft:scManual.patreon.title", new Object[0]).func_150254_d();
    private List<String> intro2;
    private PatronList patronList;
    private GuiButton patreonLinkButton;
    private boolean explosive;
    private boolean ownable;
    private boolean passwordProtected;
    private boolean viewActivated;
    private boolean customizable;
    private boolean lockable;
    private boolean moduleInventory;
    private ItemStack pageStack;

    public void func_73866_w_() {
        int startY = 2;
        this.startX = (this.field_146294_l - 256) / 2;
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.add(new ChangePageButton(1, this.startX + 210, startY + 188, true));
        this.field_146292_n.add(new ChangePageButton(2, this.startX + 16, startY + 188, false));
        this.field_146292_n.add(new ChangePageButton(3, this.startX + 180, startY + 97, true));
        this.field_146292_n.add(new ChangePageButton(4, this.startX + 155, startY + 97, false));
        this.patreonLinkButton = new HyperlinkButton(5, this.startX + 225, 143, 16, 16, "");
        this.field_146292_n.add(this.patreonLinkButton);
        this.patronList = new PatronList(this.field_146297_k, 115, 90, 50, this.startX + 125, this.field_146294_l, this.field_146295_m);
        this.updateRecipeAndIcons();
        ItemSCManual.PAGES.sort((page1, page2) -> {
            String key1 = Utils.localize(page1.getItem().func_77658_a() + ".name", new Object[0]).func_150254_d();
            String key2 = Utils.localize(page2.getItem().func_77658_a() + ".name", new Object[0]).func_150254_d();
            return key1.compareTo(key2);
        });
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.currentPage == -1) {
            this.field_146297_k.func_110434_K().func_110577_a(this.infoBookTitlePage);
        } else if (this.recipe != null || ItemSCManual.PAGES.get(this.currentPage).isRecipeDisabled()) {
            this.field_146297_k.func_110434_K().func_110577_a(this.infoBookTexture);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(this.infoBookTextureSpecial);
        }
        this.func_73729_b(this.startX, 5, 0, 0, 256, 250);
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            ((GuiButton)this.field_146292_n.get(i)).func_191745_a(this.field_146297_k, mouseX, mouseY, 0.0f);
        }
        if (this.currentPage > -1) {
            String pageNumberText = this.currentPage + 2 + "/" + (ItemSCManual.PAGES.size() + 1);
            String designedBy = ItemSCManual.PAGES.get(this.currentPage).getDesignedBy();
            if (this.subpages.size() > 1) {
                this.field_146289_q.func_78276_b(this.currentSubpage + 1 + "/" + this.subpages.size(), this.startX + 205, 102, 9339504);
            }
            if (ItemSCManual.PAGES.get(this.currentPage).getHelpInfo().equals("help.securitycraft:reinforced.info")) {
                this.field_146289_q.func_175065_a(Utils.localize("gui.securitycraft:scManual.reinforced", new Object[0]).func_150254_d(), (float)(this.startX + 39), 27.0f, 0, false);
            } else {
                this.field_146289_q.func_175065_a(Utils.localize(ItemSCManual.PAGES.get(this.currentPage).getItem().func_77658_a() + ".name", new Object[0]).func_150254_d(), (float)(this.startX + 39), 27.0f, 0, false);
            }
            if (designedBy != null && !designedBy.isEmpty()) {
                this.field_146289_q.func_78279_b(Utils.localize("gui.securitycraft:scManual.designedBy", designedBy).func_150254_d(), this.startX + 18, 150, 75, 0);
            }
            this.field_146289_q.func_78276_b(pageNumberText, this.startX + 240 - this.field_146289_q.func_78256_a(pageNumberText), 182, 9339504);
            GuiUtils.drawItemStackToGui(this.pageStack, this.startX + 19, 22, !(this.pageStack.func_77973_b() instanceof ItemBlock));
            this.field_146289_q.func_78279_b(this.subpages.get(this.currentSubpage), this.startX + 18, 45, 225, 0);
            this.field_146297_k.func_110434_K().func_110577_a(this.infoBookIcons);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.explosive) {
                this.func_73729_b(this.startX + 107, 117, 54, 1, 18, 18);
            }
            if (this.ownable) {
                this.func_73729_b(this.startX + 29, 118, 1, 1, 16, 16);
            }
            if (this.passwordProtected) {
                this.func_73729_b(this.startX + 55, 118, 18, 1, 17, 16);
            }
            if (this.viewActivated) {
                this.func_73729_b(this.startX + 81, 118, 36, 1, 17, 16);
            }
            if (this.customizable) {
                this.func_73729_b(this.startX + 136, 118, 88, 1, 16, 16);
            }
            if (this.moduleInventory) {
                this.func_73729_b(this.startX + 163, 118, 105, 1, 16, 16);
            }
            if (this.lockable) {
                this.func_73729_b(this.startX + 189, 118, 154, 1, 16, 16);
            }
            if (this.customizable || this.moduleInventory) {
                this.func_73729_b(this.startX + 213, 118, 72, 1, 16, 16);
            }
            if (this.recipe != null) {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3 && i * 3 + j < this.recipe.size(); ++j) {
                        ItemStack[] matchingStacks = ((Ingredient)this.recipe.get(i * 3 + j)).func_193365_a();
                        if (matchingStacks.length == 0 || matchingStacks[0].func_190926_b()) continue;
                        GuiUtils.drawItemStackToGui(matchingStacks[0], this.startX + 101 + j * 19, 144 + i * 19, !(matchingStacks[0].func_77973_b() instanceof ItemBlock));
                    }
                }
            }
            for (HoverChecker chc : this.hoverCheckers) {
                if (chc == null || !chc.checkHover(mouseX, mouseY)) continue;
                if (chc instanceof StackHoverChecker && !((StackHoverChecker)chc).getStack().func_190926_b()) {
                    this.func_146285_a(((StackHoverChecker)chc).getStack(), mouseX, mouseY);
                    continue;
                }
                if (!(chc instanceof StringHoverChecker) || ((StringHoverChecker)chc).getName() == null) continue;
                this.func_146283_a(((StringHoverChecker)chc).getLines(), mouseX, mouseY);
            }
        } else {
            String text;
            int i;
            String pageNumberText = "1/" + (ItemSCManual.PAGES.size() + 1);
            this.field_146289_q.func_175065_a(this.intro1, (float)(this.field_146294_l / 2 - this.field_146289_q.func_78256_a(this.intro1) / 2), 22.0f, 0, false);
            for (i = 0; i < this.intro2.size(); ++i) {
                text = this.intro2.get(i);
                this.field_146289_q.func_78276_b(text, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(text) / 2, 150 + 10 * i, 0);
            }
            for (i = 0; i < this.author.size(); ++i) {
                text = this.author.get(i);
                this.field_146289_q.func_78276_b(text, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(text) / 2, 180 + 10 * i, 0);
            }
            if (this.patronList != null) {
                this.patronList.drawScreen(mouseX, mouseY, partialTicks);
            }
            this.field_146289_q.func_78276_b(pageNumberText, this.startX + 240 - this.field_146289_q.func_78256_a(pageNumberText), 182, 9339504);
            this.field_146289_q.func_78276_b(this.ourPatrons, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(this.ourPatrons) / 2 + 30, 40, 0);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        lastPage = this.currentPage;
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (keyCode == 203) {
            this.previousSubpage();
        } else if (keyCode == 205) {
            this.nextSubpage();
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 1) {
            this.nextPage();
        } else if (button.field_146127_k == 2) {
            this.previousPage();
        } else if (button.field_146127_k == 3) {
            this.nextSubpage();
        } else if (button.field_146127_k == 4) {
            this.previousSubpage();
        } else if (button.field_146127_k == this.patreonLinkButton.field_146127_k) {
            this.func_175276_a(new TextComponentString("").func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.patreon.com/Geforce"))));
            return;
        }
        ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m = this.currentPage != -1 && this.subpages.size() > 1;
        ((GuiButton)this.field_146292_n.get((int)3)).field_146125_m = this.currentPage != -1 && this.subpages.size() > 1;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (this.currentPage == -1 && this.patronList != null && this.patronList.isHovering && !this.patronList.patrons.isEmpty()) {
            this.patronList.handleMouseInput(mouseX, mouseY);
            return;
        }
        switch ((int)Math.signum(Mouse.getEventDWheel())) {
            case -1: {
                this.nextPage();
                break;
            }
            case 1: {
                this.previousPage();
            }
        }
        ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m = this.currentPage != -1 && this.subpages.size() > 1;
        ((GuiButton)this.field_146292_n.get((int)3)).field_146125_m = this.currentPage != -1 && this.subpages.size() > 1;
    }

    private void nextPage() {
        ++this.currentPage;
        if (this.currentPage > ItemSCManual.PAGES.size() - 1) {
            this.currentPage = -1;
        }
        this.updateRecipeAndIcons();
    }

    private void previousPage() {
        --this.currentPage;
        if (this.currentPage < -1) {
            this.currentPage = ItemSCManual.PAGES.size() - 1;
        }
        this.updateRecipeAndIcons();
    }

    private void nextSubpage() {
        ++this.currentSubpage;
        if (this.currentSubpage == this.subpages.size()) {
            this.currentSubpage = 0;
        }
    }

    private void previousSubpage() {
        --this.currentSubpage;
        if (this.currentSubpage == -1) {
            this.currentSubpage = this.subpages.size() - 1;
        }
    }

    private void updateRecipeAndIcons() {
        String helpInfo;
        SCManualPage page;
        block32: {
            boolean reinforcedPage;
            this.currentSubpage = 0;
            this.hoverCheckers.clear();
            boolean bl = this.patreonLinkButton.field_146125_m = this.currentPage == -1;
            if (this.currentPage < 0) {
                ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m = false;
                ((GuiButton)this.field_146292_n.get((int)3)).field_146125_m = false;
                this.recipe = null;
                if (I18n.func_188566_a((String)"gui.securitycraft:scManual.author")) {
                    this.author = this.field_146289_q.func_78271_c(Utils.localize("gui.securitycraft:scManual.author", new Object[0]).func_150254_d(), 180);
                } else {
                    this.author.clear();
                }
                this.intro2 = this.field_146289_q.func_78271_c(Utils.localize("gui.securitycraft:scManual.intro.2", new Object[0]).func_150254_d(), 225);
                this.patronList.fetchPatrons();
                return;
            }
            page = ItemSCManual.PAGES.get(this.currentPage);
            if (page.hasCustomRecipe()) {
                this.recipe = page.getRecipe();
            } else {
                this.recipe = null;
                for (int o = 0; o < CraftingManager.field_193380_a.func_148742_b().size(); ++o) {
                    ShapedRecipes recipe;
                    IRecipe object = (IRecipe)CraftingManager.field_193380_a.func_148754_a(o);
                    if (object instanceof ShapedRecipes) {
                        recipe = (ShapedRecipes)object;
                        if (recipe.func_77571_b().func_190926_b() || recipe.func_77571_b().func_77973_b() != page.getItem()) continue;
                        NonNullList ingredients = recipe.func_192400_c();
                        NonNullList recipeItems = NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
                        for (int i = 0; i < ingredients.size(); ++i) {
                            recipeItems.set(this.getCraftMatrixPosition(i, recipe.func_192403_f(), recipe.func_192404_g()), ingredients.get(i));
                        }
                        this.recipe = recipeItems;
                        break;
                    }
                    if (!(object instanceof ShapelessRecipes) || (recipe = (ShapelessRecipes)object).func_77571_b().func_190926_b() || recipe.func_77571_b().func_77973_b() != page.getItem() || recipe.getRegistryName().func_110623_a().endsWith("_reset")) continue;
                    NonNullList recipeItems = NonNullList.func_191197_a((int)recipe.field_77579_b.size(), (Object)Ingredient.field_193370_a);
                    for (int i = 0; i < recipeItems.size(); ++i) {
                        recipeItems.set(i, recipe.field_77579_b.get(i));
                    }
                    this.recipe = recipeItems;
                    break;
                }
            }
            helpInfo = page.getHelpInfo();
            boolean bl2 = reinforcedPage = helpInfo.equals("help.securitycraft:reinforced.info") || helpInfo.contains("reinforced_hopper");
            if (this.recipe != null && !reinforcedPage) {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        if (i * 3 + j != this.recipe.size()) {
                            if (((Ingredient)this.recipe.get(i * 3 + j)).func_193365_a().length <= 0 || ((Ingredient)this.recipe.get(i * 3 + j)).func_193365_a()[0].func_190926_b()) continue;
                            this.hoverCheckers.add(new StackHoverChecker(((Ingredient)this.recipe.get(i * 3 + j)).func_193365_a()[0], 144 + i * 19, 144 + i * 19 + 16, this.startX + 101 + j * 19, this.startX + 100 + j * 19 + 16));
                            continue;
                        }
                        break block32;
                    }
                }
            } else if (page.isRecipeDisabled()) {
                this.hoverCheckers.add(new StringHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]).func_150254_d()));
            } else if (reinforcedPage) {
                this.recipe = null;
                this.hoverCheckers.add(new StringHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, Utils.localize("gui.securitycraft:scManual.recipe.reinforced", new Object[0]).func_150254_d()));
            } else {
                String name = page.getItem().getRegistryName().func_110623_a();
                this.hoverCheckers.add(new StringHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, Utils.localize("gui.securitycraft:scManual.recipe." + name, new Object[0]).func_150254_d()));
            }
        }
        Item item = page.getItem();
        this.pageStack = new ItemStack(item);
        this.resetTileEntityInfo();
        if (item instanceof ItemBlock) {
            Block block = ((ItemBlock)item).func_179223_d();
            this.explosive = block instanceof IExplosive;
            if (this.explosive) {
                this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 107, this.startX + 107 + 16, Utils.localize("gui.securitycraft:scManual.explosiveBlock", new Object[0]).func_150254_d()));
            }
            if (block.hasTileEntity(block.func_176223_P())) {
                IModuleInventory moduleInv;
                ArrayList<String> display;
                ICustomizable scte;
                TileEntity te = block.createTileEntity((World)Minecraft.func_71410_x().field_71441_e, block.func_176223_P());
                this.ownable = te instanceof IOwnable;
                if (this.ownable) {
                    this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 29, this.startX + 29 + 16, Utils.localize("gui.securitycraft:scManual.ownableBlock", new Object[0]).func_150254_d()));
                }
                if (this.passwordProtected = te instanceof IPasswordProtected) {
                    this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 55, this.startX + 55 + 16, Utils.localize("gui.securitycraft:scManual.passwordProtectedBlock", new Object[0]).func_150254_d()));
                }
                if (this.viewActivated = te instanceof IViewActivated) {
                    this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 81, this.startX + 81 + 16, Utils.localize("gui.securitycraft:scManual.viewActivatedBlock", new Object[0]).func_150254_d()));
                }
                if (te instanceof ICustomizable && (scte = (ICustomizable)te).customOptions() != null && scte.customOptions().length > 0) {
                    display = new ArrayList<String>();
                    this.customizable = true;
                    display.add(Utils.localize("gui.securitycraft:scManual.options", new Object[0]).func_150254_d());
                    display.add("---");
                    for (Option<?> option : scte.customOptions()) {
                        display.add("- " + Utils.localize("option." + block.func_149739_a().substring(5) + "." + option.getName() + ".description", new Object[0]).func_150254_d());
                        display.add("");
                    }
                    display.remove(display.size() - 1);
                    this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 136, this.startX + 136 + 16, display));
                }
                if (te instanceof IModuleInventory && (moduleInv = (IModuleInventory)te).acceptedModules() != null && moduleInv.acceptedModules().length > 0) {
                    display = new ArrayList();
                    this.moduleInventory = true;
                    display.add(Utils.localize("gui.securitycraft:scManual.modules", new Object[0]).func_150254_d());
                    display.add("---");
                    for (EnumModuleType enumModuleType : moduleInv.acceptedModules()) {
                        display.add("- " + Utils.localize("module." + block.func_149739_a().substring(5) + "." + enumModuleType.getItem().func_77658_a().substring(5).replace("securitycraft:", "") + ".description", new Object[0]).func_150254_d());
                        display.add("");
                    }
                    display.remove(display.size() - 1);
                    this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 163, this.startX + 163 + 16, display));
                }
                if (this.lockable = te instanceof ILockable) {
                    this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 189, this.startX + 189 + 16, Utils.localize("gui.securitycraft:scManual.lockable", new Object[0]).func_150254_d()));
                }
                if (this.customizable || this.moduleInventory) {
                    this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 213, this.startX + 213 + 16, Utils.localize("gui.securitycraft:scManual.customizableBlock", new Object[0]).func_150254_d()));
                }
            }
        }
        helpInfo = Utils.localize(page.getHelpInfo(), new Object[0]).func_150254_d();
        this.subpages.clear();
        while (this.field_146289_q.func_78256_a(helpInfo) > 1285) {
            String trimmed = this.field_146289_q.func_78269_a(helpInfo, 1285);
            int temp = trimmed.lastIndexOf(32);
            if (temp > 0) {
                trimmed = trimmed.trim().substring(0, temp);
            }
            trimmed = trimmed.trim();
            this.subpages.add(trimmed);
            helpInfo = helpInfo.replace(trimmed, "").trim();
        }
        this.subpages.add(helpInfo);
    }

    private void resetTileEntityInfo() {
        this.explosive = false;
        this.ownable = false;
        this.passwordProtected = false;
        this.viewActivated = false;
        this.customizable = false;
        this.lockable = false;
        this.moduleInventory = false;
    }

    private int getCraftMatrixPosition(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 1 : 4);
        } else if (height == 1) {
            index = i + 3;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i + 3 : i;
        }
        return index;
    }

    class HyperlinkButton
    extends GuiButtonExt {
        public HyperlinkButton(int id, int xPos, int yPos, int width, int height, String displayString) {
            super(id, xPos, yPos, width, height, displayString);
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                mc.func_110434_K().func_110577_a(GuiSCManual.this.infoBookIcons);
                boolean bl = this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                if (this.field_146123_n) {
                    this.func_73729_b(this.field_146128_h, this.field_146129_i, 138, 1, 16, 16);
                } else {
                    this.func_73729_b(this.field_146128_h, this.field_146129_i, 122, 1, 16, 16);
                }
            }
        }
    }

    static class ChangePageButton
    extends GuiButton {
        private final int textureY;

        public ChangePageButton(int index, int xPos, int yPos, boolean forward) {
            super(index, xPos, yPos, 23, 13, "");
            this.textureY = forward ? 192 : 205;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean isHovering = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(bookGuiTextures);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, isHovering ? 23 : 0, this.textureY, 23, 13);
            }
        }
    }

    class PatronList
    extends PatronScrollList {
        private final int slotHeight = 12;
        private final ExecutorService executor;
        private Future<List<String>> patronRequestFuture;
        private List<String> patrons;
        private boolean patronsAvailable;
        private boolean error;
        private boolean patronsRequested;
        private final int barWidth = 6;
        private final List<String> fetchErrorLines;
        private final List<String> noPatronsLines;
        private final String loadingText;
        private final int border = 4;

        public PatronList(Minecraft client, int width, int height, int top, int left, int screenWidth, int screenHeight) {
            super(client, width, height, top, top + height, left, 12, screenWidth, screenHeight);
            this.slotHeight = 12;
            this.executor = Executors.newSingleThreadExecutor();
            this.patrons = new ArrayList<String>();
            this.patronsAvailable = false;
            this.error = false;
            this.barWidth = 6;
            this.loadingText = Utils.localize("gui.securitycraft:scManual.patreon.loading", new Object[0]).func_150254_d();
            this.border = 4;
            this.fetchErrorLines = GuiSCManual.this.field_146289_q.func_78271_c(Utils.localize("gui.securitycraft:scManual.patreon.error", new Object[0]).func_150254_d(), this.listWidth);
            this.noPatronsLines = GuiSCManual.this.field_146289_q.func_78271_c(Utils.localize("advancements.empty", new Object[0]).func_150254_d(), this.listWidth - 10);
        }

        @Override
        public int getSize() {
            return this.patrons.size();
        }

        @Override
        public int getContentHeight() {
            int height = 50 + this.patrons.size() * ((GuiSCManual)GuiSCManual.this).field_146289_q.field_78288_b;
            if (height < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        @Override
        public void drawScreen(int mouseX, int mouseY, float partialTicks) {
            if (this.patronsAvailable) {
                super.drawScreen(mouseX, mouseY, partialTicks);
                int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - 4.0f);
                int slotIndex = mouseListY / 12;
                int baseY = this.top + 4 - (int)this.scrollDistance;
                if (mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.patrons.size() && mouseY >= this.top && mouseY <= this.bottom) {
                    String patron = this.patrons.get(slotIndex);
                    int length = GuiSCManual.this.field_146289_q.func_78256_a(patron);
                    if (length >= this.listWidth - 6) {
                        GuiSCManual.this.func_146279_a(patron, this.left - 10, baseY + (12 * slotIndex + 12));
                        GlStateManager.func_179140_f();
                    }
                }
                if (this.patrons.isEmpty()) {
                    for (int i = 0; i < this.noPatronsLines.size(); ++i) {
                        String line = this.noPatronsLines.get(i);
                        GuiSCManual.this.field_146289_q.func_78276_b(line, this.left + this.listWidth / 2 - GuiSCManual.this.field_146289_q.func_78256_a(line) / 2, this.top + 30 + i * 10, -13421773);
                    }
                }
            } else if (this.error) {
                for (int i = 0; i < this.fetchErrorLines.size(); ++i) {
                    String line = this.fetchErrorLines.get(i);
                    GuiSCManual.this.field_146289_q.func_78276_b(line, this.left + this.listWidth / 2 - GuiSCManual.this.field_146289_q.func_78256_a(line) / 2, this.top + 30 + i * 10, -5242623);
                }
            } else if (this.patronRequestFuture != null && this.patronRequestFuture.isDone()) {
                try {
                    this.patrons = this.patronRequestFuture.get();
                    this.executor.shutdown();
                    this.patronsAvailable = true;
                }
                catch (InterruptedException | ExecutionException e) {
                    this.error = true;
                }
            } else {
                GuiSCManual.this.field_146289_q.func_78276_b(this.loadingText, this.left + this.listWidth / 2 - GuiSCManual.this.field_146289_q.func_78256_a(this.loadingText) / 2, this.top + 30, 0);
            }
        }

        @Override
        public void drawPanel(int entryRight, int relativeY, Tessellator tesselator, int mouseX, int mouseY) {
            for (int i = 0; i < this.patrons.size(); ++i) {
                String patron = this.patrons.get(i);
                if (patron == null || patron.isEmpty()) continue;
                GuiSCManual.this.field_146289_q.func_78276_b(patron, this.left + 2, relativeY + 12 * i, 0);
            }
        }

        public void fetchPatrons() {
            if (!this.patronsRequested) {
                this.patronRequestFuture = this.executor.submit(() -> {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL("https://gist.githubusercontent.com/bl4ckscor3/bdda6596012b1206816db034350b5717/raw").openStream()));){
                        List list = reader.lines().collect(Collectors.toList());
                        return list;
                    }
                    catch (IOException e) {
                        this.error = true;
                        return new ArrayList();
                    }
                });
                this.patronsRequested = true;
            }
        }
    }
}

