/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.api.TileEntityOwnable;
import net.geforcemods.securitycraft.blocks.BlockDisguisable;
import net.geforcemods.securitycraft.blocks.BlockSpecialDoor;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedDoor;
import net.geforcemods.securitycraft.items.ItemBriefcase;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemUniversalOwnerChanger
extends Item {
    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean isDefault;
        ItemStack stack = player.func_184586_b(hand);
        if (hand == EnumHand.MAIN_HAND && player.func_184592_cb().func_77973_b() == SCContent.briefcase) {
            return this.handleBriefcase(player, stack).func_188397_a();
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        TileEntity te = world.func_175625_s(pos);
        String newOwner = stack.func_82833_r();
        if (!(te instanceof IOwnable)) {
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:universalOwnerChanger.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.cantChange", new Object[0]), TextFormatting.RED);
            return EnumActionResult.SUCCESS;
        }
        Owner owner = ((IOwnable)te).getOwner();
        boolean bl = isDefault = owner.getName().equals("owner") && owner.getUUID().equals("ownerUUID");
        if (!owner.isOwner(player) && !isDefault) {
            if (!(block instanceof IBlockMine || te.func_145838_q() instanceof BlockDisguisable && !(((ItemBlock)((BlockDisguisable)te.func_145838_q()).getDisguisedStack((IBlockAccess)world, pos).func_77973_b()).func_179223_d() instanceof BlockDisguisable))) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:universalOwnerChanger.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.notOwned", new Object[0]), TextFormatting.RED);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        if (!stack.func_82837_s() && !isDefault) {
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:universalOwnerChanger.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.noName", new Object[0]), TextFormatting.RED);
            return EnumActionResult.SUCCESS;
        }
        if (isDefault) {
            if (ConfigHandler.allowBlockClaim) {
                newOwner = player.func_70005_c_();
            } else {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:universalOwnerChanger.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.noBlockClaiming", new Object[0]), TextFormatting.RED);
                return EnumActionResult.SUCCESS;
            }
        }
        if (te instanceof IOwnable) {
            ((IOwnable)te).setOwner(PlayerUtils.isPlayerOnline(newOwner) ? PlayerUtils.getPlayerFromName(newOwner).func_110124_au().toString() : "ownerUUID", newOwner);
            ((IOwnable)te).onOwnerChanged(state, world, pos, player);
        }
        if (!world.field_72995_K) {
            world.func_73046_m().func_184103_al().func_148540_a((Packet)te.func_189518_D_());
        }
        if (!world.field_72995_K && te instanceof IModuleInventory) {
            for (EnumModuleType moduleType : ((IModuleInventory)te).getInsertedModules()) {
                ItemStack moduleStack = ((IModuleInventory)te).getModule(moduleType);
                ((IModuleInventory)te).removeModule(moduleType);
                ((IModuleInventory)te).onModuleRemoved(moduleStack, moduleType);
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)moduleStack);
            }
        }
        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:universalOwnerChanger.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.changed", newOwner), TextFormatting.GREEN);
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack ownerChanger = player.func_184586_b(hand);
        if (!ownerChanger.func_82837_s()) {
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.universalOwnerChanger.func_77658_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.noName", new Object[0]), TextFormatting.RED);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)ownerChanger);
        }
        if (hand == EnumHand.MAIN_HAND && player.func_184592_cb().func_77973_b() == SCContent.briefcase) {
            return this.handleBriefcase(player, ownerChanger);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)ownerChanger);
    }

    public static boolean tryUpdateBlock(World world, BlockPos pos, Owner newOwner) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof BlockReinforcedDoor || block instanceof BlockSpecialDoor) {
            TileEntityOwnable te = (TileEntityOwnable)world.func_175625_s(pos);
            te.setOwner(newOwner.getName(), newOwner.getUUID());
            if (!world.field_72995_K) {
                world.func_73046_m().func_184103_al().func_148540_a((Packet)te.func_189518_D_());
            }
            return true;
        }
        return false;
    }

    private ActionResult<ItemStack> handleBriefcase(EntityPlayer player, ItemStack ownerChanger) {
        ItemStack briefcase = player.func_184592_cb();
        if (ItemBriefcase.isOwnedBy(briefcase, player)) {
            String newOwner = ownerChanger.func_82833_r();
            if (!briefcase.func_77942_o()) {
                briefcase.func_77982_d(new NBTTagCompound());
            }
            briefcase.func_77978_p().func_74778_a("owner", newOwner);
            briefcase.func_77978_p().func_74778_a("ownerUUID", PlayerUtils.isPlayerOnline(newOwner) ? PlayerUtils.getPlayerFromName(newOwner).func_110124_au().toString() : "ownerUUID");
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.universalOwnerChanger.func_77658_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.changed", newOwner), TextFormatting.GREEN);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)ownerChanger);
        }
        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.universalOwnerChanger.func_77658_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.briefcase.notOwned", new Object[0]), TextFormatting.RED);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)ownerChanger);
    }
}

