/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.List;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.mines.BlockIMS;
import net.geforcemods.securitycraft.entity.EntityIMSBomb;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileEntityIMS
extends CustomizableSCTE
implements ITickable {
    private Option.OptionInt range = new Option.OptionInt(() -> ((TileEntityIMS)this).func_174877_v(), "range", 12, 1, 30, 1, true);
    private int bombsRemaining = 4;
    private EnumIMSTargetingMode targetingMode = EnumIMSTargetingMode.PLAYERS_AND_MOBS;
    private boolean updateBombCount = false;
    private int attackTime = this.getAttackInterval();

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.updateBombCount) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockIMS.MINES, (Comparable)Integer.valueOf(this.bombsRemaining)));
            this.updateBombCount = false;
        }
        if (this.attackTime-- == 0) {
            this.attackTime = this.getAttackInterval();
            this.launchMine();
        }
    }

    private void launchMine() {
        if (this.bombsRemaining > 0 && !this.field_145850_b.field_72995_K) {
            List players;
            List mobs;
            AxisAlignedBB area = BlockUtils.fromBounds(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + 1).func_72314_b((double)((Integer)this.range.get()).intValue(), (double)((Integer)this.range.get()).intValue(), (double)((Integer)this.range.get()).intValue());
            EntityLivingBase target = null;
            if (!(this.targetingMode != EnumIMSTargetingMode.MOBS && this.targetingMode != EnumIMSTargetingMode.PLAYERS_AND_MOBS || (mobs = this.field_145850_b.func_175647_a(EntityMob.class, area, e -> !EntityUtils.isInvisible((EntityLivingBase)e) && this.canAttackEntity((EntityLivingBase)e))).isEmpty())) {
                target = (EntityLivingBase)mobs.get(0);
            }
            if (!(target != null || this.targetingMode != EnumIMSTargetingMode.PLAYERS && this.targetingMode != EnumIMSTargetingMode.PLAYERS_AND_MOBS || (players = this.field_145850_b.func_175647_a(EntityPlayer.class, area, e -> !EntityUtils.isInvisible((EntityLivingBase)e) && this.canAttackEntity((EntityLivingBase)e))).isEmpty())) {
                target = (EntityLivingBase)players.get(0);
            }
            if (target != null) {
                double addToX = this.bombsRemaining == 4 || this.bombsRemaining == 3 ? 0.84375 : 0.0;
                double addToZ = this.bombsRemaining == 4 || this.bombsRemaining == 2 ? 0.84375 : 0.0;
                int launchHeight = this.getLaunchHeight();
                double accelerationX = target.field_70165_t - (double)this.field_174879_c.func_177958_n();
                double accelerationY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - (double)this.field_174879_c.func_177956_o() - (double)launchHeight;
                double accelerationZ = target.field_70161_v - (double)this.field_174879_c.func_177952_p();
                this.field_145850_b.func_72838_d((Entity)new EntityIMSBomb(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + addToX, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + addToZ, accelerationX, accelerationY, accelerationZ, launchHeight, this));
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f);
                --this.bombsRemaining;
                this.updateBombCount = true;
            }
        }
    }

    public boolean canAttackEntity(EntityLivingBase entity) {
        return entity != null && (!(entity instanceof EntityPlayer) || !this.getOwner().isOwner((EntityPlayer)entity) && !((EntityPlayer)entity).func_184812_l_() && !((EntityPlayer)entity).func_175149_v()) && !ModuleUtils.isAllowed((IModuleInventory)this, (Entity)entity);
    }

    private int getLaunchHeight() {
        BlockPos upPos;
        IBlockState state;
        int height;
        for (height = 1; height <= 9 && (state = this.field_145850_b.func_180495_p(upPos = this.field_174879_c.func_177981_b(height))).func_177230_c().isAir(state, (IBlockAccess)this.field_145850_b, upPos); ++height) {
        }
        return height;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("bombsRemaining", this.bombsRemaining);
        tag.func_74768_a("targetingOption", this.targetingMode.ordinal());
        tag.func_74757_a("updateBombCount", this.updateBombCount);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.bombsRemaining = tag.func_74762_e("bombsRemaining");
        this.targetingMode = EnumIMSTargetingMode.values()[tag.func_74762_e("targetingOption")];
        this.updateBombCount = tag.func_74767_n("updateBombCount");
    }

    public int getBombsRemaining() {
        return this.bombsRemaining;
    }

    public void setBombsRemaining(int bombsRemaining) {
        this.bombsRemaining = bombsRemaining;
    }

    public EnumIMSTargetingMode getTargetingMode() {
        return this.targetingMode;
    }

    public void setTargetingMode(EnumIMSTargetingMode targetingMode) {
        this.targetingMode = targetingMode;
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.ALLOWLIST, EnumModuleType.SPEED};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range};
    }

    public int getAttackInterval() {
        return this.hasModule(EnumModuleType.SPEED) ? 40 : 80;
    }

    public static enum EnumIMSTargetingMode {
        PLAYERS,
        PLAYERS_AND_MOBS,
        MOBS;

    }
}

