/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.BlockKeypadChest;
import net.geforcemods.securitycraft.entity.EntitySentry;
import net.geforcemods.securitycraft.inventory.InsertOnlyDoubleChestHandler;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityKeypadChest
extends TileEntityChest
implements IPasswordProtected,
IOwnable,
IModuleInventory,
ICustomizable,
INameSetter,
ILockable {
    private InsertOnlyDoubleChestHandler insertOnlyHandler;
    private String passcode;
    private Owner owner = new Owner();
    private NonNullList<ItemStack> modules = NonNullList.func_191197_a((int)this.getMaxNumberOfModules(), (Object)ItemStack.field_190927_a);
    private Option.OptionBoolean sendMessage = new Option.OptionBoolean("sendMessage", true);

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.writeModuleInventory(tag);
        this.writeOptions(tag);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.func_74778_a("passcode", this.passcode);
        }
        if (this.owner != null) {
            this.owner.writeToNBT(tag, false);
        }
        return tag;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.modules = this.readModuleInventory(tag);
        this.readOptions(tag);
        this.passcode = tag.func_74779_i("passcode");
        this.owner.readFromNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)BlockUtils.getProtectedCapability(facing, (TileEntity)this, () -> super.getCapability(capability, facing), () -> this.getInsertOnlyHandler());
        }
        return (T)super.getCapability(capability, facing);
    }

    private InsertOnlyDoubleChestHandler getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null || this.insertOnlyHandler.needsRefresh()) {
            this.insertOnlyHandler = InsertOnlyDoubleChestHandler.get(this);
        }
        return this.insertOnlyHandler;
    }

    public IItemHandler getHandlerForSentry(EntitySentry entity) {
        if (entity.getOwner().owns(this)) {
            return (IItemHandler)super.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        }
        return null;
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : super.func_70301_a(slot);
    }

    @Override
    public void activate(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K && !this.isBlocked()) {
            ((BlockKeypadChest)this.func_145838_q()).activate(this.field_145850_b, this.field_174879_c, player);
        }
    }

    @Override
    public void openPasswordGUI(EntityPlayer player) {
        if (this.isBlocked()) {
            return;
        }
        if (this.getPassword() != null) {
            player.openGui((Object)SecurityCraft.instance, 10, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        } else if (this.getOwner().isOwner(player)) {
            player.openGui((Object)SecurityCraft.instance, 9, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        } else {
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)new TextComponentString("SecurityCraft"), (ITextComponent)Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
        }
    }

    @Override
    public boolean onCodebreakerUsed(IBlockState blockState, EntityPlayer player) {
        this.activate(player);
        return true;
    }

    @Override
    public void onModuleInserted(ItemStack stack, EnumModuleType module) {
        IModuleInventory.super.onModuleInserted(stack, module);
        this.addOrRemoveModuleFromAttached(stack, false);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, EnumModuleType module) {
        IModuleInventory.super.onModuleRemoved(stack, module);
        this.addOrRemoveModuleFromAttached(stack, true);
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        TileEntityKeypadChest offsetTe;
        if (option instanceof Option.OptionBoolean && (offsetTe = this.findOther()) != null) {
            offsetTe.setSendsMessages((Boolean)((Option.OptionBoolean)option).get());
        }
    }

    public void addOrRemoveModuleFromAttached(ItemStack module, boolean remove) {
        if (module.func_190926_b() || !(module.func_77973_b() instanceof ItemModule)) {
            return;
        }
        TileEntityKeypadChest offsetTe = this.findOther();
        if (offsetTe != null) {
            if (remove) {
                offsetTe.removeModule(((ItemModule)module.func_77973_b()).getModuleType());
            } else {
                offsetTe.insertModule(module);
            }
        }
    }

    public TileEntityKeypadChest findOther() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            TileEntity offsetTe;
            BlockPos offsetPos = this.field_174879_c.func_177972_a(facing);
            IBlockState offsetState = this.field_145850_b.func_180495_p(offsetPos);
            if (state.func_177230_c() != offsetState.func_177230_c() || !((offsetTe = this.field_145850_b.func_175625_s(offsetPos)) instanceof TileEntityKeypadChest)) continue;
            return (TileEntityKeypadChest)offsetTe;
        }
        return null;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
    }

    protected TileEntityChest func_174911_a(EnumFacing side) {
        TileEntity te;
        BlockPos blockpos = this.field_174879_c.func_177972_a(side);
        if (this.func_174912_b(blockpos) && (te = this.field_145850_b.func_175625_s(blockpos)) instanceof TileEntityKeypadChest) {
            TileEntityKeypadChest tileentitychest = (TileEntityKeypadChest)te;
            tileentitychest.func_174910_a(this, side.func_176734_d());
            return tileentitychest;
        }
        return null;
    }

    public boolean func_174912_b(BlockPos pos) {
        return this.field_145850_b != null && this.field_145850_b.func_180495_p(pos).func_177230_c() instanceof BlockKeypadChest;
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.field_145987_o < 0) {
                this.field_145987_o = 0;
            }
            ++this.field_145987_o;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.field_145987_o);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
            if (this.hasModule(EnumModuleType.REDSTONE)) {
                this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), this.func_145838_q(), false);
            }
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v() && this.func_145838_q() instanceof BlockKeypadChest) {
            --this.field_145987_o;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.field_145987_o);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
            if (this.hasModule(EnumModuleType.REDSTONE)) {
                this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), this.func_145838_q(), false);
            }
        }
    }

    public boolean isBlocked() {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos pos = this.func_174877_v().func_177972_a(facing);
            if (!(this.field_145850_b.func_180495_p(pos).func_177230_c() instanceof BlockKeypadChest) || !BlockKeypadChest.isBlocked(this.field_145850_b, pos)) continue;
            return true;
        }
        return this.isSingleBlocked();
    }

    public boolean isSingleBlocked() {
        return BlockKeypadChest.isBlocked(this.func_145831_w(), this.func_174877_v());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 2, 2));
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.ALLOWLIST, EnumModuleType.DENYLIST, EnumModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public void setSendsMessages(boolean value) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.sendMessage.setValue(value);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.field_190577_o) : this.getDefaultName();
    }

    @Override
    public ITextComponent getDefaultName() {
        return Utils.localize(this.field_145854_h.func_149739_a() + ".name", new Object[0]);
    }
}

