/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.common.network.message;

import com.elytradev.movingworld.MovingWorldMod;
import com.elytradev.movingworld.common.chunk.ChunkIO;
import com.elytradev.movingworld.common.entity.EntityMovingWorld;
import com.elytradev.movingworld.common.network.MovingWorldNetworking;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.Message;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.NetworkContext;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.annotation.field.MarshalledAs;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.annotation.type.ReceivedOn;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;

@ReceivedOn(value=Side.CLIENT)
public class MovingWorldBlockChangeMessage
extends Message {
    @MarshalledAs(value="com.elytradev.movingworld.common.network.marshallers.EntityMarshaller")
    public EntityMovingWorld movingWorld;
    @MarshalledAs(value="com.elytradev.movingworld.common.network.marshallers.ByteBufMarshaller")
    public ByteBuf compressedChunkData;

    public MovingWorldBlockChangeMessage(NetworkContext ctx) {
        super(ctx);
    }

    public MovingWorldBlockChangeMessage(EntityMovingWorld movingWorld, ByteBuf compressedChunkData) {
        super(MovingWorldNetworking.NETWORK);
        this.movingWorld = movingWorld;
        this.compressedChunkData = compressedChunkData;
    }

    @Override
    protected void handle(EntityPlayer sender) {
        if (this.movingWorld == null || this.movingWorld.getMobileChunk() == null || this.compressedChunkData == null) {
            return;
        }
        try {
            this.compressedChunkData.resetReaderIndex();
            this.compressedChunkData.resetWriterIndex();
            ChunkIO.readCompressed(this.compressedChunkData, this.movingWorld.getMobileChunk());
        }
        catch (IOException e) {
            MovingWorldMod.LOG.error((Object)e);
        }
    }
}

