/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.common.network.message;

import com.elytradev.movingworld.common.entity.EntityMovingWorld;
import com.elytradev.movingworld.common.network.MovingWorldClientAction;
import com.elytradev.movingworld.common.network.MovingWorldNetworking;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.Message;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.NetworkContext;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.annotation.field.MarshalledAs;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.annotation.type.ReceivedOn;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;

@ReceivedOn(value=Side.SERVER)
public class MovingWorldClientActionMessage
extends Message {
    @MarshalledAs(value="com.elytradev.movingworld.common.network.marshallers.EntityMarshaller")
    public EntityMovingWorld movingWorld;
    public MovingWorldClientAction action;

    public MovingWorldClientActionMessage(NetworkContext ctx) {
        super(ctx);
    }

    public MovingWorldClientActionMessage(EntityMovingWorld movingWorld, MovingWorldClientAction action) {
        super(MovingWorldNetworking.NETWORK);
        this.movingWorld = movingWorld;
        this.action = action;
        if (action == MovingWorldClientAction.DISASSEMBLE || action == MovingWorldClientAction.DISASSEMBLEWITHOVERWRITE) {
            movingWorld.disassembling = true;
        }
    }

    @Override
    protected void handle(EntityPlayer sender) {
        if (this.movingWorld == null || sender != this.movingWorld.func_184179_bs()) {
            return;
        }
        switch (this.action) {
            case DISASSEMBLE: {
                this.movingWorld.alignToGrid(true);
                this.movingWorld.updatePassengerPosition((Entity)sender, this.movingWorld.riderDestination, 1);
                this.movingWorld.func_184226_ay();
                this.movingWorld.disassemble(false);
                break;
            }
            case DISASSEMBLEWITHOVERWRITE: {
                this.movingWorld.alignToGrid(true);
                this.movingWorld.updatePassengerPosition((Entity)sender, this.movingWorld.riderDestination, 1);
                this.movingWorld.func_184226_ay();
                this.movingWorld.disassemble(true);
                break;
            }
            case ALIGN: {
                this.movingWorld.alignToGrid(true);
                break;
            }
        }
    }
}

