/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class CamoBlock
extends BaseBlock {
    public static final IUnlistedProperty<IBlockState> CAMO_PROPERTY = new IUnlistedProperty<IBlockState>(){

        public String getName() {
            return "camo_data";
        }

        public boolean isValid(IBlockState value) {
            return true;
        }

        public Class<IBlockState> getType() {
            return IBlockState.class;
        }

        public String valueToString(IBlockState value) {
            return value.toString();
        }
    };
    private final Supplier<? extends CamoBlockEntity> tileSupplier;

    public CamoBlock(String registryName, BaseBlock.Properties properties, Supplier<? extends CamoBlockEntity> tileSupplier) {
        super(registryName, false, properties);
        this.tileSupplier = tileSupplier;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand handIn, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity blockEntity = worldIn.func_175625_s(pos);
        if (blockEntity instanceof CamoBlockEntity) {
            this.onRightClick(state, worldIn, (CamoBlockEntity)blockEntity, pos, player, handIn, facing, hitX, hitY, hitZ);
        }
        return true;
    }

    protected boolean onRightClick(IBlockState state, World worldIn, CamoBlockEntity blockEntity, BlockPos pos, EntityPlayer player, EnumHand handIn, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && player.func_184586_b(handIn).func_190926_b()) {
            blockEntity.setCamoState(null);
            return true;
        }
        if (!player.func_70093_af() && blockEntity.canBeCamoStack(player.func_184586_b(handIn))) {
            Item item = player.func_184586_b(handIn).func_77973_b();
            if (item instanceof ItemBlock) {
                Block block = ((ItemBlock)item).func_179223_d();
                IBlockState state1 = block.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, 0, (EntityLivingBase)player, handIn);
                if (state1 == null) {
                    state1 = block.func_176223_P();
                }
                blockEntity.setCamoState(state1);
            }
            return true;
        }
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return (TileEntity)this.tileSupplier.get();
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess reader, BlockPos pos) {
        TileEntity blockEntity = reader.func_175625_s(pos);
        return blockEntity instanceof CamoBlockEntity && ((CamoBlockEntity)blockEntity).hasCamoState() ? ((CamoBlockEntity)blockEntity).getCamoState().getLightValue(reader, pos) : super.getLightValue(state, reader, pos);
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess reader, BlockPos pos, EnumFacing face) {
        TileEntity blockEntity = reader.func_175625_s(pos);
        return blockEntity instanceof CamoBlockEntity && ((CamoBlockEntity)blockEntity).hasCamoState() ? ((CamoBlockEntity)blockEntity).getCamoState().func_185894_c(reader, pos, face) : super.func_176225_a(state, reader, pos, face);
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess reader, BlockPos pos, EnumFacing face) {
        TileEntity blockEntity = reader.func_175625_s(pos);
        return blockEntity instanceof CamoBlockEntity && ((CamoBlockEntity)blockEntity).hasCamoState() ? ((CamoBlockEntity)blockEntity).getCamoState().doesSideBlockRendering(reader, pos, face) : super.doesSideBlockRendering(state, reader, pos, face);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess reader, BlockPos pos) {
        TileEntity blockEntity = reader.func_175625_s(pos);
        return blockEntity instanceof CamoBlockEntity && ((CamoBlockEntity)blockEntity).hasCamoState() ? ((CamoBlockEntity)blockEntity).getCamoState().getLightOpacity(reader, pos) : super.getLightOpacity(state, reader, pos);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, this.getProperties(), new IUnlistedProperty[]{CAMO_PROPERTY});
    }

    protected IProperty<?>[] getProperties() {
        return new IProperty[0];
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof CamoBlockEntity) {
            return ((IExtendedBlockState)state).withProperty(CAMO_PROPERTY, (Object)((CamoBlockEntity)entity).getCamoState());
        }
        return state;
    }
}

