/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.movingelevators.MovingElevatorsClient;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlock;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.blocks.RemoteControllerBlockItem;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ControllerBlock
extends ElevatorInputBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public ControllerBlock(String registryName, BaseBlock.Properties properties) {
        super(registryName, properties, (Supplier<? extends ElevatorInputBlockEntity>)((Supplier<ElevatorInputBlockEntity>)ControllerBlockEntity::new));
    }

    @Override
    protected boolean onRightClick(IBlockState state, World worldIn, CamoBlockEntity blockEntity, BlockPos pos, EntityPlayer player, EnumHand handIn, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player != null && player.func_184586_b(handIn).func_77973_b() instanceof RemoteControllerBlockItem) {
            if (!worldIn.field_72995_K) {
                ItemStack stack = player.func_184586_b(handIn);
                NBTTagCompound tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
                tag.func_74768_a("controllerDim", worldIn.field_73011_w.func_186058_p().func_186068_a());
                tag.func_74768_a("controllerX", pos.func_177958_n());
                tag.func_74768_a("controllerY", pos.func_177956_o());
                tag.func_74768_a("controllerZ", pos.func_177952_p());
                stack.func_77982_d(tag);
                player.func_146105_b(TextComponents.translation((String)"movingelevators.remote_controller.bind").get(), true);
            }
            return true;
        }
        if (super.onRightClick(state, worldIn, blockEntity, pos, player, handIn, facing, hitX, hitY, hitZ)) {
            return true;
        }
        if (state.func_177229_b((IProperty)FACING) != facing) {
            if (worldIn.field_72995_K) {
                MovingElevatorsClient.openElevatorScreen(pos);
            }
            return true;
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof ControllerBlockEntity) {
            ((ControllerBlockEntity)tile).onBreak();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Override
    protected IProperty<?>[] getProperties() {
        return new IProperty[]{FACING};
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof ControllerBlockEntity && ((ControllerBlockEntity)entity).hasGroup() && ((ControllerBlockEntity)entity).getGroup().isCageAvailableAt((ControllerBlockEntity)entity)) {
            return 15;
        }
        return 0;
    }

    public void func_190948_a(ItemStack stack, @Nullable World reader, List<String> tooltips, ITooltipFlag advanced) {
        super.func_190948_a(stack, reader, tooltips, advanced);
        tooltips.add(TextComponents.translation((String)"movingelevators.elevator_controller.tooltip").color(TextFormatting.AQUA).format());
    }
}

