/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.movingelevators.blocks.CamoBlock;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.DisplayBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class DisplayBlock
extends CamoBlock {
    public static final int BUTTON_COUNT = 3;
    public static final int BUTTON_COUNT_BIG = 7;
    public static final float BUTTON_HEIGHT = 0.125f;

    public DisplayBlock(String registryName, BaseBlock.Properties properties) {
        super(registryName, properties, DisplayBlockEntity::new);
    }

    @Override
    protected boolean onRightClick(IBlockState state, World worldIn, CamoBlockEntity blockEntity, BlockPos pos, EntityPlayer player, EnumHand handIn, EnumFacing facing, float hitX, float hitY, float hitZ) {
        DisplayBlockEntity displayTile;
        if (blockEntity instanceof DisplayBlockEntity && (displayTile = (DisplayBlockEntity)blockEntity).getFacing() == facing) {
            if (!worldIn.field_72995_K) {
                double hitHorizontal;
                int displayCat = displayTile.getDisplayCategory();
                double d = hitHorizontal = facing.func_176740_k() == EnumFacing.Axis.Z ? (double)hitX : (double)hitZ;
                if (hitHorizontal > 0.0625 && hitHorizontal < 0.9375) {
                    TileEntity blockEntity2;
                    BlockPos inputTilePos = null;
                    int button_count = -1;
                    int height = -1;
                    if (displayCat == 1) {
                        if ((double)hitY > 0.0625 && (double)hitY < 0.9375) {
                            inputTilePos = pos.func_177977_b();
                            button_count = 3;
                            height = 1;
                        }
                    } else if (displayCat == 2) {
                        if ((double)hitY > 0.0625) {
                            inputTilePos = pos.func_177977_b();
                            button_count = 7;
                            height = 2;
                        }
                    } else if (displayCat == 3 && (double)hitY < 0.9375) {
                        inputTilePos = pos.func_177979_c(2);
                        button_count = 7;
                        height = 2;
                        hitY += 1.0f;
                    }
                    if ((blockEntity2 = worldIn.func_175625_s(inputTilePos)) instanceof ElevatorInputBlockEntity && ((ElevatorInputBlockEntity)blockEntity2).hasGroup()) {
                        int above;
                        ElevatorInputBlockEntity inputTile = (ElevatorInputBlockEntity)blockEntity2;
                        ElevatorGroup group = inputTile.getGroup();
                        int index = inputTile.getGroup().getFloorNumber(inputTile.getFloorLevel());
                        int below = index;
                        if (below < (above = group.getFloorCount() - index - 1)) {
                            below = Math.min(below, button_count);
                            above = Math.min(above, button_count * 2 - below);
                        } else {
                            above = Math.min(above, button_count);
                            below = Math.min(below, button_count * 2 - above);
                        }
                        int startIndex = index - below;
                        int total = below + 1 + above;
                        int floorOffset = (int)Math.floor(((double)hitY - (double)((float)height - (float)total * 0.125f) / 2.0) / 0.125) + startIndex - index;
                        if (player == null || player.func_184586_b(handIn).func_190926_b() || !(player.func_184586_b(handIn).func_77973_b() instanceof ItemDye)) {
                            inputTile.getGroup().onDisplayPress(inputTile.getFloorLevel(), floorOffset);
                        } else {
                            EnumDyeColor color = EnumDyeColor.func_176766_a((int)player.func_184586_b(handIn).func_77960_j());
                            int floor = group.getFloorNumber(inputTile.getFloorLevel()) + floorOffset;
                            ControllerBlockEntity elevatorTile = group.getTileForFloor(floor);
                            if (elevatorTile != null) {
                                elevatorTile.setDisplayLabelColor(color);
                            }
                        }
                    }
                }
            }
            return true;
        }
        return super.onRightClick(state, worldIn, blockEntity, pos, player, handIn, facing, hitX, hitY, hitZ);
    }

    public void func_190948_a(ItemStack stack, @Nullable World reader, List<String> tooltips, ITooltipFlag advanced) {
        super.func_190948_a(stack, reader, tooltips, advanced);
        tooltips.add(TextComponents.translation((String)"movingelevators.elevator_display.tooltip").color(TextFormatting.AQUA).format());
    }
}

