/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.movingelevators.MovingElevatorsClient;
import com.supermartijn642.movingelevators.blocks.DisplayBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DisplayBlockEntityRenderer
extends TileEntitySpecialRenderer<DisplayBlockEntity> {
    private static final double TEXT_RENDER_DISTANCE = 225.0;

    public void render(DisplayBlockEntity entity, double x, double y, double z, float partialTicks, int combinedOverlay, float alpha) {
        double platformY;
        int combinedLight;
        if (!entity.isBottomDisplay() || !entity.getInputBlockEntity().hasGroup()) {
            return;
        }
        int height = entity.hasDisplayOnTop() ? 2 : 1;
        World level = entity.func_145831_w();
        EnumFacing facing = entity.getFacing();
        ElevatorGroup group = entity.getElevatorGroup();
        BlockPos frontPos = entity.func_174877_v().func_177972_a(facing);
        if (height == 1) {
            combinedLight = entity.func_145831_w().func_175626_b(frontPos, entity.func_145831_w().func_180495_p(frontPos).getLightValue((IBlockAccess)entity.func_145831_w(), frontPos));
        } else {
            int skyLight = Math.max(level.func_175642_b(EnumSkyBlock.SKY, frontPos), level.func_175642_b(EnumSkyBlock.SKY, frontPos.func_177984_a()));
            int blockLight = Math.max(level.func_175642_b(EnumSkyBlock.BLOCK, frontPos), level.func_175642_b(EnumSkyBlock.BLOCK, frontPos.func_177984_a()));
            int blockStateLight = Math.max(level.func_180495_p(frontPos).getLightValue((IBlockAccess)level, frontPos), level.func_180495_p(frontPos.func_177984_a()).getLightValue((IBlockAccess)level, frontPos.func_177984_a()));
            blockLight = Math.max(blockLight, blockStateLight);
            combinedLight = skyLight << 20 | blockLight << 4;
        }
        ScreenUtils.bindTexture((ResourceLocation)TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179114_b((float)(180.0f - facing.func_185119_l()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.51);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        if (height == 1) {
            this.drawOverlayPart(combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, 0, 0, 32, 32);
        } else {
            this.drawOverlayPart(combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 2.0f, 32, 0, 32, 64);
        }
        int index = group.getFloorNumber(entity.getInputBlockEntity().getFloorLevel());
        int button_count = height == 1 ? 3 : 7;
        int below = index;
        int above = group.getFloorCount() - index - 1;
        if (below < above) {
            below = Math.min(below, button_count);
            above = Math.min(above, button_count * 2 - below);
        } else {
            above = Math.min(above, button_count);
            below = Math.min(below, button_count * 2 - above);
        }
        int startIndex = index - below;
        int total = below + 1 + above;
        Vec3d buttonPos = new Vec3d((double)entity.func_174877_v().func_177958_n() + 0.5, (double)entity.func_174877_v().func_177956_o() + 0.5 * (double)height - (double)((float)total * 0.125f) / 2.0, (double)entity.func_174877_v().func_177952_p() + 0.5);
        Vec3d cameraPos = RenderUtils.getCameraPosition();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)(0.5 * (double)height - (double)((float)total * 0.125f) / 2.0), (double)-0.002);
        GlStateManager.func_179152_a((float)1.0f, (float)0.125f, (float)1.0f);
        for (int i = 0; i < total; ++i) {
            boolean drawText;
            EnumDyeColor labelColor = group.getFloorDisplayColor(startIndex + i);
            this.drawOverlayPart(combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, startIndex + i == index ? 96 : 64, labelColor.func_176765_a() * 4, 32, 4);
            boolean bl = drawText = cameraPos.func_72436_e(buttonPos) < 225.0;
            if (drawText) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)0.578125, (double)0.0, (double)0.0);
                this.drawString(combinedLight, MovingElevatorsClient.formatFloorDisplayName(group.getFloorDisplayName(startIndex + i), startIndex + i));
                GlStateManager.func_179121_F();
                ScreenUtils.bindTexture((ResourceLocation)TextureMap.field_110575_b);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
            buttonPos = buttonPos.func_72441_c(0.0, 0.125, 0.0);
        }
        GlStateManager.func_179121_F();
        if (group.isMoving() && (platformY = group.getCurrentY()) >= (double)group.getFloorYLevel(0) && platformY < (double)group.getFloorYLevel(group.getFloorCount() - 1)) {
            double yOffset = 0.5 * (double)height - (double)((float)total * 0.125f) / 2.0;
            for (int i = 0; i < group.getFloorCount() - 1; ++i) {
                int belowY = group.getFloorYLevel(i);
                int aboveY = group.getFloorYLevel(i + 1);
                if (!(platformY >= (double)belowY) || !(platformY < (double)aboveY)) continue;
                yOffset += ((double)i + (platformY - (double)belowY) / (double)(aboveY - belowY)) * 0.125;
            }
            GlStateManager.func_179137_b((double)0.078125, (double)yOffset, (double)-0.003);
            GlStateManager.func_179152_a((float)0.125f, (float)0.125f, (float)1.0f);
            this.drawOverlayPart(combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, 0, 32, 10, 10);
        }
        GlStateManager.func_179121_F();
    }

    private void drawOverlayPart(int combinedLight, int combinedOverlay, EnumFacing facing, float x, float y, float width, float height, int tX, int tY, int tWidth, int tHeight) {
        float minU = MovingElevatorsClient.OVERLAY_SPRITE.func_94214_a((double)((float)tX / 8.0f));
        float maxU = MovingElevatorsClient.OVERLAY_SPRITE.func_94214_a((double)((float)(tX + tWidth) / 8.0f));
        float minV = MovingElevatorsClient.OVERLAY_SPRITE.func_94207_b((double)((float)tY / 8.0f));
        float maxV = MovingElevatorsClient.OVERLAY_SPRITE.func_94207_b((double)((float)(tY + tHeight) / 8.0f));
        int k = combinedLight >> 16 & 0xFFFF;
        int l = combinedLight & 0xFFFF;
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_181669_b(255, 255, 255, 255).func_187315_a((double)maxU, (double)minV).func_187314_a(k, l).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181669_b(255, 255, 255, 255).func_187315_a((double)minU, (double)minV).func_187314_a(k, l).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, 0.0).func_181669_b(255, 255, 255, 255).func_187315_a((double)minU, (double)maxV).func_187314_a(k, l).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181669_b(255, 255, 255, 255).func_187315_a((double)maxU, (double)maxV).func_187314_a(k, l).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    private void drawString(int combinedLight, String s) {
        if (s == null) {
            return;
        }
        FontRenderer fontRenderer = this.func_147498_b();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.07, (double)-0.005);
        GlStateManager.func_179152_a((float)-0.01f, (float)-0.08f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        fontRenderer.func_78276_b(s, -fontRenderer.func_78256_a(s) / 2, -fontRenderer.field_78288_b, EnumDyeColor.WHITE.func_193350_e());
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }
}

