/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.movingelevators.elevator.ElevatorCage;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import com.supermartijn642.movingelevators.elevator.ElevatorGroupCapability;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ElevatorGroupRenderer {
    public static final double RENDER_DISTANCE = 260100.0;

    @SubscribeEvent
    public static void onRender(RenderWorldLastEvent e) {
        ElevatorGroupCapability groups = (ElevatorGroupCapability)ClientUtils.getWorld().getCapability(ElevatorGroupCapability.CAPABILITY, null);
        if (groups == null) {
            return;
        }
        GlStateManager.func_179094_E();
        Vec3d camera = RenderUtils.getCameraPosition();
        GlStateManager.func_179137_b((double)(-camera.field_72450_a), (double)(-camera.field_72448_b), (double)(-camera.field_72449_c));
        for (ElevatorGroup group : groups.getGroups()) {
            BlockPos elevatorPos = new BlockPos((double)group.x, group.getCurrentY(), (double)group.z);
            if (!(elevatorPos.func_177951_i((Vec3i)ClientUtils.getPlayer().func_180425_c()) < 260100.0)) continue;
            ElevatorGroupRenderer.renderGroup(group, e.getPartialTicks());
        }
        GlStateManager.func_179121_F();
    }

    public static void renderGroup(ElevatorGroup group, float partialTicks) {
        if (ClientUtils.getMinecraft().func_175598_ae().func_178634_b()) {
            ElevatorGroupRenderer.renderGroupCageOutlines(group);
        }
        if (!group.isMoving()) {
            return;
        }
        ElevatorCage cage = group.getCage();
        double lastY = group.getLastY();
        double currentY = group.getCurrentY();
        double renderY = lastY + (currentY - lastY) * (double)partialTicks;
        Vec3d startPos = group.getCageAnchorPos(renderY);
        BlockPos topPos = new BlockPos((double)group.x, renderY, (double)group.z).func_177967_a(group.facing, (int)Math.ceil((float)group.getCageDepth() / 2.0f));
        int currentLight = group.world.func_175626_b(topPos, group.world.func_180495_p(topPos).getLightValue((IBlockAccess)group.world, topPos));
        GlStateManager.func_179145_e();
        ScreenUtils.bindTexture((ResourceLocation)TextureMap.field_110575_b);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < group.getCageSizeX(); ++x) {
            for (int y = 0; y < group.getCageSizeY(); ++y) {
                for (int z = 0; z < group.getCageSizeZ(); ++z) {
                    if (cage.blockStates[x][y][z] == null) continue;
                    buffer.func_178969_c(0.0, startPos.field_72448_b - (double)((int)startPos.field_72448_b), 0.0);
                    try {
                        BlockRendererDispatcher rendererDispatcher = ClientUtils.getBlockRenderer();
                        IBakedModel model = rendererDispatcher.func_184389_a(cage.blockStates[x][y][z]);
                        pos.func_189532_c(startPos.field_72450_a + (double)x, (double)((int)startPos.field_72448_b + y), startPos.field_72449_c + (double)z);
                        rendererDispatcher.func_175019_b().func_187493_a((IBlockAccess)group.world, model, cage.blockStates[x][y][z], (BlockPos)pos, buffer, false, 0L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    buffer.func_178969_c(0.0, 0.0, 0.0);
                }
            }
        }
        Tessellator.func_178181_a().func_78381_a();
        if (ClientUtils.getMinecraft().func_175598_ae().func_178634_b()) {
            RenderUtils.renderBox((AxisAlignedBB)new AxisAlignedBB(startPos, startPos.func_72441_c((double)group.getCageSizeX(), (double)group.getCageSizeY(), (double)group.getCageSizeZ())), (float)1.0f, (float)0.0f, (float)0.0f);
            RenderUtils.renderShape((BlockShape)cage.shape.offset(startPos.field_72450_a, startPos.field_72448_b, startPos.field_72449_c), (float)0.19215687f, (float)0.8784314f, (float)0.85882354f);
            RenderUtils.resetState();
        }
    }

    public static void renderGroupCageOutlines(ElevatorGroup group) {
        for (int floor = 0; floor < group.getFloorCount(); ++floor) {
            BlockPos anchorPos = group.getCageAnchorBlockPos(group.getFloorYLevel(floor));
            AxisAlignedBB cageArea = new AxisAlignedBB(anchorPos, anchorPos.func_177982_a(group.getCageSizeX(), group.getCageSizeY(), group.getCageSizeZ()));
            cageArea.func_186662_g(0.01);
            RenderUtils.enableDepthTest();
            RenderUtils.renderBox((AxisAlignedBB)cageArea, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtils.resetState();
        }
    }
}

