/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui.preview;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.movingelevators.gui.preview.WorldBlockCapture;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;

public class ElevatorPreviewRenderer {
    private static final LightGatheringTransformer lightGatherer = new LightGatheringTransformer();

    public static void renderPreview(WorldBlockCapture capture, AxisAlignedBB cabinBox, AxisAlignedBB previewBox, double x, double y, double scale, float yaw, float pitch, boolean doShading) {
        AxisAlignedBB bounds = capture.getBounds();
        Vec3d center = bounds.func_189972_c();
        double span = Math.sqrt((bounds.field_72336_d - bounds.field_72340_a) * (bounds.field_72336_d - bounds.field_72340_a) + (bounds.field_72337_e - bounds.field_72338_b) * (bounds.field_72337_e - bounds.field_72338_b) + (bounds.field_72334_f - bounds.field_72339_c) * (bounds.field_72334_f - bounds.field_72339_c));
        scale /= span;
        ScreenUtils.bindTexture((ResourceLocation)TextureMap.field_110575_b);
        ClientUtils.getTextureManager().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (doShading) {
            RenderHelper.func_74520_c();
        } else {
            GlStateManager.func_179140_f();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)350.0);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)(-center.field_72450_a), (double)(-center.field_72448_b), (double)(-center.field_72449_c));
        for (BlockPos pos : capture.getBlockLocations()) {
            ElevatorPreviewRenderer.renderBlock(capture, pos);
        }
        if (doShading) {
            GlStateManager.func_179140_f();
        }
        RenderUtils.renderBox((AxisAlignedBB)cabinBox, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        if (previewBox != null) {
            RenderUtils.renderBox((AxisAlignedBB)previewBox, (float)0.0f, (float)0.7f, (float)0.0f, (float)0.8f);
        }
        GlStateManager.func_179121_F();
        ClientUtils.getTextureManager().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179118_c();
        GlStateManager.func_179101_C();
    }

    private static void renderBlock(WorldBlockCapture capture, BlockPos pos) {
        TileEntity blockEntity;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
        IBlockState state = capture.getBlockState(pos);
        if (state.func_177230_c() != Blocks.field_150350_a) {
            IBakedModel model = ClientUtils.getBlockRenderer().func_184389_a(state);
            ElevatorPreviewRenderer.renderLitItem(model);
        }
        if ((blockEntity = capture.getBlockEntity(pos)) != null) {
            TileEntityRendererDispatcher.field_147556_a.func_192855_a(blockEntity, 0.0, 0.0, 0.0, ClientUtils.getPartialTicks(), -1.0f);
        }
        GlStateManager.func_179121_F();
    }

    public static void renderLitItem(IBakedModel model) {
        ArrayList allquads = new ArrayList();
        for (EnumFacing enumfacing : EnumFacing.values()) {
            allquads.addAll(model.func_188616_a(null, enumfacing, 0L));
        }
        allquads.addAll(model.func_188616_a(null, null, 0L));
        if (allquads.isEmpty()) {
            return;
        }
        ArrayList<BakedQuad> segment = new ArrayList<BakedQuad>();
        int segmentBlockLight = 0;
        int segmentSkyLight = 0;
        boolean segmentShading = true;
        boolean segmentLightingDirty = false;
        boolean segmentShadingDirty = false;
        boolean hasLighting = false;
        for (int i = 0; i < allquads.size(); ++i) {
            boolean shadeDirty;
            BakedQuad q = (BakedQuad)allquads.get(i);
            int bl = 0;
            int sl = 0;
            if (q.getFormat() != DefaultVertexFormats.field_176599_b && q.getFormat().func_177347_a(1)) {
                q.pipe((IVertexConsumer)lightGatherer);
                if (lightGatherer.hasLighting()) {
                    bl = ElevatorPreviewRenderer.lightGatherer.blockLight;
                    sl = ElevatorPreviewRenderer.lightGatherer.skyLight;
                }
            }
            boolean shade = q.shouldApplyDiffuseLighting();
            boolean lightingDirty = segmentBlockLight != bl || segmentSkyLight != sl;
            boolean bl2 = shadeDirty = shade != segmentShading;
            if (lightingDirty || shadeDirty) {
                if (i > 0) {
                    ElevatorPreviewRenderer.drawSegment(segment, segmentBlockLight, segmentSkyLight, segmentShading, segmentLightingDirty && (hasLighting || segment.size() < i), segmentShadingDirty);
                }
                segmentBlockLight = bl;
                segmentSkyLight = sl;
                segmentShading = shade;
                segmentLightingDirty = lightingDirty;
                segmentShadingDirty = shadeDirty;
                hasLighting = segmentBlockLight > 0 || segmentSkyLight > 0 || !segmentShading;
            }
            segment.add(q);
        }
        ElevatorPreviewRenderer.drawSegment(segment, segmentBlockLight, segmentSkyLight, segmentShading, segmentLightingDirty && (hasLighting || segment.size() < allquads.size()), segmentShadingDirty);
        if (hasLighting) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)OpenGlHelper.lastBrightnessX, (float)OpenGlHelper.lastBrightnessY);
            GlStateManager.func_179145_e();
        }
    }

    private static void drawSegment(List<BakedQuad> segment, int bl, int sl, boolean shade, boolean updateLighting, boolean updateShading) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        float lastBl = OpenGlHelper.lastBrightnessX;
        float lastSl = OpenGlHelper.lastBrightnessY;
        if (updateShading) {
            if (shade) {
                GlStateManager.func_179145_e();
            } else {
                GlStateManager.func_179140_f();
            }
        }
        if (updateLighting) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)Math.max((float)bl, lastBl), (float)Math.max((float)sl, lastSl));
        }
        ClientUtils.getItemRenderer().func_191970_a(bufferbuilder, segment, -1, ItemStack.field_190927_a);
        Tessellator.func_178181_a().func_78381_a();
        OpenGlHelper.lastBrightnessX = lastBl;
        OpenGlHelper.lastBrightnessY = lastSl;
        segment.clear();
    }

    private static class LightGatheringTransformer
    extends QuadGatheringTransformer {
        private static final VertexFormat FORMAT = new VertexFormat().func_181721_a(DefaultVertexFormats.field_181715_o).func_181721_a(DefaultVertexFormats.field_181716_p);
        int blockLight;
        int skyLight;

        private LightGatheringTransformer() {
            this.setVertexFormat(FORMAT);
        }

        boolean hasLighting() {
            return this.dataLength[1] >= 2;
        }

        protected void processQuad() {
            this.blockLight = 0;
            this.skyLight = 0;
            for (int i = 0; i < 4; ++i) {
                this.blockLight += (int)(this.quadData[1][i][0] * 65535.0f / 32.0f);
                this.skyLight += (int)(this.quadData[1][i][1] * 65535.0f / 32.0f);
            }
            this.blockLight *= 4;
            this.skyLight *= 4;
        }

        public void setQuadTint(int tint) {
        }

        public void setQuadOrientation(EnumFacing orientation) {
        }

        public void setApplyDiffuseLighting(boolean diffuse) {
        }

        public void setTexture(TextureAtlasSprite texture) {
        }
    }
}

